/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io.serializer.avro;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.serializer.SerializationFactory;
import org.apache.hadoop.io.serializer.SerializationTestUtil;
import org.apache.hadoop.io.serializer.avro.AvroRecord;
import org.apache.hadoop.io.serializer.avro.AvroReflectSerializable;
import org.apache.hadoop.io.serializer.avro.Record;
import org.junit.Assert;
import org.junit.Test;

public class TestAvroSerialization {
    private static final Configuration conf = new Configuration();

    @Test
    public void testSpecific() throws Exception {
        AvroRecord before = new AvroRecord();
        before.setIntField(5);
        AvroRecord after = SerializationTestUtil.testSerialization(conf, before);
        Assert.assertEquals((Object)((Object)before), (Object)((Object)after));
    }

    @Test
    public void testReflectPkg() throws Exception {
        Record before = new Record();
        before.x = 10;
        conf.set("avro.reflect.pkgs", before.getClass().getPackage().getName());
        Record after = SerializationTestUtil.testSerialization(conf, before);
        Assert.assertEquals((Object)before, (Object)after);
    }

    @Test
    public void testAcceptHandlingPrimitivesAndArrays() throws Exception {
        SerializationFactory factory = new SerializationFactory(conf);
        Assert.assertNull((Object)factory.getSerializer(byte[].class));
        Assert.assertNull((Object)factory.getSerializer(Byte.TYPE));
    }

    @Test
    public void testReflectInnerClass() throws Exception {
        InnerRecord before = new InnerRecord();
        before.x = 10;
        conf.set("avro.reflect.pkgs", before.getClass().getPackage().getName());
        InnerRecord after = SerializationTestUtil.testSerialization(conf, before);
        Assert.assertEquals((Object)before, (Object)after);
    }

    @Test
    public void testReflect() throws Exception {
        RefSerializable before = new RefSerializable();
        before.x = 10;
        RefSerializable after = SerializationTestUtil.testSerialization(conf, before);
        Assert.assertEquals((Object)before, (Object)after);
    }

    public static class InnerRecord {
        public int x = 7;

        public int hashCode() {
            return this.x;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            InnerRecord other = (InnerRecord)obj;
            return this.x == other.x;
        }
    }

    public static class RefSerializable
    implements AvroReflectSerializable {
        public int x = 7;

        public int hashCode() {
            return this.x;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            RefSerializable other = (RefSerializable)obj;
            return this.x == other.x;
        }
    }
}

