/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.GenericWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.TestWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestGenericWritable {
    private Configuration conf;
    public static final String CONF_TEST_KEY = "test.generic.writable";
    public static final String CONF_TEST_VALUE = "dummy";

    @Before
    public void setUp() throws Exception {
        this.conf = new Configuration();
        this.conf.set(CONF_TEST_KEY, CONF_TEST_VALUE);
    }

    @Test
    public void testFooWritable() throws Exception {
        System.out.println("Testing Writable wrapped in GenericWritable");
        FooGenericWritable generic = new FooGenericWritable();
        generic.setConf(this.conf);
        Foo foo = new Foo();
        generic.set(foo);
        TestWritable.testWritable((Writable)generic);
    }

    @Test
    public void testBarWritable() throws Exception {
        System.out.println("Testing Writable, Configurable wrapped in GenericWritable");
        FooGenericWritable generic = new FooGenericWritable();
        generic.setConf(this.conf);
        Bar bar = new Bar();
        bar.setConf(this.conf);
        generic.set(bar);
        FooGenericWritable after = (FooGenericWritable)TestWritable.testWritable((Writable)generic, this.conf);
        System.out.println("Testing if Configuration is passed to wrapped classes");
        Assert.assertTrue((boolean)(after.get() instanceof Configurable));
        Assert.assertNotNull((Object)((Configurable)after.get()).getConf());
    }

    @Test
    public void testBazWritable() throws Exception {
        System.out.println("Testing for GenericWritable to find class names");
        FooGenericWritable generic = new FooGenericWritable();
        generic.setConf(this.conf);
        Baz baz = new Baz();
        generic.set(baz);
        TestWritable.testWritable((Writable)generic, this.conf);
    }

    @Test
    public void testSet() throws Exception {
        Foo foo = new Foo();
        FooGenericWritable generic = new FooGenericWritable();
        generic.set(foo);
        try {
            generic = new FooGenericWritable();
            generic.set((Writable)new IntWritable(1));
            Assert.fail((String)"Generic writable should have thrown an exception for a Writable not registered");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    @Test
    public void testGet() throws Exception {
        Foo foo = new Foo();
        FooGenericWritable generic = new FooGenericWritable();
        generic.set(foo);
        Assert.assertEquals((Object)foo, (Object)generic.get());
    }

    public static class FooGenericWritable
    extends GenericWritable {
        protected Class<? extends Writable>[] getTypes() {
            return new Class[]{Foo.class, Bar.class, Baz.class};
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof FooGenericWritable)) {
                return false;
            }
            return this.get().equals(((FooGenericWritable)((Object)obj)).get());
        }
    }

    public static class Foo
    implements Writable {
        private String foo = "foo";

        public void readFields(DataInput in) throws IOException {
            this.foo = Text.readString((DataInput)in);
        }

        public void write(DataOutput out) throws IOException {
            Text.writeString((DataOutput)out, (String)this.foo);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Foo)) {
                return false;
            }
            return this.foo.equals(((Foo)obj).foo);
        }
    }

    public static class Bar
    implements Writable,
    Configurable {
        private int bar = 42;
        private Configuration conf = null;

        public void readFields(DataInput in) throws IOException {
            this.bar = in.readInt();
        }

        public void write(DataOutput out) throws IOException {
            out.writeInt(this.bar);
        }

        public Configuration getConf() {
            return this.conf;
        }

        public void setConf(Configuration conf) {
            this.conf = conf;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Bar)) {
                return false;
            }
            return this.bar == ((Bar)obj).bar;
        }
    }

    public static class Baz
    extends Bar {
        @Override
        public void readFields(DataInput in) throws IOException {
            super.readFields(in);
            Assert.assertEquals((String)"Configuration is not set for the wrapped object", (Object)TestGenericWritable.CONF_TEST_VALUE, (Object)this.getConf().get(TestGenericWritable.CONF_TEST_KEY));
        }

        @Override
        public void write(DataOutput out) throws IOException {
            super.write(out);
        }
    }
}

