/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.http;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.GeneralSecurityException;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.http.HttpServer2;
import org.apache.hadoop.http.HttpServerFunctionalTest;
import org.apache.hadoop.http.TestHttpServer;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.ssl.KeyStoreTestUtil;
import org.apache.hadoop.security.ssl.SSLFactory;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.util.Shell;
import org.apache.hadoop.util.StringUtils;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestSSLHttpServer
extends HttpServerFunctionalTest {
    private static final String BASEDIR = GenericTestUtils.getTempPath(TestSSLHttpServer.class.getSimpleName());
    private static final Logger LOG = LoggerFactory.getLogger(TestSSLHttpServer.class);
    private static final String HTTPS_CIPHER_SUITES_KEY = "https.cipherSuites";
    private static final String JAVAX_NET_DEBUG_KEY = "javax.net.debug";
    static final String SSL_SERVER_KEYSTORE_PROP_PREFIX = "ssl.server.keystore";
    static final String SSL_SERVER_TRUSTSTORE_PROP_PREFIX = "ssl.server.truststore";
    static final String SERVLET_NAME_LONGHEADER = "longheader";
    static final String SERVLET_PATH_LONGHEADER = "/longheader";
    static final String SERVLET_NAME_ECHO = "echo";
    static final String SERVLET_PATH_ECHO = "/echo";
    private static HttpServer2 server;
    private static String keystoreDir;
    private static String sslConfDir;
    private static SSLFactory clientSslFactory;
    private static String cipherSuitesPropertyValue;
    private static String sslDebugPropertyValue;
    static final String EXCLUDED_CIPHERS = "TLS_ECDHE_RSA_WITH_RC4_128_SHA,SSL_DHE_RSA_EXPORT_WITH_DES40_CBC_SHA, \nSSL_RSA_WITH_DES_CBC_SHA,SSL_DHE_RSA_WITH_DES_CBC_SHA,  SSL_RSA_EXPORT_WITH_RC4_40_MD5,\t \nSSL_RSA_EXPORT_WITH_DES40_CBC_SHA,SSL_RSA_WITH_RC4_128_MD5 \t";
    private static final String ONE_ENABLED_CIPHERS_TLS1_2 = "TLS_ECDHE_RSA_WITH_RC4_128_SHA,SSL_DHE_RSA_EXPORT_WITH_DES40_CBC_SHA, \nSSL_RSA_WITH_DES_CBC_SHA,SSL_DHE_RSA_WITH_DES_CBC_SHA,  SSL_RSA_EXPORT_WITH_RC4_40_MD5,\t \nSSL_RSA_EXPORT_WITH_DES40_CBC_SHA,SSL_RSA_WITH_RC4_128_MD5 \t,TLS_RSA_WITH_AES_128_CBC_SHA";
    private static final String ONE_ENABLED_CIPHERS_TLS1_3 = "TLS_ECDHE_RSA_WITH_RC4_128_SHA,SSL_DHE_RSA_EXPORT_WITH_DES40_CBC_SHA, \nSSL_RSA_WITH_DES_CBC_SHA,SSL_DHE_RSA_WITH_DES_CBC_SHA,  SSL_RSA_EXPORT_WITH_RC4_40_MD5,\t \nSSL_RSA_EXPORT_WITH_DES40_CBC_SHA,SSL_RSA_WITH_RC4_128_MD5 \t,TLS_AES_128_GCM_SHA256";
    private static final String EXCLUSIVE_ENABLED_CIPHERS_TLS1_2 = "\tTLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA, \nTLS_ECDHE_RSA_WITH_AES_128_CBC_SHA,TLS_RSA_WITH_AES_128_CBC_SHA,TLS_ECDH_ECDSA_WITH_AES_128_CBC_SHA,  TLS_ECDH_RSA_WITH_AES_128_CBC_SHA,TLS_DHE_RSA_WITH_AES_128_CBC_SHA,\t\n TLS_DHE_DSS_WITH_AES_128_CBC_SHA";
    private static final String EXCLUSIVE_ENABLED_CIPHERS_TLS1_3 = "\tTLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA, \nTLS_ECDHE_RSA_WITH_AES_128_CBC_SHA,TLS_RSA_WITH_AES_128_CBC_SHA,TLS_ECDH_ECDSA_WITH_AES_128_CBC_SHA,  TLS_ECDH_RSA_WITH_AES_128_CBC_SHA,TLS_DHE_RSA_WITH_AES_128_CBC_SHA,\t\n TLS_DHE_DSS_WITH_AES_128_CBC_SHA,TLS_AES_128_GCM_SHA256";
    static final String INCLUDED_PROTOCOLS = "TLSv1.2";
    static final String INCLUDED_PROTOCOLS_JDK11 = "TLSv1.3,TLSv1.2";

    @BeforeClass
    public static void setup() throws Exception {
        TestSSLHttpServer.turnOnSSLDebugLogging();
        TestSSLHttpServer.storeHttpsCipherSuites();
        Configuration conf = new Configuration();
        conf.setInt("hadoop.http.max.threads", 10);
        File base = new File(BASEDIR);
        FileUtil.fullyDelete((File)base);
        base.mkdirs();
        keystoreDir = new File(BASEDIR).getAbsolutePath();
        sslConfDir = KeyStoreTestUtil.getClasspathDir(TestSSLHttpServer.class);
        KeyStoreTestUtil.setupSSLConfig(keystoreDir, sslConfDir, conf, false, true, EXCLUDED_CIPHERS);
        Configuration sslConf = KeyStoreTestUtil.getSslConfig();
        clientSslFactory = new SSLFactory(SSLFactory.Mode.CLIENT, sslConf);
        clientSslFactory.init();
        TestSSLHttpServer.setupServer(conf, sslConf);
        baseUrl = new URL("https://" + NetUtils.getHostPortString((InetSocketAddress)server.getConnectorAddress(0)));
        LOG.info("HTTP server started: " + baseUrl);
    }

    private static void setupServer(Configuration conf, Configuration sslConf) throws IOException, URISyntaxException {
        conf.set("hadoop.ssl.enabled.protocols", INCLUDED_PROTOCOLS);
        sslConf.set("hadoop.ssl.enabled.protocols", INCLUDED_PROTOCOLS);
        server = new HttpServer2.Builder().setName("test").addEndpoint(new URI("https://localhost")).setConf(conf).keyPassword(sslConf.get("ssl.server.keystore.keypassword")).keyStore(sslConf.get("ssl.server.keystore.location"), sslConf.get("ssl.server.keystore.password"), sslConf.get("ssl.server.keystore.type", "jks")).trustStore(sslConf.get("ssl.server.truststore.location"), sslConf.get("ssl.server.truststore.password"), sslConf.get("ssl.server.truststore.type", "jks")).excludeCiphers(sslConf.get("ssl.server.exclude.cipher.list")).includeCiphers(sslConf.get("ssl.server.include.cipher.list")).build();
        server.addServlet(SERVLET_NAME_ECHO, SERVLET_PATH_ECHO, TestHttpServer.EchoServlet.class);
        server.addServlet(SERVLET_NAME_LONGHEADER, SERVLET_PATH_LONGHEADER, HttpServerFunctionalTest.LongHeaderServlet.class);
        server.start();
    }

    @AfterClass
    public static void cleanup() throws Exception {
        server.stop();
        FileUtil.fullyDelete((File)new File(BASEDIR));
        KeyStoreTestUtil.cleanupSSLConfig(keystoreDir, sslConfDir);
        clientSslFactory.destroy();
        TestSSLHttpServer.restoreHttpsCipherSuites();
        TestSSLHttpServer.restoreSSLDebugLogging();
    }

    static void storeHttpsCipherSuites() {
        String cipherSuites = System.getProperty(HTTPS_CIPHER_SUITES_KEY);
        if (cipherSuites != null) {
            LOG.info("Found value for property {}: {}", (Object)HTTPS_CIPHER_SUITES_KEY, (Object)cipherSuites);
            cipherSuitesPropertyValue = cipherSuites;
        }
        System.clearProperty(HTTPS_CIPHER_SUITES_KEY);
    }

    static void restoreHttpsCipherSuites() {
        if (cipherSuitesPropertyValue != null) {
            LOG.info("Restoring property {} to value: {}", (Object)HTTPS_CIPHER_SUITES_KEY, (Object)cipherSuitesPropertyValue);
            System.setProperty(HTTPS_CIPHER_SUITES_KEY, cipherSuitesPropertyValue);
            cipherSuitesPropertyValue = null;
        }
    }

    static void turnOnSSLDebugLogging() {
        String sslDebug = System.getProperty(JAVAX_NET_DEBUG_KEY);
        if (sslDebug != null) {
            sslDebugPropertyValue = sslDebug;
        }
        System.setProperty(JAVAX_NET_DEBUG_KEY, "all");
    }

    static void restoreSSLDebugLogging() {
        if (sslDebugPropertyValue != null) {
            System.setProperty(JAVAX_NET_DEBUG_KEY, sslDebugPropertyValue);
            sslDebugPropertyValue = null;
        } else {
            System.clearProperty(JAVAX_NET_DEBUG_KEY);
        }
    }

    private HttpsURLConnection getConnectionWithSSLSocketFactory(URL url, String ciphers) throws IOException, GeneralSecurityException {
        HttpsURLConnection conn = (HttpsURLConnection)url.openConnection();
        SSLSocketFactory sslSocketFactory = clientSslFactory.createSSLSocketFactory();
        LOG.info("Creating " + PreferredCipherSSLSocketFactory.class.getCanonicalName() + " with ciphers: " + ciphers);
        PreferredCipherSSLSocketFactory cipherSSLSocketFactory = new PreferredCipherSSLSocketFactory(sslSocketFactory, StringUtils.getTrimmedStrings((String)ciphers));
        conn.setSSLSocketFactory(cipherSSLSocketFactory);
        return conn;
    }

    private HttpsURLConnection getConnectionWithPreferredProtocolSSLSocketFactory(URL url, String protocols) throws IOException, GeneralSecurityException {
        HttpsURLConnection conn = (HttpsURLConnection)url.openConnection();
        SSLSocketFactory sslSocketFactory = clientSslFactory.createSSLSocketFactory();
        LOG.info("Creating " + PreferredProtocolSSLSocketFactory.class.getCanonicalName() + " with protocols: " + protocols);
        PreferredProtocolSSLSocketFactory cipherSSLSocketFactory = new PreferredProtocolSSLSocketFactory(sslSocketFactory, StringUtils.getTrimmedStrings((String)protocols));
        conn.setSSLSocketFactory(cipherSSLSocketFactory);
        return conn;
    }

    @Test
    public void testEcho() throws Exception {
        TestSSLHttpServer.assertEquals((Object)"a:b\nc:d\n", (Object)TestSSLHttpServer.readFromURL(new URL(baseUrl, "/echo?a=b&c=d")));
        TestSSLHttpServer.assertEquals((Object)"a:b\nc&lt;:d\ne:&gt;\n", (Object)TestSSLHttpServer.readFromURL(new URL(baseUrl, "/echo?a=b&c<=d&e=>")));
    }

    @Test
    public void testLongHeader() throws Exception {
        URL url = new URL(baseUrl, SERVLET_PATH_LONGHEADER);
        HttpsURLConnection conn = (HttpsURLConnection)url.openConnection();
        conn.setSSLSocketFactory(clientSslFactory.createSSLSocketFactory());
        this.testLongHeader(conn);
    }

    private static String readFromURL(URL url) throws Exception {
        HttpsURLConnection conn = (HttpsURLConnection)url.openConnection();
        conn.setSSLSocketFactory(clientSslFactory.createSSLSocketFactory());
        return TestSSLHttpServer.readFromConnection(conn);
    }

    private static String readFromConnection(HttpsURLConnection conn) throws IOException {
        InputStream in = conn.getInputStream();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        IOUtils.copyBytes((InputStream)in, (OutputStream)out, (int)1024);
        return out.toString();
    }

    @Test
    public void testExcludedCiphers() throws Exception {
        URL url = new URL(baseUrl, "/echo?a=b&c=d");
        HttpsURLConnection conn = this.getConnectionWithSSLSocketFactory(url, EXCLUDED_CIPHERS);
        TestSSLHttpServer.assertFalse((String)"excludedCipher list is empty", (boolean)EXCLUDED_CIPHERS.isEmpty());
        try {
            TestSSLHttpServer.readFromConnection(conn);
            TestSSLHttpServer.fail((String)"No Ciphers in common, SSLHandshake must fail.");
        }
        catch (SSLHandshakeException ex) {
            LOG.info("No Ciphers in common, expected successful test result.", (Throwable)ex);
        }
    }

    @Test
    public void testIncludedProtocols() throws Exception {
        URL url = new URL(baseUrl, "/echo?a=b&c=d");
        String includedProtocols = INCLUDED_PROTOCOLS;
        if (Shell.isJavaVersionAtLeast((int)11)) {
            includedProtocols = INCLUDED_PROTOCOLS_JDK11;
        }
        HttpsURLConnection conn = this.getConnectionWithPreferredProtocolSSLSocketFactory(url, includedProtocols);
        TestSSLHttpServer.assertFalse((String)"included protocol list is empty", (boolean)includedProtocols.isEmpty());
        TestSSLHttpServer.readFromConnection(conn);
        PreferredProtocolSSLSocketFactory factory = (PreferredProtocolSSLSocketFactory)conn.getSSLSocketFactory();
        if (Shell.isJavaVersionAtLeast((int)11)) {
            TestSSLHttpServer.assertEquals((Object)"TLSv1.3", (Object)factory.getSocket().getSession().getProtocol());
        } else {
            TestSSLHttpServer.assertEquals((Object)INCLUDED_PROTOCOLS, (Object)factory.getSocket().getSession().getProtocol());
        }
    }

    @Test
    public void testOneEnabledCiphers() throws Exception {
        if (Shell.isJavaVersionAtLeast((int)11)) {
            this.testEnabledCiphers(ONE_ENABLED_CIPHERS_TLS1_3);
        } else {
            this.testEnabledCiphers(ONE_ENABLED_CIPHERS_TLS1_2);
        }
    }

    @Test
    public void testExclusiveEnabledCiphers() throws Exception {
        if (Shell.isJavaVersionAtLeast((int)11)) {
            this.testEnabledCiphers(EXCLUSIVE_ENABLED_CIPHERS_TLS1_3);
        } else {
            this.testEnabledCiphers(EXCLUSIVE_ENABLED_CIPHERS_TLS1_2);
        }
    }

    private void testEnabledCiphers(String ciphers) throws IOException, GeneralSecurityException {
        URL url = new URL(baseUrl, "/echo?a=b&c=d");
        HttpsURLConnection conn = this.getConnectionWithSSLSocketFactory(url, ciphers);
        TestSSLHttpServer.assertFalse((String)"excludedCipher list is empty", (boolean)ciphers.isEmpty());
        String out = TestSSLHttpServer.readFromConnection(conn);
        TestSSLHttpServer.assertEquals((Object)out, (Object)"a:b\nc:d\n");
        LOG.info("At least one additional enabled cipher than excluded ciphers, expected successful test result.");
    }

    private class PreferredCipherSSLSocketFactory
    extends SSLSocketFactory {
        private final SSLSocketFactory delegateSocketFactory;
        private final String[] enabledCipherSuites;

        PreferredCipherSSLSocketFactory(SSLSocketFactory sslSocketFactory, String[] pEnabledCipherSuites) {
            this.delegateSocketFactory = sslSocketFactory;
            this.enabledCipherSuites = null != pEnabledCipherSuites && pEnabledCipherSuites.length > 0 ? pEnabledCipherSuites : null;
        }

        @Override
        public String[] getDefaultCipherSuites() {
            return this.delegateSocketFactory.getDefaultCipherSuites();
        }

        @Override
        public String[] getSupportedCipherSuites() {
            return this.delegateSocketFactory.getSupportedCipherSuites();
        }

        @Override
        public Socket createSocket(Socket socket, String string, int i, boolean bln) throws IOException {
            SSLSocket sslSocket = (SSLSocket)this.delegateSocketFactory.createSocket(socket, string, i, bln);
            this.setEnabledCipherSuites(sslSocket);
            return sslSocket;
        }

        @Override
        public Socket createSocket(String string, int i) throws IOException {
            SSLSocket sslSocket = (SSLSocket)this.delegateSocketFactory.createSocket(string, i);
            this.setEnabledCipherSuites(sslSocket);
            return sslSocket;
        }

        @Override
        public Socket createSocket(String string, int i, InetAddress ia, int i1) throws IOException {
            SSLSocket sslSocket = (SSLSocket)this.delegateSocketFactory.createSocket(string, i, ia, i1);
            this.setEnabledCipherSuites(sslSocket);
            return sslSocket;
        }

        @Override
        public Socket createSocket(InetAddress ia, int i) throws IOException {
            SSLSocket sslSocket = (SSLSocket)this.delegateSocketFactory.createSocket(ia, i);
            this.setEnabledCipherSuites(sslSocket);
            return sslSocket;
        }

        @Override
        public Socket createSocket(InetAddress ia, int i, InetAddress ia1, int i1) throws IOException {
            SSLSocket sslSocket = (SSLSocket)this.delegateSocketFactory.createSocket(ia, i, ia1, i1);
            this.setEnabledCipherSuites(sslSocket);
            return sslSocket;
        }

        private void setEnabledCipherSuites(SSLSocket sslSocket) {
            if (null != this.enabledCipherSuites) {
                sslSocket.setEnabledCipherSuites(this.enabledCipherSuites);
            }
        }
    }

    private class PreferredProtocolSSLSocketFactory
    extends SSLSocketFactory {
        private final SSLSocketFactory delegateSocketFactory;
        private final String[] enabledProtocols;
        private SSLSocket sslSocket;

        PreferredProtocolSSLSocketFactory(SSLSocketFactory sslSocketFactory, String[] enabledProtocols) {
            this.delegateSocketFactory = sslSocketFactory;
            this.enabledProtocols = null != enabledProtocols && enabledProtocols.length > 0 ? enabledProtocols : null;
        }

        public SSLSocket getSocket() {
            return this.sslSocket;
        }

        @Override
        public String[] getDefaultCipherSuites() {
            return this.delegateSocketFactory.getDefaultCipherSuites();
        }

        @Override
        public String[] getSupportedCipherSuites() {
            return this.delegateSocketFactory.getSupportedCipherSuites();
        }

        @Override
        public Socket createSocket(Socket socket, String string, int i, boolean bln) throws IOException {
            this.sslSocket = (SSLSocket)this.delegateSocketFactory.createSocket(socket, string, i, bln);
            this.setEnabledProtocols(this.sslSocket);
            return this.sslSocket;
        }

        @Override
        public Socket createSocket(String string, int i) throws IOException {
            this.sslSocket = (SSLSocket)this.delegateSocketFactory.createSocket(string, i);
            this.setEnabledProtocols(this.sslSocket);
            return this.sslSocket;
        }

        @Override
        public Socket createSocket(String string, int i, InetAddress ia, int i1) throws IOException {
            this.sslSocket = (SSLSocket)this.delegateSocketFactory.createSocket(string, i, ia, i1);
            this.setEnabledProtocols(this.sslSocket);
            return this.sslSocket;
        }

        @Override
        public Socket createSocket(InetAddress ia, int i) throws IOException {
            this.sslSocket = (SSLSocket)this.delegateSocketFactory.createSocket(ia, i);
            this.setEnabledProtocols(this.sslSocket);
            return this.sslSocket;
        }

        @Override
        public Socket createSocket(InetAddress ia, int i, InetAddress ia1, int i1) throws IOException {
            this.sslSocket = (SSLSocket)this.delegateSocketFactory.createSocket(ia, i, ia1, i1);
            this.setEnabledProtocols(this.sslSocket);
            return this.sslSocket;
        }

        private void setEnabledProtocols(SSLSocket sslSocket) {
            if (null != this.enabledProtocols) {
                sslSocket.setEnabledProtocols(this.enabledProtocols);
            }
        }
    }
}

