/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.http;

import java.io.File;
import java.io.IOException;
import java.net.HttpCookie;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.http.FilterContainer;
import org.apache.hadoop.http.FilterInitializer;
import org.apache.hadoop.http.HttpServer2;
import org.apache.hadoop.http.TestHttpCookieFlag;
import org.apache.hadoop.http.TestHttpServer;
import org.apache.hadoop.http.TestSSLHttpServer;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.authentication.server.AuthenticationFilter;
import org.apache.hadoop.security.ssl.KeyStoreTestUtil;
import org.apache.hadoop.test.GenericTestUtils;
import org.eclipse.jetty.util.log.Log;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class TestAuthenticationSessionCookie {
    private static final String BASEDIR = GenericTestUtils.getTempPath(TestHttpCookieFlag.class.getSimpleName());
    private static boolean isCookiePersistent;
    private static final long TOKEN_VALIDITY_SEC = 1000L;
    private static long expires;
    private static String keystoresDir;
    private static String sslConfDir;
    private static HttpServer2 server;

    public void startServer(boolean isTestSessionCookie) throws Exception {
        Configuration conf = new Configuration();
        if (isTestSessionCookie) {
            conf.set("hadoop.http.filter.initializers", DummyFilterInitializer.class.getName());
        } else {
            conf.set("hadoop.http.filter.initializers", Dummy2FilterInitializer.class.getName());
        }
        File base = new File(BASEDIR);
        FileUtil.fullyDelete((File)base);
        base.mkdirs();
        keystoresDir = new File(BASEDIR).getAbsolutePath();
        sslConfDir = KeyStoreTestUtil.getClasspathDir(TestSSLHttpServer.class);
        KeyStoreTestUtil.setupSSLConfig(keystoresDir, sslConfDir, conf, false);
        Configuration sslConf = KeyStoreTestUtil.getSslConfig();
        server = new HttpServer2.Builder().setName("test").addEndpoint(new URI("http://localhost")).addEndpoint(new URI("https://localhost")).setConf(conf).keyPassword(sslConf.get("ssl.server.keystore.keypassword")).keyStore(sslConf.get("ssl.server.keystore.location"), sslConf.get("ssl.server.keystore.password"), sslConf.get("ssl.server.keystore.type", "jks")).trustStore(sslConf.get("ssl.server.truststore.location"), sslConf.get("ssl.server.truststore.password"), sslConf.get("ssl.server.truststore.type", "jks")).build();
        server.addServlet("echo", "/echo", TestHttpServer.EchoServlet.class);
        server.start();
    }

    @Test
    public void testSessionCookie() throws IOException {
        try {
            this.startServer(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        URL base = new URL("http://" + NetUtils.getHostPortString((InetSocketAddress)server.getConnectorAddress(0)));
        HttpURLConnection conn = (HttpURLConnection)new URL(base, "/echo").openConnection();
        String header = conn.getHeaderField("Set-Cookie");
        List<HttpCookie> cookies = HttpCookie.parse(header);
        Assert.assertTrue((!cookies.isEmpty() ? 1 : 0) != 0);
        Log.getLog().info(header, new Object[0]);
        Assert.assertFalse((boolean)header.contains("; Expires="));
        Assert.assertTrue((boolean)"token".equals(cookies.get(0).getValue()));
    }

    @Test
    public void testPersistentCookie() throws IOException {
        try {
            this.startServer(false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        URL base = new URL("http://" + NetUtils.getHostPortString((InetSocketAddress)server.getConnectorAddress(0)));
        HttpURLConnection conn = (HttpURLConnection)new URL(base, "/echo").openConnection();
        String header = conn.getHeaderField("Set-Cookie");
        List<HttpCookie> cookies = HttpCookie.parse(header);
        Assert.assertTrue((!cookies.isEmpty() ? 1 : 0) != 0);
        Log.getLog().info(header, new Object[0]);
        Assert.assertTrue((boolean)header.contains("; Expires="));
        Assert.assertTrue((boolean)"token".equals(cookies.get(0).getValue()));
    }

    @After
    public void cleanup() throws Exception {
        server.stop();
        FileUtil.fullyDelete((File)new File(BASEDIR));
        KeyStoreTestUtil.cleanupSSLConfig(keystoresDir, sslConfDir);
    }

    public static class DummyFilterInitializer
    extends FilterInitializer {
        public void initFilter(FilterContainer container, Configuration conf) {
            container.addFilter("DummyAuth", DummyAuthenticationFilter.class.getName(), new HashMap());
        }
    }

    public static class Dummy2FilterInitializer
    extends FilterInitializer {
        public void initFilter(FilterContainer container, Configuration conf) {
            container.addFilter("Dummy2Auth", Dummy2AuthenticationFilter.class.getName(), new HashMap());
        }
    }

    public static class Dummy2AuthenticationFilter
    extends DummyAuthenticationFilter {
        @Override
        public void init(FilterConfig filterConfig) throws ServletException {
            isCookiePersistent = true;
            expires = System.currentTimeMillis() + 1000L;
        }

        @Override
        public void destroy() {
        }
    }

    public static class DummyAuthenticationFilter
    implements Filter {
        public void init(FilterConfig filterConfig) throws ServletException {
            isCookiePersistent = false;
        }

        public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
            HttpServletResponse resp = (HttpServletResponse)response;
            AuthenticationFilter.createAuthCookie((HttpServletResponse)resp, (String)"token", null, null, (long)expires, (boolean)isCookiePersistent, (boolean)true);
            chain.doFilter(request, (ServletResponse)resp);
        }

        public void destroy() {
        }
    }
}

