/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.shell;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.shell.Command;
import org.apache.hadoop.fs.shell.CommandFactory;
import org.apache.hadoop.fs.shell.FsCommand;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestCommandFactory {
    static CommandFactory factory;
    static Configuration conf;

    static void registerCommands(CommandFactory factory) {
    }

    @Before
    public void testSetup() {
        factory = new CommandFactory(conf);
        Assert.assertNotNull((Object)factory);
    }

    @Test
    public void testRegistration() {
        Assert.assertArrayEquals((Object[])new String[0], (Object[])factory.getNames());
        factory.registerCommands(TestRegistrar.class);
        Object[] names = factory.getNames();
        Assert.assertArrayEquals((Object[])new String[]{"tc1", "tc2", "tc2.1"}, (Object[])names);
        factory.addClass(TestCommand3.class, new String[]{"tc3"});
        names = factory.getNames();
        Assert.assertArrayEquals((Object[])new String[]{"tc1", "tc2", "tc2.1", "tc3"}, (Object[])names);
        factory.addClass(TestCommand4.class, new String[]{new TestCommand4().getName()});
        names = factory.getNames();
        Assert.assertArrayEquals((Object[])new String[]{"tc1", "tc2", "tc2.1", "tc3", "tc4"}, (Object[])names);
    }

    @Test
    public void testGetInstances() {
        factory.registerCommands(TestRegistrar.class);
        Command instance = factory.getInstance("blarg");
        Assert.assertNull((Object)instance);
        instance = factory.getInstance("tc1");
        Assert.assertNotNull((Object)instance);
        Assert.assertEquals(TestCommand1.class, instance.getClass());
        Assert.assertEquals((Object)"tc1", (Object)instance.getCommandName());
        instance = factory.getInstance("tc2");
        Assert.assertNotNull((Object)instance);
        Assert.assertEquals(TestCommand2.class, instance.getClass());
        Assert.assertEquals((Object)"tc2", (Object)instance.getCommandName());
        instance = factory.getInstance("tc2.1");
        Assert.assertNotNull((Object)instance);
        Assert.assertEquals(TestCommand2.class, instance.getClass());
        Assert.assertEquals((Object)"tc2.1", (Object)instance.getCommandName());
        factory.addClass(TestCommand4.class, new String[]{"tc4"});
        instance = factory.getInstance("tc4");
        Assert.assertNotNull((Object)instance);
        Assert.assertEquals(TestCommand4.class, instance.getClass());
        Assert.assertEquals((Object)"tc4", (Object)instance.getCommandName());
        String usage = instance.getUsage();
        Assert.assertEquals((Object)"-tc4 tc4_usage", (Object)usage);
        Assert.assertEquals((Object)"tc4_description", (Object)instance.getDescription());
    }

    static {
        conf = new Configuration();
    }

    static class TestRegistrar {
        TestRegistrar() {
        }

        public static void registerCommands(CommandFactory factory) {
            factory.addClass(TestCommand1.class, new String[]{"tc1"});
            factory.addClass(TestCommand2.class, new String[]{"tc2", "tc2.1"});
        }
    }

    static class TestCommand3
    extends FsCommand {
        TestCommand3() {
        }
    }

    static class TestCommand4
    extends FsCommand {
        static final String NAME = "tc4";
        static final String USAGE = "tc4_usage";
        static final String DESCRIPTION = "tc4_description";

        TestCommand4() {
        }
    }

    static class TestCommand1
    extends FsCommand {
        TestCommand1() {
        }
    }

    static class TestCommand2
    extends FsCommand {
        TestCommand2() {
        }
    }
}

