/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.impl;

import java.util.EnumSet;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.impl.FlagSet;
import org.apache.hadoop.test.AbstractHadoopTestBase;
import org.apache.hadoop.test.LambdaTestUtils;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.IterableAssert;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.ObjectAssert;
import org.junit.Test;

public final class TestFlagSet
extends AbstractHadoopTestBase {
    private static final String KEY = "key";
    public static final String CAPABILITY_B = "key.b";
    public static final String CAPABILITY_C = "key.c";
    public static final String CAPABILITY_A = "key.a";
    private static final String KEYDOT = "key.";
    private FlagSet<SimpleEnum> flagSet = FlagSet.createFlagSet(SimpleEnum.class, (String)"key.", EnumSet.noneOf(SimpleEnum.class));

    @Test
    public void testEntryEnableDisable() {
        Assertions.assertThat((Iterable)this.flagSet.flags()).isEmpty();
        this.assertDisabled(SimpleEnum.a);
        this.flagSet.enable((Enum)SimpleEnum.a);
        this.assertEnabled(SimpleEnum.a);
        this.flagSet.disable((Enum)SimpleEnum.a);
        this.assertDisabled(SimpleEnum.a);
    }

    @Test
    public void testSetMethod() {
        Assertions.assertThat((Iterable)this.flagSet.flags()).isEmpty();
        this.flagSet.set((Enum)SimpleEnum.a, true);
        this.assertEnabled(SimpleEnum.a);
        this.flagSet.set((Enum)SimpleEnum.a, false);
        this.assertDisabled(SimpleEnum.a);
    }

    @Test
    public void testMutability() throws Throwable {
        this.flagSet.set((Enum)SimpleEnum.a, true);
        this.flagSet.makeImmutable();
        LambdaTestUtils.intercept(IllegalStateException.class, () -> this.flagSet.disable((Enum)SimpleEnum.a));
        this.assertEnabled(SimpleEnum.a);
        LambdaTestUtils.intercept(IllegalStateException.class, () -> this.flagSet.set((Enum)SimpleEnum.a, false));
        this.assertEnabled(SimpleEnum.a);
        LambdaTestUtils.intercept(IllegalStateException.class, () -> this.flagSet.enable((Enum)SimpleEnum.b));
        this.assertDisabled(SimpleEnum.b);
        LambdaTestUtils.intercept(IllegalStateException.class, () -> this.flagSet.set((Enum)SimpleEnum.b, true));
        this.assertDisabled(SimpleEnum.b);
    }

    @Test
    public void testToString() throws Throwable {
        this.assertStringValue("{}");
        this.assertConfigurationStringMatches("");
        this.flagSet.enable((Enum)SimpleEnum.a);
        this.assertStringValue("{a}");
        this.assertConfigurationStringMatches("a");
        this.flagSet.enable((Enum)SimpleEnum.b);
        this.assertStringValue("{a, b}");
    }

    private void assertStringValue(String expected) {
        Assertions.assertThat((String)this.flagSet.toString()).isEqualTo((Object)expected);
    }

    public void assertConfigurationStringMatches(String expected) {
        ((AbstractStringAssert)Assertions.assertThat((String)this.flagSet.toConfigurationString()).describedAs("Configuration string of %s", new Object[]{this.flagSet})).isEqualTo((Object)expected);
    }

    @Test
    public void testConfEntry() {
        this.flagSet = TestFlagSet.flagSetFromConfig("a\t,\nc ", true);
        this.assertFlagSetMatches(this.flagSet, SimpleEnum.a, SimpleEnum.c);
        this.assertHasCapability(CAPABILITY_A);
        this.assertHasCapability(CAPABILITY_C);
        this.assertLacksCapability(CAPABILITY_B);
        this.assertPathCapabilitiesMatch(this.flagSet, CAPABILITY_A, CAPABILITY_C);
    }

    private static FlagSet<SimpleEnum> flagSetFromConfig(String string, boolean ignoreUnknown) {
        Configuration conf = TestFlagSet.mkConf(string);
        return FlagSet.buildFlagSet(SimpleEnum.class, (Configuration)conf, (String)KEY, (boolean)ignoreUnknown);
    }

    @Test
    public void testConfEntryWithUnknownIgnored() {
        this.flagSet = TestFlagSet.flagSetFromConfig("a, unknown", true);
        this.assertFlagSetMatches(this.flagSet, SimpleEnum.a);
        this.assertHasCapability(CAPABILITY_A);
        this.assertLacksCapability(CAPABILITY_B);
        this.assertLacksCapability(CAPABILITY_C);
    }

    @Test
    public void testDuplicateConfEntry() {
        this.flagSet = TestFlagSet.flagSetFromConfig("a,\ta,\na\"", true);
        this.assertFlagSetMatches(this.flagSet, SimpleEnum.a);
        this.assertHasCapability(CAPABILITY_A);
    }

    @Test
    public void testConfUnknownFailure() throws Throwable {
        LambdaTestUtils.intercept(IllegalArgumentException.class, () -> TestFlagSet.flagSetFromConfig("a, unknown", false));
    }

    private static Configuration mkConf(String value) {
        Configuration conf = new Configuration(false);
        conf.set(KEY, value);
        return conf;
    }

    private void assertHasCapability(String capability) {
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.flagSet.hasCapability(capability)).describedAs("Capability of %s on %s", new Object[]{capability, this.flagSet})).isTrue();
    }

    private void assertLacksCapability(String capability) {
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.flagSet.hasCapability(capability)).describedAs("Capability of %s on %s", new Object[]{capability, this.flagSet})).isFalse();
    }

    @Test
    public void testStarEntry() {
        this.flagSet = TestFlagSet.flagSetFromConfig("*", false);
        this.assertFlags(SimpleEnum.a, SimpleEnum.b, SimpleEnum.c);
        this.assertHasCapability(CAPABILITY_A);
        this.assertHasCapability(CAPABILITY_B);
        ((ListAssert)Assertions.assertThat((List)this.flagSet.pathCapabilities()).describedAs("path capabilities of %s", new Object[]{this.flagSet})).containsExactlyInAnyOrder((Object[])new String[]{CAPABILITY_A, CAPABILITY_B, CAPABILITY_C});
    }

    @Test
    public void testRoundTrip() {
        FlagSet s1 = FlagSet.createFlagSet(SimpleEnum.class, (String)KEYDOT, EnumSet.allOf(SimpleEnum.class));
        FlagSet<SimpleEnum> s2 = this.roundTrip((FlagSet<SimpleEnum>)s1);
        Assertions.assertThat((Iterable)s1.flags()).isEqualTo((Object)s2.flags());
        this.assertFlagSetMatches(s2, SimpleEnum.a, SimpleEnum.b, SimpleEnum.c);
    }

    @Test
    public void testEmptyRoundTrip() {
        FlagSet s1 = FlagSet.createFlagSet(SimpleEnum.class, (String)KEYDOT, EnumSet.noneOf(SimpleEnum.class));
        FlagSet<SimpleEnum> s2 = this.roundTrip((FlagSet<SimpleEnum>)s1);
        Assertions.assertThat((Iterable)s1.flags()).isEqualTo((Object)s2.flags());
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)s2.isEmpty()).describedAs("empty flagset %s", new Object[]{s2})).isTrue();
        this.assertFlagSetMatches(this.flagSet, new SimpleEnum[0]);
        ((ListAssert)Assertions.assertThat((List)this.flagSet.pathCapabilities()).describedAs("path capabilities of %s", new Object[]{this.flagSet})).isEmpty();
    }

    @Test
    public void testSetIsClone() {
        EnumSet<SimpleEnum> flags = EnumSet.noneOf(SimpleEnum.class);
        FlagSet s1 = FlagSet.createFlagSet(SimpleEnum.class, (String)KEYDOT, flags);
        s1.enable((Enum)SimpleEnum.b);
        flags.add(SimpleEnum.a);
        this.assertFlagSetMatches((FlagSet<SimpleEnum>)s1, SimpleEnum.b);
    }

    @Test
    public void testEquality() {
        FlagSet s1 = FlagSet.createFlagSet(SimpleEnum.class, (String)KEYDOT, (Enum[])new SimpleEnum[]{SimpleEnum.a});
        FlagSet s2 = FlagSet.createFlagSet(SimpleEnum.class, (String)KEYDOT, (Enum[])new SimpleEnum[]{SimpleEnum.a});
        s2.makeImmutable();
        ((ObjectAssert)Assertions.assertThat((Object)s1).describedAs("s1 == s2", new Object[0])).isEqualTo((Object)s2);
        ((AbstractIntegerAssert)Assertions.assertThat((int)s1.hashCode()).describedAs("hashcode of s1 == hashcode of s2", new Object[0])).isEqualTo(s2.hashCode());
    }

    @Test
    public void testInequality() {
        FlagSet s1 = FlagSet.createFlagSet(SimpleEnum.class, (String)KEYDOT, EnumSet.noneOf(SimpleEnum.class));
        FlagSet s2 = FlagSet.createFlagSet(SimpleEnum.class, (String)KEYDOT, (Enum[])new SimpleEnum[]{SimpleEnum.a, SimpleEnum.b});
        ((ObjectAssert)Assertions.assertThat((Object)s1).describedAs("s1 == s2", new Object[0])).isNotEqualTo((Object)s2);
    }

    @Test
    public void testClassInequality() {
        FlagSet s1 = FlagSet.createFlagSet(SimpleEnum.class, (String)KEYDOT, EnumSet.noneOf(SimpleEnum.class));
        FlagSet s2 = FlagSet.createFlagSet(OtherEnum.class, (String)KEYDOT, (Enum[])new OtherEnum[]{OtherEnum.a});
        ((ObjectAssert)Assertions.assertThat((Object)s1).describedAs("s1 == s2", new Object[0])).isNotEqualTo((Object)s2);
    }

    @Test
    public void testCopy() throws Throwable {
        FlagSet s1 = FlagSet.createFlagSet(SimpleEnum.class, (String)KEYDOT, (Enum[])new SimpleEnum[]{SimpleEnum.a, SimpleEnum.b});
        s1.makeImmutable();
        FlagSet s2 = s1.copy();
        ((ObjectAssert)Assertions.assertThat((Object)s2).describedAs("copy of %s", new Object[]{s1})).isNotSameAs((Object)s1);
        ((AbstractBooleanAssert)Assertions.assertThat((!s2.isImmutable() ? 1 : 0) != 0).describedAs("set %s is immutable", new Object[]{s2})).isTrue();
        ((ObjectAssert)Assertions.assertThat((Object)s1).describedAs("s1 == s2", new Object[0])).isEqualTo((Object)s2);
    }

    @Test
    public void testCreateNullEnumClass() throws Throwable {
        LambdaTestUtils.intercept(NullPointerException.class, () -> FlagSet.createFlagSet(null, (String)KEYDOT, (Enum[])new SimpleEnum[]{SimpleEnum.a}));
    }

    @Test
    public void testCreateNullPrefix() throws Throwable {
        LambdaTestUtils.intercept(NullPointerException.class, () -> FlagSet.createFlagSet(SimpleEnum.class, null, (Enum[])new SimpleEnum[]{SimpleEnum.a}));
    }

    private FlagSet<SimpleEnum> roundTrip(FlagSet<SimpleEnum> flagset) {
        Configuration conf = new Configuration(false);
        conf.set(KEY, flagset.toConfigurationString());
        return FlagSet.buildFlagSet(SimpleEnum.class, (Configuration)conf, (String)KEY, (boolean)false);
    }

    private void assertEnabled(SimpleEnum flag) {
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.flagSet.enabled((Enum)flag)).describedAs("status of flag %s in %s", new Object[]{flag, this.flagSet})).isTrue();
    }

    private void assertDisabled(SimpleEnum flag) {
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.flagSet.enabled((Enum)flag)).describedAs("status of flag %s in %s", new Object[]{flag, this.flagSet})).isFalse();
    }

    private void assertFlags(SimpleEnum ... flags) {
        for (SimpleEnum flag : flags) {
            this.assertEnabled(flag);
        }
    }

    private void assertFlagSetMatches(FlagSet<SimpleEnum> fs, SimpleEnum ... flags) {
        ((IterableAssert)Assertions.assertThat((Iterable)fs.flags()).describedAs("path capabilities of %s", new Object[]{fs})).containsExactly((Object[])flags);
    }

    private void assertPathCapabilitiesMatch(FlagSet<SimpleEnum> fs, String ... capabilities) {
        ((ListAssert)Assertions.assertThat((List)fs.pathCapabilities()).describedAs("path capabilities of %s", new Object[]{fs})).containsExactlyInAnyOrder((Object[])capabilities);
    }

    private static enum SimpleEnum {
        a,
        b,
        c;

    }

    private static enum OtherEnum {
        a;

    }
}

