/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.eclipse.jetty.websocket.common.message;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.hadoop.shaded.org.eclipse.jetty.util.BufferUtil;
import org.apache.hadoop.shaded.org.eclipse.jetty.util.ByteArrayOutputStream2;
import org.apache.hadoop.shaded.org.eclipse.jetty.websocket.common.events.EventDriver;
import org.apache.hadoop.shaded.org.eclipse.jetty.websocket.common.message.MessageAppender;

public class SimpleBinaryMessage
implements MessageAppender {
    private static final int BUFFER_SIZE = 65535;
    private final EventDriver onEvent;
    protected ByteArrayOutputStream2 out;
    private int size;
    protected boolean finished;

    public SimpleBinaryMessage(EventDriver onEvent) {
        this.onEvent = onEvent;
        this.finished = false;
    }

    @Override
    public void appendFrame(ByteBuffer payload, boolean isLast) throws IOException {
        if (this.finished) {
            throw new IOException("Cannot append to finished buffer");
        }
        if (payload == null) {
            return;
        }
        this.onEvent.getPolicy().assertValidBinaryMessageSize(this.size + payload.remaining());
        this.size += payload.remaining();
        if (this.out == null) {
            this.out = isLast ? new ByteArrayOutputStream2(this.size) : new ByteArrayOutputStream2(65535);
        }
        BufferUtil.writeTo((ByteBuffer)payload, (OutputStream)this.out);
    }

    @Override
    public void messageComplete() {
        this.finished = true;
        byte[] data = this.out == null ? new byte[]{} : (this.out.getCount() == this.out.getBuf().length ? this.out.getBuf() : this.out.toByteArray());
        this.onEvent.onBinaryMessage(data);
    }
}

