/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.eclipse.jetty.websocket.client;

import java.net.CookieStore;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.shaded.org.eclipse.jetty.http.HttpField;
import org.apache.hadoop.shaded.org.eclipse.jetty.http.HttpFields;
import org.apache.hadoop.shaded.org.eclipse.jetty.util.MultiMap;
import org.apache.hadoop.shaded.org.eclipse.jetty.util.StringUtil;
import org.apache.hadoop.shaded.org.eclipse.jetty.util.UrlEncoded;
import org.apache.hadoop.shaded.org.eclipse.jetty.websocket.api.extensions.ExtensionConfig;
import org.apache.hadoop.shaded.org.eclipse.jetty.websocket.client.WebSocketUpgradeRequest;
import org.apache.hadoop.shaded.org.eclipse.jetty.websocket.common.UpgradeRequestAdapter;

public class ClientUpgradeRequest
extends UpgradeRequestAdapter {
    private static final Set<String> FORBIDDEN_HEADERS = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
    private final String key = this.genRandomKey();
    private Object localEndpoint;
    private long timeout;

    public ClientUpgradeRequest() {
    }

    protected ClientUpgradeRequest(URI requestURI) {
        super(requestURI);
    }

    public ClientUpgradeRequest(WebSocketUpgradeRequest wsRequest) {
        this(wsRequest.getURI());
        this.setCookies(wsRequest.getCookies());
        HashMap<String, List<String>> headers = new HashMap<String, List<String>>();
        HttpFields fields = wsRequest.getHeaders();
        for (HttpField field : fields) {
            String key = field.getName();
            ArrayList<String> values = (ArrayList<String>)headers.get(key);
            if (values == null) {
                values = new ArrayList<String>();
            }
            values.addAll(Arrays.asList(field.getValues()));
            headers.put(key, values);
            if (key.equalsIgnoreCase("Sec-WebSocket-Protocol")) {
                for (String subProtocol : field.getValue().split(",")) {
                    this.setSubProtocols(subProtocol);
                }
            }
            if (!key.equalsIgnoreCase("Sec-WebSocket-Extensions")) continue;
            for (ExtensionConfig ext : ExtensionConfig.parseList(field.getValues())) {
                this.addExtensions(ext);
            }
        }
        super.setHeaders(headers);
        this.setHttpVersion(wsRequest.getVersion().toString());
        this.setMethod(wsRequest.getMethod());
    }

    private final String genRandomKey() {
        byte[] bytes = new byte[16];
        ThreadLocalRandom.current().nextBytes(bytes);
        return Base64.getEncoder().encodeToString(bytes);
    }

    public String getKey() {
        return this.key;
    }

    @Deprecated
    public void setCookiesFrom(CookieStore cookieStore) {
        throw new UnsupportedOperationException("Request specific CookieStore no longer supported");
    }

    @Override
    public void setRequestURI(URI uri) {
        super.setRequestURI(uri);
        HashMap<String, List<String>> pmap = new HashMap<String, List<String>>();
        String query = uri.getRawQuery();
        if (StringUtil.isNotBlank((String)query)) {
            MultiMap params = new MultiMap();
            UrlEncoded.decodeTo((String)query, (MultiMap)params, (Charset)StandardCharsets.UTF_8);
            for (String key : params.keySet()) {
                List values = params.getValues(key);
                if (values == null) {
                    pmap.put(key, new ArrayList());
                    continue;
                }
                ArrayList copy = new ArrayList();
                copy.addAll(values);
                pmap.put(key, copy);
            }
            super.setParameterMap(pmap);
        }
    }

    public void setTimeout(long timeout, TimeUnit unit) {
        this.timeout = unit.toMillis(timeout);
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setLocalEndpoint(Object websocket) {
        this.localEndpoint = websocket;
    }

    public Object getLocalEndpoint() {
        return this.localEndpoint;
    }

    static {
        FORBIDDEN_HEADERS.add("cookie");
        FORBIDDEN_HEADERS.add("upgrade");
        FORBIDDEN_HEADERS.add("host");
        FORBIDDEN_HEADERS.add("connection");
        FORBIDDEN_HEADERS.add("sec-websocket-key");
        FORBIDDEN_HEADERS.add("sec-websocket-extensions");
        FORBIDDEN_HEADERS.add("sec-websocket-accept");
        FORBIDDEN_HEADERS.add("sec-websocket-protocol");
        FORBIDDEN_HEADERS.add("sec-websocket-version");
        FORBIDDEN_HEADERS.add("pragma");
        FORBIDDEN_HEADERS.add("cache-control");
    }
}

