/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.eclipse.jetty.webapp;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.function.Consumer;
import org.apache.hadoop.shaded.org.eclipse.jetty.util.TopologicalSort;
import org.apache.hadoop.shaded.org.eclipse.jetty.util.resource.Resource;
import org.apache.hadoop.shaded.org.eclipse.jetty.webapp.FragmentDescriptor;
import org.apache.hadoop.shaded.org.eclipse.jetty.webapp.MetaData;
import org.apache.hadoop.shaded.org.eclipse.jetty.webapp.Ordering;

public class RelativeOrdering
implements Ordering {
    protected MetaData _metaData;

    public RelativeOrdering(MetaData metaData) {
        this._metaData = metaData;
    }

    @Override
    public List<Resource> order(List<Resource> jars) {
        TopologicalSort sort = new TopologicalSort();
        ArrayList<Resource> sorted = new ArrayList<Resource>(jars);
        HashSet<Resource> others = new HashSet<Resource>();
        HashSet<Resource> beforeOthers = new HashSet<Resource>();
        HashSet<Resource> afterOthers = new HashSet<Resource>();
        for (Resource jar : jars) {
            FragmentDescriptor fragment = this._metaData.getFragment(jar);
            if (fragment == null) {
                others.add(jar);
                continue;
            }
            switch (fragment.getOtherType()) {
                case None: {
                    others.add(jar);
                    break;
                }
                case Before: {
                    beforeOthers.add(jar);
                    break;
                }
                case After: {
                    afterOthers.add(jar);
                }
            }
        }
        HashSet<Resource> referenced = new HashSet<Resource>();
        for (Resource jar : jars) {
            FragmentDescriptor fragment = this._metaData.getFragment(jar);
            if (fragment != null) {
                for (String name : fragment.getAfters()) {
                    Resource after = this._metaData.getJarForFragment(name);
                    sort.addDependency((Object)jar, (Object)after);
                    referenced.add(after);
                }
                for (String name : fragment.getBefores()) {
                    Resource before = this._metaData.getJarForFragment(name);
                    sort.addDependency((Object)before, (Object)jar);
                    referenced.add(before);
                }
                switch (fragment.getOtherType()) {
                    case None: {
                        break;
                    }
                    case Before: {
                        Consumer<Resource> addBefore = other -> {
                            if (!referenced.contains(other)) {
                                sort.addDependency(other, (Object)jar);
                            }
                        };
                        others.forEach(addBefore);
                        afterOthers.forEach(addBefore);
                        break;
                    }
                    case After: {
                        Consumer<Resource> addAfter = other -> {
                            if (!referenced.contains(other)) {
                                sort.addDependency((Object)jar, other);
                            }
                        };
                        beforeOthers.forEach(addAfter);
                        others.forEach(addAfter);
                    }
                }
            }
            referenced.clear();
        }
        sort.sort(sorted);
        return sorted;
    }
}

