/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.net.jodah.failsafe;

import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import org.apache.hadoop.shaded.net.jodah.failsafe.AbstractExecution;
import org.apache.hadoop.shaded.net.jodah.failsafe.ExecutionResult;
import org.apache.hadoop.shaded.net.jodah.failsafe.FailsafeFuture;
import org.apache.hadoop.shaded.net.jodah.failsafe.FailurePolicy;
import org.apache.hadoop.shaded.net.jodah.failsafe.Policy;
import org.apache.hadoop.shaded.net.jodah.failsafe.PolicyListeners;
import org.apache.hadoop.shaded.net.jodah.failsafe.util.concurrent.Scheduler;

public abstract class PolicyExecutor<R, P extends Policy<R>> {
    protected final P policy;
    protected final AbstractExecution<R> execution;
    int policyIndex;

    protected PolicyExecutor(P policy, AbstractExecution<R> execution) {
        this.policy = policy;
        this.execution = execution;
    }

    protected ExecutionResult preExecute() {
        return null;
    }

    protected Supplier<ExecutionResult> supply(Supplier<ExecutionResult> supplier, Scheduler scheduler) {
        return () -> {
            ExecutionResult result = this.preExecute();
            if (result != null) {
                this.execution.preExecute();
                return result;
            }
            return this.postExecute((ExecutionResult)supplier.get());
        };
    }

    protected ExecutionResult postExecute(ExecutionResult result) {
        this.execution.recordAttempt();
        if (this.isFailure(result)) {
            result = this.onFailure(result.withFailure());
            this.callFailureListener(result);
        } else {
            result = result.withSuccess();
            this.onSuccess(result);
            this.callSuccessListener(result);
        }
        return result;
    }

    protected Supplier<CompletableFuture<ExecutionResult>> supplyAsync(Supplier<CompletableFuture<ExecutionResult>> supplier, Scheduler scheduler, FailsafeFuture<R> future) {
        return () -> {
            ExecutionResult result = this.preExecute();
            if (result != null) {
                this.execution.preExecute();
                return CompletableFuture.completedFuture(result);
            }
            return ((CompletableFuture)supplier.get()).thenCompose(r -> r == null ? ExecutionResult.NULL_FUTURE : this.postExecuteAsync((ExecutionResult)r, scheduler, future));
        };
    }

    protected CompletableFuture<ExecutionResult> postExecuteAsync(ExecutionResult result, Scheduler scheduler, FailsafeFuture<R> future) {
        this.execution.recordAttempt();
        if (this.isFailure(result)) {
            return this.onFailureAsync(result.withFailure(), scheduler, future).whenComplete((postResult, error) -> this.callFailureListener((ExecutionResult)postResult));
        }
        result = result.withSuccess();
        this.onSuccess(result);
        this.callSuccessListener(result);
        return CompletableFuture.completedFuture(result);
    }

    protected boolean isFailure(ExecutionResult result) {
        if (result.isNonResult()) {
            return false;
        }
        if (this.policy instanceof FailurePolicy) {
            return ((FailurePolicy)this.policy).isFailure(result);
        }
        return result.getFailure() != null;
    }

    protected void onSuccess(ExecutionResult result) {
    }

    protected ExecutionResult onFailure(ExecutionResult result) {
        return result;
    }

    protected CompletableFuture<ExecutionResult> onFailureAsync(ExecutionResult result, Scheduler scheduler, FailsafeFuture<R> future) {
        return CompletableFuture.completedFuture(this.execution.resultHandled ? result : this.onFailure(result));
    }

    boolean executionCancelled() {
        return this.execution.cancelledIndex > this.policyIndex;
    }

    private void callSuccessListener(ExecutionResult result) {
        if (result.isComplete() && this.policy instanceof PolicyListeners) {
            PolicyListeners policyListeners = (PolicyListeners)this.policy;
            if (policyListeners.successListener != null) {
                policyListeners.successListener.handle(result, this.execution);
            }
        }
    }

    private void callFailureListener(ExecutionResult result) {
        if (result.isComplete() && this.policy instanceof PolicyListeners) {
            PolicyListeners policyListeners = (PolicyListeners)this.policy;
            if (policyListeners.failureListener != null) {
                policyListeners.failureListener.handle(result, this.execution);
            }
        }
    }
}

