/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.net.jodah.failsafe;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import org.apache.hadoop.shaded.net.jodah.failsafe.ExecutionResult;
import org.apache.hadoop.shaded.net.jodah.failsafe.Policy;
import org.apache.hadoop.shaded.net.jodah.failsafe.PolicyListeners;
import org.apache.hadoop.shaded.net.jodah.failsafe.internal.util.Assert;

public abstract class FailurePolicy<S, R>
extends PolicyListeners<S, R>
implements Policy<R> {
    boolean failuresChecked;
    List<BiPredicate<R, Throwable>> failureConditions = new ArrayList<BiPredicate<R, Throwable>>();

    FailurePolicy() {
    }

    public S handle(Class<? extends Throwable> failure) {
        Assert.notNull(failure, "failure");
        return this.handle(Arrays.asList(failure));
    }

    @SafeVarargs
    public final S handle(Class<? extends Throwable> ... failures) {
        Assert.notNull(failures, "failures");
        Assert.isTrue(failures.length > 0, "Failures cannot be empty", new Object[0]);
        return this.handle(Arrays.asList(failures));
    }

    public S handle(List<Class<? extends Throwable>> failures) {
        Assert.notNull(failures, "failures");
        Assert.isTrue(!failures.isEmpty(), "failures cannot be empty", new Object[0]);
        this.failuresChecked = true;
        this.failureConditions.add(FailurePolicy.failurePredicateFor(failures));
        return (S)this;
    }

    public S handleIf(Predicate<? extends Throwable> failurePredicate) {
        Assert.notNull(failurePredicate, "failurePredicate");
        this.failuresChecked = true;
        this.failureConditions.add(FailurePolicy.failurePredicateFor(failurePredicate));
        return (S)this;
    }

    public S handleIf(BiPredicate<R, ? extends Throwable> resultPredicate) {
        Assert.notNull(resultPredicate, "resultPredicate");
        this.failuresChecked = true;
        this.failureConditions.add(resultPredicate);
        return (S)this;
    }

    public S handleResult(R result) {
        this.failureConditions.add(FailurePolicy.resultPredicateFor(result));
        return (S)this;
    }

    public S handleResultIf(Predicate<R> resultPredicate) {
        Assert.notNull(resultPredicate, "resultPredicate");
        this.failureConditions.add(FailurePolicy.resultPredicateFor(resultPredicate));
        return (S)this;
    }

    boolean isFailure(ExecutionResult result) {
        return this.failureConditions.isEmpty() ? result.getFailure() != null : this.isFailure(result.getResult(), result.getFailure());
    }

    public boolean isFailure(R result, Throwable failure) {
        for (BiPredicate<R, Throwable> predicate : this.failureConditions) {
            try {
                if (!predicate.test(result, failure)) continue;
                return true;
            }
            catch (Exception exception) {
            }
        }
        return failure != null && !this.failuresChecked;
    }

    static <R> BiPredicate<R, Throwable> resultPredicateFor(R result) {
        return (t2, u) -> result == null ? t2 == null && u == null : Objects.equals(result, t2);
    }

    static <R> BiPredicate<R, Throwable> failurePredicateFor(Predicate<? extends Throwable> failurePredicate) {
        return (t2, u) -> u != null && failurePredicate.test((Throwable)u);
    }

    static <R> BiPredicate<R, Throwable> resultPredicateFor(Predicate<R> resultPredicate) {
        return (t2, u) -> {
            if (u == null) {
                return resultPredicate.test(t2);
            }
            return false;
        };
    }

    static <R> BiPredicate<R, Throwable> failurePredicateFor(List<Class<? extends Throwable>> failures) {
        return (t2, u) -> {
            if (u == null) {
                return false;
            }
            for (Class failureType : failures) {
                if (!failureType.isAssignableFrom(u.getClass())) continue;
                return true;
            }
            return false;
        };
    }
}

