/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.com.nimbusds.jose.crypto;

import javax.crypto.SecretKey;
import org.apache.hadoop.shaded.com.nimbusds.jose.JOSEException;
import org.apache.hadoop.shaded.com.nimbusds.jose.JWSHeader;
import org.apache.hadoop.shaded.com.nimbusds.jose.JWSSigner;
import org.apache.hadoop.shaded.com.nimbusds.jose.KeyLengthException;
import org.apache.hadoop.shaded.com.nimbusds.jose.crypto.impl.HMAC;
import org.apache.hadoop.shaded.com.nimbusds.jose.crypto.impl.MACProvider;
import org.apache.hadoop.shaded.com.nimbusds.jose.jwk.OctetSequenceKey;
import org.apache.hadoop.shaded.com.nimbusds.jose.shaded.jcip.ThreadSafe;
import org.apache.hadoop.shaded.com.nimbusds.jose.util.Base64URL;
import org.apache.hadoop.shaded.com.nimbusds.jose.util.StandardCharset;

@ThreadSafe
public class MACSigner
extends MACProvider
implements JWSSigner {
    public MACSigner(byte[] secret) throws KeyLengthException {
        super(secret);
    }

    public MACSigner(String secretString) throws KeyLengthException {
        this(secretString.getBytes(StandardCharset.UTF_8));
    }

    public MACSigner(SecretKey secretKey) throws KeyLengthException {
        super(secretKey);
    }

    public MACSigner(OctetSequenceKey jwk) throws KeyLengthException {
        this(jwk.toByteArray());
    }

    @Override
    public Base64URL sign(JWSHeader header, byte[] signingInput) throws JOSEException {
        this.ensureSecretLengthSatisfiesAlgorithm(header.getAlgorithm());
        String jcaAlg = MACSigner.getJCAAlgorithmName(header.getAlgorithm());
        byte[] hmac = HMAC.compute(jcaAlg, this.getSecretKey(), signingInput, this.getJCAContext().getProvider());
        return Base64URL.encode(hmac);
    }
}

