/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timelineservice.reader;

import java.util.List;
import org.apache.hadoop.yarn.server.timelineservice.reader.TimelineReaderContext;
import org.apache.hadoop.yarn.server.timelineservice.reader.TimelineReaderUtils;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
enum TimelineFromIdConverter {
    APPLICATION_FROMID{

        @Override
        TimelineReaderContext decodeUID(String fromId) throws Exception {
            if (fromId == null) {
                return null;
            }
            List<String> appTupleList = TimelineReaderUtils.split(fromId);
            if (appTupleList == null || appTupleList.size() != 5) {
                throw new IllegalArgumentException("Invalid row key for application table.");
            }
            return new TimelineReaderContext(appTupleList.get(0), appTupleList.get(1), appTupleList.get(2), Long.parseLong(appTupleList.get(3)), appTupleList.get(4), null, null);
        }
    }
    ,
    SUB_APPLICATION_ENTITY_FROMID{

        @Override
        TimelineReaderContext decodeUID(String fromId) throws Exception {
            if (fromId == null) {
                return null;
            }
            List<String> split = TimelineReaderUtils.split(fromId);
            if (split == null || split.size() != 6) {
                throw new IllegalArgumentException("Invalid row key for sub app table.");
            }
            String subAppUserId = split.get(0);
            String clusterId = split.get(1);
            String entityType = split.get(2);
            Long entityIdPrefix = Long.valueOf(split.get(3));
            String entityId = split.get(4);
            String userId = split.get(5);
            return new TimelineReaderContext(clusterId, userId, null, null, null, entityType, entityIdPrefix, entityId, subAppUserId);
        }
    }
    ,
    GENERIC_ENTITY_FROMID{

        @Override
        TimelineReaderContext decodeUID(String fromId) throws Exception {
            if (fromId == null) {
                return null;
            }
            List<String> split = TimelineReaderUtils.split(fromId);
            if (split == null || split.size() != 8) {
                throw new IllegalArgumentException("Invalid row key for entity table.");
            }
            Long flowRunId = Long.valueOf(split.get(3));
            Long entityIdPrefix = Long.valueOf(split.get(6));
            return new TimelineReaderContext(split.get(0), split.get(1), split.get(2), flowRunId, split.get(4), split.get(5), entityIdPrefix, split.get(7));
        }
    };


    abstract TimelineReaderContext decodeUID(String var1) throws Exception;
}

