/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.scheduler;

import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.api.records.SchedulingRequest;
import org.apache.hadoop.yarn.api.records.UpdateContainerRequest;

public class SchedulerRequestKey
implements Comparable<SchedulerRequestKey> {
    private final Priority priority;
    private final long allocationRequestId;
    private final ContainerId containerToUpdate;

    public static SchedulerRequestKey create(ResourceRequest req) {
        return new SchedulerRequestKey(req.getPriority(), req.getAllocationRequestId(), null);
    }

    public static SchedulerRequestKey create(SchedulingRequest req) {
        return new SchedulerRequestKey(req.getPriority(), req.getAllocationRequestId(), null);
    }

    public static SchedulerRequestKey create(UpdateContainerRequest req, SchedulerRequestKey schedulerRequestKey) {
        return new SchedulerRequestKey(schedulerRequestKey.getPriority(), schedulerRequestKey.getAllocationRequestId(), req.getContainerId());
    }

    public static SchedulerRequestKey extractFrom(Container container) {
        return new SchedulerRequestKey(container.getPriority(), container.getAllocationRequestId(), null);
    }

    public SchedulerRequestKey(Priority priority, long allocationRequestId, ContainerId containerToUpdate) {
        this.priority = priority;
        this.allocationRequestId = allocationRequestId;
        this.containerToUpdate = containerToUpdate;
    }

    public Priority getPriority() {
        return this.priority;
    }

    public long getAllocationRequestId() {
        return this.allocationRequestId;
    }

    public ContainerId getContainerToUpdate() {
        return this.containerToUpdate;
    }

    @Override
    public int compareTo(SchedulerRequestKey o) {
        if (o == null) {
            return this.priority != null ? -1 : 0;
        }
        if (this.priority == null) {
            return 1;
        }
        if (this.containerToUpdate == null && o.containerToUpdate != null) {
            return -1;
        }
        if (this.containerToUpdate != null && o.containerToUpdate == null) {
            return 1;
        }
        int priorityCompare = o.getPriority().compareTo(this.priority);
        if (priorityCompare != 0) {
            return priorityCompare;
        }
        int allocReqCompare = Long.compare(this.allocationRequestId, o.getAllocationRequestId());
        if (allocReqCompare != 0) {
            return allocReqCompare;
        }
        if (this.containerToUpdate != null && o.containerToUpdate != null) {
            return this.containerToUpdate.compareTo(o.containerToUpdate);
        }
        return 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SchedulerRequestKey)) {
            return false;
        }
        SchedulerRequestKey that = (SchedulerRequestKey)o;
        if (this.getAllocationRequestId() != that.getAllocationRequestId()) {
            return false;
        }
        if (!this.getPriority().equals((Object)that.getPriority())) {
            return false;
        }
        return this.containerToUpdate != null ? this.containerToUpdate.equals((Object)that.containerToUpdate) : that.containerToUpdate == null;
    }

    public int hashCode() {
        int result = this.priority != null ? this.priority.hashCode() : 0;
        result = 31 * result + (int)(this.allocationRequestId ^ this.allocationRequestId >>> 32);
        result = 31 * result + (this.containerToUpdate != null ? this.containerToUpdate.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "SchedulerRequestKey{priority=" + this.priority + ", allocationRequestId=" + this.allocationRequestId + ", containerToUpdate=" + this.containerToUpdate + "}";
    }
}

