/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.scheduler;

import java.util.Set;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ExecutionType;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.scheduler.SchedulerRequestKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceRequestSetKey
extends SchedulerRequestKey {
    private static final Logger LOG = LoggerFactory.getLogger(ResourceRequestSetKey.class);
    private final Resource resource;
    private final ExecutionType execType;

    public ResourceRequestSetKey(ResourceRequest rr) throws YarnException {
        this(rr.getAllocationRequestId(), rr.getPriority(), rr.getCapability(), rr.getExecutionTypeRequest() == null ? ExecutionType.GUARANTEED : rr.getExecutionTypeRequest().getExecutionType());
        if (rr.getPriority() == null) {
            throw new YarnException("Null priority in RR: " + rr);
        }
        if (rr.getCapability() == null) {
            throw new YarnException("Null resource in RR: " + rr);
        }
    }

    public ResourceRequestSetKey(long allocationRequestId, Priority priority, Resource resource, ExecutionType execType) {
        super(priority, allocationRequestId, null);
        this.resource = resource == null ? Resource.newInstance((int)0, (int)0) : resource;
        this.execType = execType == null ? ExecutionType.GUARANTEED : execType;
    }

    public Resource getResource() {
        return this.resource;
    }

    public ExecutionType getExeType() {
        return this.execType;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof SchedulerRequestKey)) {
            return false;
        }
        if (!(obj instanceof ResourceRequestSetKey)) {
            return super.equals(obj);
        }
        ResourceRequestSetKey other = (ResourceRequestSetKey)obj;
        return super.equals(other) && this.resource.equals((Object)other.resource) && this.execType.equals((Object)other.execType);
    }

    @Override
    public int hashCode() {
        return (super.hashCode() * 37 + this.resource.hashCode()) * 41 + this.execType.hashCode();
    }

    @Override
    public int compareTo(SchedulerRequestKey other) {
        int ret = super.compareTo(other);
        if (ret != 0) {
            return ret;
        }
        if (!(other instanceof ResourceRequestSetKey)) {
            return ret;
        }
        ResourceRequestSetKey otherKey = (ResourceRequestSetKey)other;
        ret = this.resource.compareTo(otherKey.resource);
        if (ret != 0) {
            return ret;
        }
        return this.execType.compareTo((Enum)otherKey.execType);
    }

    public static ResourceRequestSetKey extractMatchingKey(Container container, Set<ResourceRequestSetKey> keys) {
        ResourceRequestSetKey resourceRequestSetKey = new ResourceRequestSetKey(container.getAllocationRequestId(), container.getPriority(), container.getResource(), container.getExecutionType());
        if (keys.contains(resourceRequestSetKey)) {
            return resourceRequestSetKey;
        }
        if (container.getAllocationRequestId() > 0L) {
            for (ResourceRequestSetKey candidate : keys) {
                if (candidate.getAllocationRequestId() != container.getAllocationRequestId()) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Using possible match for {} : {}", (Object)resourceRequestSetKey, (Object)candidate);
                }
                return candidate;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("not match found for container {}.", (Object)container.getId());
            for (ResourceRequestSetKey candidate : keys) {
                LOG.debug("candidate set keys: {}.", (Object)candidate.toString());
            }
        }
        return null;
    }

    @Override
    public String toString() {
        return "[id:" + this.getAllocationRequestId() + " p:" + this.getPriority().getPriority() + (String)(this.execType.equals((Object)ExecutionType.GUARANTEED) ? " G" : " O r:" + this.resource + "]");
    }
}

