/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.scheduler;

import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.util.Time;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ExecutionType;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceBlacklistRequest;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.api.records.Token;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.security.ContainerTokenIdentifier;
import org.apache.hadoop.yarn.server.api.ContainerType;
import org.apache.hadoop.yarn.server.api.protocolrecords.RemoteNode;
import org.apache.hadoop.yarn.server.scheduler.OpportunisticContainerContext;
import org.apache.hadoop.yarn.server.scheduler.SchedulerRequestKey;
import org.apache.hadoop.yarn.server.security.BaseContainerTokenSecretManager;
import org.apache.hadoop.yarn.server.utils.BuilderUtils;
import org.apache.hadoop.yarn.util.resource.DominantResourceCalculator;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.apache.hadoop.yarn.util.resource.Resources;

public abstract class OpportunisticContainerAllocator {
    private int maxAllocationsPerAMHeartbeat = -1;
    private static final ResourceCalculator RESOURCE_CALCULATOR = new DominantResourceCalculator();
    private final BaseContainerTokenSecretManager tokenSecretManager;

    public OpportunisticContainerAllocator(BaseContainerTokenSecretManager tokenSecretManager) {
        this.tokenSecretManager = tokenSecretManager;
    }

    public OpportunisticContainerAllocator(BaseContainerTokenSecretManager tokenSecretManager, int maxAllocationsPerAMHeartbeat) {
        this.tokenSecretManager = tokenSecretManager;
        this.maxAllocationsPerAMHeartbeat = maxAllocationsPerAMHeartbeat;
    }

    public void setMaxAllocationsPerAMHeartbeat(int maxAllocationsPerAMHeartbeat) {
        this.maxAllocationsPerAMHeartbeat = maxAllocationsPerAMHeartbeat;
    }

    public int getMaxAllocationsPerAMHeartbeat() {
        return this.maxAllocationsPerAMHeartbeat;
    }

    public abstract List<Container> allocateContainers(ResourceBlacklistRequest var1, List<ResourceRequest> var2, ApplicationAttemptId var3, OpportunisticContainerContext var4, long var5, String var7) throws YarnException;

    protected void updateBlacklist(ResourceBlacklistRequest blackList, OpportunisticContainerContext oppContext) {
        if (blackList != null) {
            oppContext.getBlacklist().removeAll(blackList.getBlacklistRemovals());
            oppContext.getBlacklist().addAll(blackList.getBlacklistAdditions());
        }
    }

    protected void matchAllocation(List<Map<Resource, List<Allocation>>> allocations, List<Container> allocatedContainers, OpportunisticContainerContext oppContext) {
        for (Map<Resource, List<Allocation>> allocation : allocations) {
            for (Map.Entry<Resource, List<Allocation>> e : allocation.entrySet()) {
                oppContext.matchAllocationToOutstandingRequest(e.getKey(), e.getValue());
                for (Allocation alloc : e.getValue()) {
                    allocatedContainers.add(alloc.getContainer());
                }
            }
        }
    }

    protected int getTotalAllocations(List<Map<Resource, List<Allocation>>> allocations) {
        int totalAllocs = 0;
        for (Map<Resource, List<Allocation>> allocation : allocations) {
            for (List<Allocation> allocs : allocation.values()) {
                totalAllocs += allocs.size();
            }
        }
        return totalAllocs;
    }

    protected Container createContainer(long rmIdentifier, AllocationParams appParams, ContainerIdGenerator idCounter, ApplicationAttemptId id, String userName, Map<Resource, List<Allocation>> allocations, String location, ResourceRequest anyAsk, RemoteNode rNode) throws YarnException {
        Container container = this.buildContainer(rmIdentifier, appParams, idCounter, anyAsk, id, userName, rNode);
        List<Allocation> allocList = allocations.get(anyAsk.getCapability());
        if (allocList == null) {
            allocList = new ArrayList<Allocation>();
            allocations.put(anyAsk.getCapability(), allocList);
        }
        allocList.add(new Allocation(container, location));
        return container;
    }

    private Container buildContainer(long rmIdentifier, AllocationParams appParams, ContainerIdGenerator idCounter, ResourceRequest rr, ApplicationAttemptId id, String userName, RemoteNode node) throws YarnException {
        ContainerId cId = ContainerId.newContainerId((ApplicationAttemptId)id, (long)idCounter.generateContainerId());
        Resource capability = this.normalizeCapability(appParams, rr);
        return this.createContainer(rmIdentifier, appParams.getContainerTokenExpiryInterval(), SchedulerRequestKey.create(rr), userName, node, cId, capability);
    }

    private Container createContainer(long rmIdentifier, long tokenExpiry, SchedulerRequestKey schedulerKey, String userName, RemoteNode node, ContainerId cId, Resource capability) {
        long currTime = System.currentTimeMillis();
        ContainerTokenIdentifier containerTokenIdentifier = new ContainerTokenIdentifier(cId, 0, node.getNodeId().toString(), userName, capability, currTime + tokenExpiry, this.tokenSecretManager.getCurrentKey().getKeyId(), rmIdentifier, schedulerKey.getPriority(), currTime, null, this.getRemoteNodePartition(node), ContainerType.TASK, ExecutionType.OPPORTUNISTIC, schedulerKey.getAllocationRequestId());
        byte[] pwd = this.tokenSecretManager.createPassword(containerTokenIdentifier);
        Token containerToken = OpportunisticContainerAllocator.newContainerToken(node.getNodeId(), pwd, containerTokenIdentifier);
        Container container = BuilderUtils.newContainer(cId, node.getNodeId(), node.getHttpAddress(), capability, schedulerKey.getPriority(), containerToken, containerTokenIdentifier.getExecutionType(), schedulerKey.getAllocationRequestId());
        return container;
    }

    private Resource normalizeCapability(AllocationParams appParams, ResourceRequest ask) {
        return Resources.normalize((ResourceCalculator)RESOURCE_CALCULATOR, (Resource)ask.getCapability(), (Resource)appParams.minResource, (Resource)appParams.maxResource, (Resource)appParams.incrementResource);
    }

    private static Token newContainerToken(NodeId nodeId, byte[] password, ContainerTokenIdentifier tokenIdentifier) {
        InetSocketAddress addr = NetUtils.createSocketAddrForHost((String)nodeId.getHost(), (int)nodeId.getPort());
        Token containerToken = Token.newInstance((byte[])tokenIdentifier.getBytes(), (String)ContainerTokenIdentifier.KIND.toString(), (byte[])password, (String)SecurityUtil.buildTokenService((InetSocketAddress)addr).toString());
        return containerToken;
    }

    public PartitionedResourceRequests partitionAskList(List<ResourceRequest> askList) {
        PartitionedResourceRequests partitionedRequests = new PartitionedResourceRequests();
        for (ResourceRequest rr : askList) {
            if (rr.getExecutionTypeRequest().getExecutionType() == ExecutionType.OPPORTUNISTIC) {
                partitionedRequests.getOpportunistic().add(rr);
                continue;
            }
            partitionedRequests.getGuaranteed().add(rr);
        }
        return partitionedRequests;
    }

    protected String getRequestPartition(EnrichedResourceRequest enrichedRR) {
        String partition = enrichedRR.getRequest().getNodeLabelExpression();
        if (partition == null) {
            partition = "";
        }
        return partition;
    }

    protected String getRemoteNodePartition(RemoteNode node) {
        String partition = node.getNodePartition();
        if (partition == null) {
            partition = "";
        }
        return partition;
    }

    public static class Allocation {
        private final Container container;
        private final String resourceName;

        public Allocation(Container container, String resourceName) {
            this.container = container;
            this.resourceName = resourceName;
        }

        public Container getContainer() {
            return this.container;
        }

        public String getResourceName() {
            return this.resourceName;
        }
    }

    public static class AllocationParams {
        private Resource maxResource;
        private Resource minResource;
        private Resource incrementResource;
        private int containerTokenExpiryInterval;
        private int maxAllocationsPerSchedulerKeyPerRound = 1;

        public Resource getMaxResource() {
            return this.maxResource;
        }

        public void setMaxResource(Resource maxResource) {
            this.maxResource = maxResource;
        }

        public Resource getMinResource() {
            return this.minResource;
        }

        public void setMinResource(Resource minResource) {
            this.minResource = minResource;
        }

        public Resource getIncrementResource() {
            return this.incrementResource;
        }

        public void setIncrementResource(Resource incrementResource) {
            this.incrementResource = incrementResource;
        }

        public int getContainerTokenExpiryInterval() {
            return this.containerTokenExpiryInterval;
        }

        public void setContainerTokenExpiryInterval(int containerTokenExpiryInterval) {
            this.containerTokenExpiryInterval = containerTokenExpiryInterval;
        }

        public int getMaxAllocationsPerSchedulerKeyPerRound() {
            return this.maxAllocationsPerSchedulerKeyPerRound;
        }

        public void setMaxAllocationsPerSchedulerKeyPerRound(int maxAllocationsPerSchedulerKeyPerRound) {
            this.maxAllocationsPerSchedulerKeyPerRound = maxAllocationsPerSchedulerKeyPerRound;
        }
    }

    public static class ContainerIdGenerator {
        protected volatile AtomicLong containerIdCounter = new AtomicLong(1L);

        public void resetContainerIdCounter(long containerIdStart) {
            this.containerIdCounter.set(containerIdStart);
        }

        public long generateContainerId() {
            return this.containerIdCounter.incrementAndGet();
        }
    }

    public static class PartitionedResourceRequests {
        private List<ResourceRequest> guaranteed = new ArrayList<ResourceRequest>();
        private List<ResourceRequest> opportunistic = new ArrayList<ResourceRequest>();

        public List<ResourceRequest> getGuaranteed() {
            return this.guaranteed;
        }

        public List<ResourceRequest> getOpportunistic() {
            return this.opportunistic;
        }
    }

    public static class EnrichedResourceRequest {
        private final Map<String, AtomicInteger> nodeLocations = new HashMap<String, AtomicInteger>();
        private final Map<String, AtomicInteger> rackLocations = new HashMap<String, AtomicInteger>();
        private final ResourceRequest request;
        private final long timestamp;

        public EnrichedResourceRequest(ResourceRequest request) {
            this.request = request;
            this.timestamp = Time.monotonicNow();
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public ResourceRequest getRequest() {
            return this.request;
        }

        public void addLocation(String location, int count) {
            Map<String, AtomicInteger> m = this.rackLocations;
            if (!location.startsWith("/")) {
                m = this.nodeLocations;
            }
            if (count == 0) {
                m.remove(location);
            } else {
                m.put(location, new AtomicInteger(count));
            }
        }

        public void removeLocation(String location) {
            Map<String, AtomicInteger> m = this.rackLocations;
            AtomicInteger count = m.get(location);
            if (count == null) {
                m = this.nodeLocations;
                count = m.get(location);
            }
            if (count != null && count.decrementAndGet() == 0) {
                m.remove(location);
            }
        }

        public Map<String, AtomicInteger> getNodeMap() {
            return this.nodeLocations;
        }

        public Map<String, AtomicInteger> getRackMap() {
            return this.rackLocations;
        }
    }
}

