/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.security;

import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ExecutionType;
import org.apache.hadoop.yarn.api.records.LogAggregationContext;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.Token;
import org.apache.hadoop.yarn.security.ContainerTokenIdentifier;
import org.apache.hadoop.yarn.server.api.ContainerType;
import org.apache.hadoop.yarn.server.api.records.MasterKey;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.security.BaseContainerTokenSecretManager;
import org.apache.hadoop.yarn.server.security.MasterKeyData;
import org.apache.hadoop.yarn.server.utils.BuilderUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RMContainerTokenSecretManager
extends BaseContainerTokenSecretManager {
    private static final Logger LOG = LoggerFactory.getLogger(RMContainerTokenSecretManager.class);
    private MasterKeyData nextMasterKey;
    private final Timer timer = new Timer();
    private final long rollingInterval;
    private final long activationDelay;

    public RMContainerTokenSecretManager(Configuration conf) {
        super(conf);
        this.rollingInterval = conf.getLong("yarn.resourcemanager.container-tokens.master-key-rolling-interval-secs", 86400L) * 1000L;
        this.activationDelay = (long)((double)conf.getLong("yarn.nm.liveness-monitor.expiry-interval-ms", 600000L) * 1.5);
        LOG.info("ContainerTokenKeyRollingInterval: " + this.rollingInterval + "ms and ContainerTokenKeyActivationDelay: " + this.activationDelay + "ms");
        if (this.rollingInterval <= this.activationDelay * 2L) {
            throw new IllegalArgumentException("yarn.resourcemanager.container-tokens.master-key-rolling-interval-secs should be more than 3 X yarn.nm.liveness-monitor.expiry-interval-ms");
        }
    }

    public void start() {
        this.rollMasterKey();
        this.timer.scheduleAtFixedRate((TimerTask)new MasterKeyRoller(), this.rollingInterval, this.rollingInterval);
    }

    public void stop() {
        this.timer.cancel();
    }

    @InterfaceAudience.Private
    public void rollMasterKey() {
        this.writeLock.lock();
        try {
            LOG.info("Rolling master-key for container-tokens");
            if (this.currentMasterKey == null) {
                this.currentMasterKey = this.createNewMasterKey();
            } else {
                this.nextMasterKey = this.createNewMasterKey();
                LOG.info("Going to activate master-key with key-id " + this.nextMasterKey.getMasterKey().getKeyId() + " in " + this.activationDelay + "ms");
                this.timer.schedule((TimerTask)new NextKeyActivator(), this.activationDelay);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @InterfaceAudience.Private
    public MasterKey getNextKey() {
        this.readLock.lock();
        try {
            if (this.nextMasterKey == null) {
                MasterKey masterKey = null;
                return masterKey;
            }
            MasterKey masterKey = this.nextMasterKey.getMasterKey();
            return masterKey;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @InterfaceAudience.Private
    public void activateNextMasterKey() {
        this.writeLock.lock();
        try {
            LOG.info("Activating next master key with id: " + this.nextMasterKey.getMasterKey().getKeyId());
            this.currentMasterKey = this.nextMasterKey;
            this.nextMasterKey = null;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @VisibleForTesting
    public Token createContainerToken(ContainerId containerId, int containerVersion, NodeId nodeId, String appSubmitter, Resource capability, Priority priority, long createTime) {
        return this.createContainerToken(containerId, containerVersion, nodeId, appSubmitter, capability, priority, createTime, null, null, ContainerType.TASK, ExecutionType.GUARANTEED, -1L, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Token createContainerToken(ContainerId containerId, int containerVersion, NodeId nodeId, String appSubmitter, Resource capability, Priority priority, long createTime, LogAggregationContext logAggregationContext, String nodeLabelExpression, ContainerType containerType, ExecutionType execType, long allocationRequestId, Set<String> allocationTags) {
        byte[] password;
        ContainerTokenIdentifier tokenIdentifier;
        long expiryTimeStamp = System.currentTimeMillis() + this.containerTokenExpiryInterval;
        this.readLock.lock();
        try {
            tokenIdentifier = new ContainerTokenIdentifier(containerId, containerVersion, nodeId.toString(), appSubmitter, capability, expiryTimeStamp, this.currentMasterKey.getMasterKey().getKeyId(), ResourceManager.getClusterTimeStamp(), priority, createTime, logAggregationContext, nodeLabelExpression, containerType, execType, allocationRequestId, allocationTags);
            password = this.createPassword(tokenIdentifier);
        }
        finally {
            this.readLock.unlock();
        }
        return BuilderUtils.newContainerToken(nodeId, password, tokenIdentifier);
    }

    private class MasterKeyRoller
    extends TimerTask {
        private MasterKeyRoller() {
        }

        @Override
        public void run() {
            RMContainerTokenSecretManager.this.rollMasterKey();
        }
    }

    private class NextKeyActivator
    extends TimerTask {
        private NextKeyActivator() {
        }

        @Override
        public void run() {
            RMContainerTokenSecretManager.this.activateNextMasterKey();
        }
    }
}

