/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.converter;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.util.Sets;
import org.apache.hadoop.yarn.server.resourcemanager.placement.DefaultPlacementRule;
import org.apache.hadoop.yarn.server.resourcemanager.placement.FSPlacementRule;
import org.apache.hadoop.yarn.server.resourcemanager.placement.PlacementManager;
import org.apache.hadoop.yarn.server.resourcemanager.placement.PlacementRule;
import org.apache.hadoop.yarn.server.resourcemanager.placement.PrimaryGroupPlacementRule;
import org.apache.hadoop.yarn.server.resourcemanager.placement.RejectPlacementRule;
import org.apache.hadoop.yarn.server.resourcemanager.placement.SecondaryGroupExistingPlacementRule;
import org.apache.hadoop.yarn.server.resourcemanager.placement.SpecifiedPlacementRule;
import org.apache.hadoop.yarn.server.resourcemanager.placement.UserPlacementRule;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.QueuePath;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.placement.schema.MappingRulesDescription;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.placement.schema.Rule;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.converter.FSConfigToCSConfigRuleHandler;

class QueuePlacementConverter {
    private static final Rule.FallbackResult SKIP_RESULT = Rule.FallbackResult.SKIP;
    private static final String DEFAULT_QUEUE = "root.default";
    private static final String MATCH_ALL_USER = "*";
    private static final Set<Rule.Policy> NEED_ROOT_PARENT = Sets.newHashSet((Object[])new Rule.Policy[]{Rule.Policy.USER, Rule.Policy.PRIMARY_GROUP, Rule.Policy.PRIMARY_GROUP_USER, Rule.Policy.SECONDARY_GROUP, Rule.Policy.SECONDARY_GROUP_USER});

    QueuePlacementConverter() {
    }

    MappingRulesDescription convertPlacementPolicy(PlacementManager placementManager, FSConfigToCSConfigRuleHandler ruleHandler, CapacitySchedulerConfiguration convertedCSconfig, boolean usePercentages) {
        MappingRulesDescription desc = new MappingRulesDescription();
        ArrayList<Rule> rules = new ArrayList<Rule>();
        for (PlacementRule fsRule : placementManager.getPlacementRules()) {
            boolean create = ((FSPlacementRule)fsRule).getCreateFlag();
            if (fsRule instanceof UserPlacementRule) {
                UserPlacementRule userRule = (UserPlacementRule)fsRule;
                if (userRule.getParentRule() != null) {
                    this.handleNestedRule(rules, userRule, ruleHandler, create, convertedCSconfig, usePercentages);
                    continue;
                }
                rules.add(this.createRule(Rule.Policy.USER, create, ruleHandler, usePercentages));
                continue;
            }
            if (fsRule instanceof SpecifiedPlacementRule) {
                rules.add(this.createRule(Rule.Policy.SPECIFIED, create, ruleHandler, usePercentages));
                continue;
            }
            if (fsRule instanceof PrimaryGroupPlacementRule) {
                rules.add(this.createRule(Rule.Policy.PRIMARY_GROUP, create, ruleHandler, usePercentages));
                continue;
            }
            if (fsRule instanceof DefaultPlacementRule) {
                Rule rule;
                DefaultPlacementRule defaultRule = (DefaultPlacementRule)fsRule;
                String defaultQueueName = defaultRule.defaultQueueName;
                if (DEFAULT_QUEUE.equals(defaultQueueName)) {
                    rule = this.createRule(Rule.Policy.DEFAULT_QUEUE, create, ruleHandler, usePercentages);
                } else {
                    rule = this.createRule(Rule.Policy.CUSTOM, create, ruleHandler, usePercentages);
                    rule.setCustomPlacement(defaultQueueName);
                }
                rules.add(rule);
                continue;
            }
            if (fsRule instanceof SecondaryGroupExistingPlacementRule) {
                Rule rule = this.createRule(Rule.Policy.SECONDARY_GROUP, create, ruleHandler, usePercentages);
                rules.add(rule);
                continue;
            }
            if (fsRule instanceof RejectPlacementRule) {
                rules.add(this.createRule(Rule.Policy.REJECT, false, ruleHandler, usePercentages));
                continue;
            }
            throw new IllegalArgumentException("Unknown placement rule: " + fsRule);
        }
        desc.setRules(rules);
        return desc;
    }

    private void handleNestedRule(List<Rule> rules, UserPlacementRule userRule, FSConfigToCSConfigRuleHandler ruleHandler, boolean create, CapacitySchedulerConfiguration csConf, boolean usePercentages) {
        Rule.Policy policy;
        PlacementRule parentRule = userRule.getParentRule();
        boolean parentCreate = ((FSPlacementRule)parentRule).getCreateFlag();
        QueuePath queueName = null;
        if (parentRule instanceof PrimaryGroupPlacementRule) {
            policy = Rule.Policy.PRIMARY_GROUP_USER;
        } else if (parentRule instanceof SecondaryGroupExistingPlacementRule) {
            policy = Rule.Policy.SECONDARY_GROUP_USER;
        } else if (parentRule instanceof DefaultPlacementRule) {
            DefaultPlacementRule defaultRule = (DefaultPlacementRule)parentRule;
            policy = Rule.Policy.USER;
            queueName = new QueuePath(defaultRule.defaultQueueName);
        } else {
            throw new IllegalArgumentException("Unsupported parent nested rule: " + parentRule.getClass().getCanonicalName());
        }
        Rule rule = this.createNestedRule(policy, create, ruleHandler, parentCreate, queueName, csConf, usePercentages);
        rules.add(rule);
    }

    private Rule createRule(Rule.Policy policy, boolean create, FSConfigToCSConfigRuleHandler ruleHandler, boolean usePercentages) {
        Rule rule = new Rule();
        rule.setPolicy(policy);
        rule.setCreate(create);
        rule.setMatches(MATCH_ALL_USER);
        rule.setFallbackResult(SKIP_RESULT);
        rule.setType(Rule.Type.USER);
        if (usePercentages && create) {
            if (policy == Rule.Policy.PRIMARY_GROUP || policy == Rule.Policy.PRIMARY_GROUP_USER) {
                ruleHandler.handleRuleAutoCreateFlag("root.<primaryGroup>");
            } else if (policy == Rule.Policy.SECONDARY_GROUP || policy == Rule.Policy.SECONDARY_GROUP_USER) {
                ruleHandler.handleRuleAutoCreateFlag("root.<secondaryGroup>");
            }
        }
        if (!usePercentages && NEED_ROOT_PARENT.contains((Object)policy)) {
            rule.setParentQueue("root");
        }
        return rule;
    }

    private Rule createNestedRule(Rule.Policy policy, boolean create, FSConfigToCSConfigRuleHandler ruleHandler, boolean fsParentCreate, QueuePath parentQueue, CapacitySchedulerConfiguration csConf, boolean usePercentages) {
        Rule rule = this.createRule(policy, create, ruleHandler, usePercentages);
        if (parentQueue != null) {
            rule.setParentQueue(parentQueue.getFullPath());
        }
        if (usePercentages) {
            if (fsParentCreate) {
                if (policy == Rule.Policy.PRIMARY_GROUP_USER) {
                    ruleHandler.handleFSParentCreateFlag("root.<primaryGroup>");
                } else if (policy == Rule.Policy.SECONDARY_GROUP_USER) {
                    ruleHandler.handleFSParentCreateFlag("root.<secondaryGroup>");
                } else {
                    ruleHandler.handleFSParentCreateFlag(parentQueue.getFullPath());
                }
            }
            if (create && policy == Rule.Policy.USER) {
                ruleHandler.handleRuleAutoCreateFlag(parentQueue.getFullPath());
                this.checkStaticDynamicConflict(parentQueue, csConf, ruleHandler);
            }
        } else {
            rule.setCreate(fsParentCreate || create);
            if (fsParentCreate ^ create) {
                ruleHandler.handleFSParentAndChildCreateFlagDiff(policy);
            }
        }
        return rule;
    }

    private void checkStaticDynamicConflict(QueuePath parentPath, CapacitySchedulerConfiguration csConf, FSConfigToCSConfigRuleHandler ruleHandler) {
        List<String> childQueues = csConf.getQueues(parentPath);
        if (childQueues != null && childQueues.size() > 0) {
            ruleHandler.handleChildStaticDynamicConflict(parentPath.getFullPath());
        }
    }
}

