/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.converter;

public final class FSConfigToCSConfigConverterParams {
    private String yarnSiteXmlConfig;
    private String fairSchedulerXmlConfig;
    private String conversionRulesConfig;
    private boolean console;
    private String clusterResource;
    private String outputDirectory;
    private boolean convertPlacementRules;
    private boolean placementRulesToFile;
    private boolean usePercentages;
    private PreemptionMode preemptionMode;

    private FSConfigToCSConfigConverterParams() {
    }

    public String getFairSchedulerXmlConfig() {
        return this.fairSchedulerXmlConfig;
    }

    public String getYarnSiteXmlConfig() {
        return this.yarnSiteXmlConfig;
    }

    public String getConversionRulesConfig() {
        return this.conversionRulesConfig;
    }

    public String getClusterResource() {
        return this.clusterResource;
    }

    public boolean isConsole() {
        return this.console;
    }

    public String getOutputDirectory() {
        return this.outputDirectory;
    }

    public boolean isConvertPlacementRules() {
        return this.convertPlacementRules;
    }

    public boolean isPlacementRulesToFile() {
        return this.placementRulesToFile;
    }

    public boolean isUsePercentages() {
        return this.usePercentages;
    }

    public PreemptionMode getPreemptionMode() {
        return this.preemptionMode;
    }

    public String toString() {
        return "FSConfigToCSConfigConverterParams{yarnSiteXmlConfig='" + this.yarnSiteXmlConfig + "', fairSchedulerXmlConfig='" + this.fairSchedulerXmlConfig + "', conversionRulesConfig='" + this.conversionRulesConfig + "', clusterResource='" + this.clusterResource + "', console=" + this.console + "', convertPlacementRules=" + this.convertPlacementRules + ", placementRulesToFile=" + this.placementRulesToFile + "}";
    }

    public static enum PreemptionMode {
        ENABLED("enabled"),
        NO_POLICY("nopolicy"),
        OBSERVE_ONLY("observeonly");

        private String cliOption;

        private PreemptionMode(String cliOption) {
            this.cliOption = cliOption;
        }

        public String getCliOption() {
            return this.cliOption;
        }

        public static PreemptionMode fromString(String cliOption) {
            if (cliOption != null && cliOption.trim().equals(OBSERVE_ONLY.getCliOption())) {
                return OBSERVE_ONLY;
            }
            if (cliOption != null && cliOption.trim().equals(NO_POLICY.getCliOption())) {
                return NO_POLICY;
            }
            return ENABLED;
        }
    }

    public static final class Builder {
        private String yarnSiteXmlConfig;
        private String fairSchedulerXmlConfig;
        private String conversionRulesConfig;
        private boolean console;
        private String clusterResource;
        private String outputDirectory;
        private boolean convertPlacementRules;
        private boolean placementRulesToFile;
        private boolean usePercentages;
        private PreemptionMode preemptionMode;

        private Builder() {
        }

        public static Builder create() {
            return new Builder();
        }

        public Builder withYarnSiteXmlConfig(String config) {
            this.yarnSiteXmlConfig = config;
            return this;
        }

        public Builder withFairSchedulerXmlConfig(String config) {
            this.fairSchedulerXmlConfig = config;
            return this;
        }

        public Builder withConversionRulesConfig(String config) {
            this.conversionRulesConfig = config;
            return this;
        }

        public Builder withClusterResource(String res) {
            this.clusterResource = res;
            return this;
        }

        public Builder withConsole(boolean console) {
            this.console = console;
            return this;
        }

        public Builder withOutputDirectory(String outputDir) {
            this.outputDirectory = outputDir;
            return this;
        }

        public Builder withConvertPlacementRules(boolean convertPlacementRules) {
            this.convertPlacementRules = convertPlacementRules;
            return this;
        }

        public Builder withPlacementRulesToFile(boolean rulesToFile) {
            this.placementRulesToFile = rulesToFile;
            return this;
        }

        public Builder withUsePercentages(boolean usePercentages) {
            this.usePercentages = usePercentages;
            return this;
        }

        public Builder withDisablePreemption(PreemptionMode preemptionMode) {
            this.preemptionMode = preemptionMode;
            return this;
        }

        public FSConfigToCSConfigConverterParams build() {
            FSConfigToCSConfigConverterParams params = new FSConfigToCSConfigConverterParams();
            params.clusterResource = this.clusterResource;
            params.console = this.console;
            params.fairSchedulerXmlConfig = this.fairSchedulerXmlConfig;
            params.yarnSiteXmlConfig = this.yarnSiteXmlConfig;
            params.conversionRulesConfig = this.conversionRulesConfig;
            params.outputDirectory = this.outputDirectory;
            params.convertPlacementRules = this.convertPlacementRules;
            params.placementRulesToFile = this.placementRulesToFile;
            params.usePercentages = this.usePercentages;
            params.preemptionMode = this.preemptionMode;
            return params;
        }
    }
}

