/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.constraint;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.hadoop.thirdparty.com.google.common.base.Strings;
import org.apache.hadoop.thirdparty.com.google.common.collect.ImmutableSet;
import org.apache.hadoop.yarn.api.records.AllocationTagNamespaceType;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.constraint.Evaluable;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.constraint.InvalidAllocationTagsQueryException;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.constraint.TargetApplications;

public abstract class TargetApplicationsNamespace
implements Evaluable<TargetApplications> {
    public static final String NAMESPACE_DELIMITER = "/";
    private AllocationTagNamespaceType nsType;
    private Set<ApplicationId> nsScope;

    public TargetApplicationsNamespace(AllocationTagNamespaceType allocationTagNamespaceType) {
        this.nsType = allocationTagNamespaceType;
    }

    protected void setScopeIfNotNull(Set<ApplicationId> appIds) {
        if (appIds != null) {
            this.nsScope = appIds;
        }
    }

    public AllocationTagNamespaceType getNamespaceType() {
        return this.nsType;
    }

    public Set<ApplicationId> getNamespaceScope() {
        if (this.nsScope == null) {
            throw new IllegalStateException("Invalid namespace scope, it is not initialized. Evaluate must be called before a namespace can be consumed.");
        }
        return this.nsScope;
    }

    @Override
    public void evaluate(TargetApplications target) throws InvalidAllocationTagsQueryException {
    }

    public String toString() {
        return this.nsType.toString();
    }

    public static TargetApplicationsNamespace parse(String namespaceStr) throws InvalidAllocationTagsQueryException {
        if (Strings.isNullOrEmpty((String)namespaceStr)) {
            return new Self();
        }
        List<String> nsValues = TargetApplicationsNamespace.normalize(namespaceStr);
        String nsPrefix = nsValues.get(0);
        AllocationTagNamespaceType allocationTagNamespaceType = TargetApplicationsNamespace.fromString(nsPrefix);
        switch (allocationTagNamespaceType) {
            case SELF: {
                return new Self();
            }
            case NOT_SELF: {
                return new NotSelf();
            }
            case ALL: {
                return new All();
            }
            case APP_ID: {
                if (nsValues.size() != 2) {
                    throw new InvalidAllocationTagsQueryException("Missing the application ID in the namespace string: " + namespaceStr);
                }
                String appIDStr = nsValues.get(1);
                return TargetApplicationsNamespace.parseAppID(appIDStr);
            }
            case APP_TAG: {
                if (nsValues.size() != 2) {
                    throw new InvalidAllocationTagsQueryException("Missing the application tag in the namespace string: " + namespaceStr);
                }
                return new AppTag(nsValues.get(1));
            }
        }
        throw new InvalidAllocationTagsQueryException("Invalid namespace string " + namespaceStr);
    }

    private static AllocationTagNamespaceType fromString(String prefix) throws InvalidAllocationTagsQueryException {
        for (AllocationTagNamespaceType type : AllocationTagNamespaceType.values()) {
            if (!type.getTypeKeyword().equals(prefix)) continue;
            return type;
        }
        Set values = Arrays.stream(AllocationTagNamespaceType.values()).map(AllocationTagNamespaceType::toString).collect(Collectors.toSet());
        throw new InvalidAllocationTagsQueryException("Invalid namespace prefix: " + prefix + ", valid values are: " + String.join((CharSequence)",", values));
    }

    private static TargetApplicationsNamespace parseAppID(String appIDStr) throws InvalidAllocationTagsQueryException {
        try {
            ApplicationId applicationId = ApplicationId.fromString((String)appIDStr);
            return new AppID(applicationId);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidAllocationTagsQueryException("Invalid application ID for " + AllocationTagNamespaceType.APP_ID.getTypeKeyword() + ": " + appIDStr);
        }
    }

    private static List<String> normalize(String namespaceStr) throws InvalidAllocationTagsQueryException {
        String[] nsValues;
        ArrayList<String> result = new ArrayList<String>();
        if (namespaceStr == null) {
            return result;
        }
        for (String str : nsValues = namespaceStr.split(NAMESPACE_DELIMITER)) {
            if (Strings.isNullOrEmpty((String)str)) continue;
            result.add(str);
        }
        if (result.size() == 0 || result.size() > 2) {
            throw new InvalidAllocationTagsQueryException("Invalid namespace string: " + namespaceStr + ", the syntax is <namespace_prefix> or <namespace_prefix>/<namespace_value>");
        }
        return result;
    }

    public static class Self
    extends TargetApplicationsNamespace {
        public Self() {
            super(AllocationTagNamespaceType.SELF);
        }

        @Override
        public void evaluate(TargetApplications target) throws InvalidAllocationTagsQueryException {
            if (target == null || target.getCurrentApplicationId() == null) {
                throw new InvalidAllocationTagsQueryException("Namespace Self must be evaluated against a single application ID.");
            }
            ApplicationId applicationId = target.getCurrentApplicationId();
            this.setScopeIfNotNull((Set<ApplicationId>)ImmutableSet.of((Object)applicationId));
        }
    }

    public static class NotSelf
    extends TargetApplicationsNamespace {
        private ApplicationId applicationId;

        public NotSelf() {
            super(AllocationTagNamespaceType.NOT_SELF);
        }

        public void setApplicationId(ApplicationId appId) {
            this.applicationId = appId;
        }

        public ApplicationId getApplicationId() {
            return this.applicationId;
        }

        @Override
        public void evaluate(TargetApplications target) {
            Set<ApplicationId> otherAppIds = target.getOtherApplicationIds();
            this.setScopeIfNotNull(otherAppIds);
        }
    }

    public static class All
    extends TargetApplicationsNamespace {
        public All() {
            super(AllocationTagNamespaceType.ALL);
        }
    }

    public static class AppTag
    extends TargetApplicationsNamespace {
        private String applicationTag;

        public AppTag(String appTag) {
            super(AllocationTagNamespaceType.APP_TAG);
            this.applicationTag = appTag;
        }

        @Override
        public void evaluate(TargetApplications target) {
            this.setScopeIfNotNull(target.getApplicationIdsByTag(this.applicationTag));
        }

        @Override
        public String toString() {
            return AllocationTagNamespaceType.APP_TAG.toString() + TargetApplicationsNamespace.NAMESPACE_DELIMITER + this.applicationTag;
        }
    }

    public static class AppID
    extends TargetApplicationsNamespace {
        private ApplicationId targetAppId;

        public AppID(ApplicationId applicationId) {
            super(AllocationTagNamespaceType.APP_ID);
            this.targetAppId = applicationId;
            this.setScopeIfNotNull((Set<ApplicationId>)ImmutableSet.of((Object)this.targetAppId));
        }

        @Override
        public String toString() {
            return AllocationTagNamespaceType.APP_ID.toString() + TargetApplicationsNamespace.NAMESPACE_DELIMITER + this.targetAppId;
        }
    }
}

