/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import java.io.IOException;
import java.util.Set;
import org.apache.hadoop.shaded.org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.util.Sets;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.ConfiguredNodeLabels;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.QueuePath;

public class QueueNodeLabelsSettings {
    private final CSQueue parent;
    private final QueuePath queuePath;
    private Set<String> accessibleLabels;
    private Set<String> configuredNodeLabels;
    private String defaultLabelExpression;

    public QueueNodeLabelsSettings(CapacitySchedulerConfiguration configuration, CSQueue parent, QueuePath queuePath, ConfiguredNodeLabels configuredNodeLabels) throws IOException {
        this.parent = parent;
        this.queuePath = queuePath;
        this.initializeNodeLabels(configuration, configuredNodeLabels);
    }

    private void initializeNodeLabels(CapacitySchedulerConfiguration configuration, ConfiguredNodeLabels configuredNodeLabels) throws IOException {
        this.initializeAccessibleLabels(configuration);
        this.initializeDefaultLabelExpression(configuration);
        this.initializeConfiguredNodeLabels(configuration, configuredNodeLabels);
        this.validateNodeLabels();
    }

    private void initializeAccessibleLabels(CapacitySchedulerConfiguration configuration) {
        this.accessibleLabels = configuration.getAccessibleNodeLabels(this.queuePath);
        if (this.accessibleLabels == null && this.parent != null) {
            this.accessibleLabels = this.parent.getAccessibleNodeLabels();
        }
    }

    private void initializeDefaultLabelExpression(CapacitySchedulerConfiguration configuration) {
        this.defaultLabelExpression = configuration.getDefaultNodeLabelExpression(this.queuePath);
        if (this.accessibleLabels != null && this.parent != null && this.defaultLabelExpression == null && this.accessibleLabels.containsAll(this.parent.getAccessibleNodeLabels())) {
            this.defaultLabelExpression = this.parent.getDefaultNodeLabelExpression();
        }
    }

    private void initializeConfiguredNodeLabels(CapacitySchedulerConfiguration configuration, ConfiguredNodeLabels configuredNodeLabelsParam) {
        this.configuredNodeLabels = configuredNodeLabelsParam != null ? (this.queuePath.isRoot() ? configuredNodeLabelsParam.getAllConfiguredLabels() : configuredNodeLabelsParam.getLabelsByQueue(this.queuePath.getFullPath())) : configuration.getConfiguredNodeLabels(this.queuePath);
    }

    private void validateNodeLabels() throws IOException {
        if (!this.queuePath.isRoot() && this.parent.getAccessibleNodeLabels() != null && !this.parent.getAccessibleNodeLabels().contains("*")) {
            if (this.getAccessibleNodeLabels().contains("*")) {
                throw new IOException("Parent's accessible queue is not ANY(*), but child's accessible queue is *");
            }
            Set diff = Sets.difference(this.getAccessibleNodeLabels(), this.parent.getAccessibleNodeLabels());
            if (!diff.isEmpty()) {
                throw new IOException(String.format("Some labels of child queue is not a subset of parent queue, these labels=[%s]", StringUtils.join((Iterable)diff, (String)",")));
            }
        }
    }

    public boolean isAccessibleToPartition(String nodePartition) {
        if (this.accessibleLabels != null && this.accessibleLabels.contains("*")) {
            return true;
        }
        if (nodePartition == null || nodePartition.equals("")) {
            return true;
        }
        return this.accessibleLabels != null && this.accessibleLabels.contains(nodePartition);
    }

    public Set<String> getAccessibleNodeLabels() {
        return this.accessibleLabels;
    }

    public Set<String> getConfiguredNodeLabels() {
        return this.configuredNodeLabels;
    }

    public String getDefaultLabelExpression() {
        return this.defaultLabelExpression;
    }
}

