/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import java.io.IOException;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.yarn.FileSystemBasedConfigurationProvider;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.monitor.SchedulingEditPolicy;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.RMNodeLabelsManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.util.Clock;
import org.apache.hadoop.yarn.util.MonotonicClock;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueueConfigurationAutoRefreshPolicy
implements SchedulingEditPolicy {
    private static final Logger LOG = LoggerFactory.getLogger(QueueConfigurationAutoRefreshPolicy.class);
    private Clock clock = new MonotonicClock();
    private RMContext rmContext;
    private ResourceCalculator rc;
    private CapacityScheduler scheduler;
    private RMNodeLabelsManager nlm;
    private long monitoringInterval;
    private long lastModified;
    private long lastReloadAttempt;
    private boolean lastReloadAttemptFailed = false;
    private Path allocCsFile;
    private FileSystem fs;

    @Override
    public void init(Configuration config, RMContext context, ResourceScheduler sched) {
        LOG.info("Queue auto refresh Policy monitor: {}" + this.getClass().getCanonicalName());
        assert (null == this.scheduler) : "Unexpected duplicate call to init";
        if (!(sched instanceof CapacityScheduler)) {
            throw new YarnRuntimeException("Class " + sched.getClass().getCanonicalName() + " not instance of " + CapacityScheduler.class.getCanonicalName());
        }
        this.rmContext = context;
        this.scheduler = (CapacityScheduler)sched;
        this.clock = this.scheduler.getClock();
        this.rc = this.scheduler.getResourceCalculator();
        this.nlm = this.scheduler.getRMContext().getNodeLabelManager();
        CapacitySchedulerConfiguration csConfig = this.scheduler.getConfiguration();
        this.monitoringInterval = csConfig.getLong("yarn.scheduler.capacity.queue.auto.refresh.monitoring-interval", 5000L);
    }

    @Override
    public void editSchedule() {
        long startTs = this.clock.getTime();
        try {
            this.allocCsFile = this.rmContext.getYarnConfiguration().get("yarn.resourcemanager.configuration.provider-class").equals(FileSystemBasedConfigurationProvider.class.getCanonicalName()) ? new Path(this.rmContext.getYarnConfiguration().get("yarn.resourcemanager.configuration.file-system-based-store"), "capacity-scheduler.xml") : new Path(this.rmContext.getYarnConfiguration().getClassLoader().getResource("").toString(), "capacity-scheduler.xml");
            this.fs = this.allocCsFile.getFileSystem(this.rmContext.getYarnConfiguration());
            this.lastModified = this.fs.getFileStatus(this.allocCsFile).getModificationTime();
            long time = this.clock.getTime();
            if (this.lastModified > this.lastReloadAttempt && time > this.lastReloadAttempt + this.monitoringInterval) {
                try {
                    this.rmContext.getRMAdminService().refreshQueues();
                    LOG.info("Queue auto refresh completed successfully");
                    this.lastReloadAttempt = this.clock.getTime();
                }
                catch (IOException | YarnException e) {
                    LOG.error("Can't refresh queue: " + (Exception)e);
                    if (!this.lastReloadAttemptFailed) {
                        LOG.error("Failed to reload capacity scheduler config file - will use existing conf. Message: {}", (Object)e.getMessage());
                    }
                    this.lastReloadAttempt = this.clock.getTime();
                    this.lastReloadAttemptFailed = true;
                }
            } else if (this.lastModified == 0L) {
                if (!this.lastReloadAttemptFailed) {
                    LOG.warn("Failed to reload capacity scheduler config file because last modified returned 0. File exists: " + this.fs.exists(this.allocCsFile));
                }
                this.lastReloadAttemptFailed = true;
            }
        }
        catch (IOException e) {
            LOG.error("Can't get file status for refresh : " + e);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Total time used=" + (this.clock.getTime() - startTs) + " ms.");
        }
    }

    @VisibleForTesting
    long getLastReloadAttempt() {
        return this.lastReloadAttempt;
    }

    @VisibleForTesting
    long getLastModified() {
        return this.lastModified;
    }

    @VisibleForTesting
    Clock getClock() {
        return this.clock;
    }

    @VisibleForTesting
    boolean getLastReloadAttemptFailed() {
        return this.lastReloadAttemptFailed;
    }

    @Override
    public long getMonitoringInterval() {
        return this.monitoringInterval;
    }

    @Override
    public String getPolicyName() {
        return QueueConfigurationAutoRefreshPolicy.class.getCanonicalName();
    }
}

