/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.ResourceVector;

public class QueueCapacityVector
implements Iterable<QueueCapacityVectorEntry> {
    private static final String START_PARENTHESES = "[";
    private static final String END_PARENTHESES = "]";
    private static final String RESOURCE_DELIMITER = ",";
    private static final String VALUE_DELIMITER = "=";
    private final ResourceVector resource;
    private final Map<String, ResourceUnitCapacityType> capacityTypes = new HashMap<String, ResourceUnitCapacityType>();
    private final Map<ResourceUnitCapacityType, Set<String>> capacityTypePerResource = new HashMap<ResourceUnitCapacityType, Set<String>>();

    public QueueCapacityVector() {
        this.resource = new ResourceVector();
    }

    private QueueCapacityVector(ResourceVector resource) {
        this.resource = resource;
    }

    public static QueueCapacityVector newInstance() {
        QueueCapacityVector newCapacityVector = new QueueCapacityVector(ResourceVector.newInstance());
        for (Map.Entry<String, Double> resourceEntry : newCapacityVector.resource) {
            newCapacityVector.storeResourceType(resourceEntry.getKey(), ResourceUnitCapacityType.ABSOLUTE);
        }
        return newCapacityVector;
    }

    public static QueueCapacityVector of(double value, ResourceUnitCapacityType capacityType) {
        QueueCapacityVector newCapacityVector = new QueueCapacityVector(ResourceVector.of(value));
        for (Map.Entry<String, Double> resourceEntry : newCapacityVector.resource) {
            newCapacityVector.storeResourceType(resourceEntry.getKey(), capacityType);
        }
        return newCapacityVector;
    }

    public QueueCapacityVectorEntry getResource(String resourceName) {
        return new QueueCapacityVectorEntry(this.capacityTypes.get(resourceName), resourceName, this.resource.getValue(resourceName));
    }

    public int getResourceCount() {
        return this.capacityTypes.size();
    }

    public void setResource(String resourceName, double value, ResourceUnitCapacityType capacityType) {
        String convertedResourceName = resourceName;
        if (resourceName.equals("memory")) {
            convertedResourceName = "memory-mb";
        }
        this.resource.setValue(convertedResourceName, value);
        this.storeResourceType(convertedResourceName, capacityType);
    }

    public double getMemory() {
        return this.resource.getValue("memory-mb");
    }

    public boolean isEmpty() {
        return this.resource.isEmpty() && this.capacityTypePerResource.isEmpty() && this.capacityTypes.isEmpty();
    }

    public Set<String> getResourceNamesByCapacityType(ResourceUnitCapacityType capacityType) {
        return new HashSet<String>(this.capacityTypePerResource.getOrDefault((Object)capacityType, Collections.emptySet()));
    }

    public boolean isResourceOfType(String resourceName, ResourceUnitCapacityType capacityType) {
        return this.capacityTypes.containsKey(resourceName) && this.capacityTypes.get(resourceName).equals((Object)capacityType);
    }

    @Override
    public Iterator<QueueCapacityVectorEntry> iterator() {
        return new Iterator<QueueCapacityVectorEntry>(){
            private final Iterator<Map.Entry<String, Double>> resources;
            private int i;
            {
                this.resources = QueueCapacityVector.this.resource.iterator();
                this.i = 0;
            }

            @Override
            public boolean hasNext() {
                return this.resources.hasNext() && QueueCapacityVector.this.capacityTypes.size() > this.i;
            }

            @Override
            public QueueCapacityVectorEntry next() {
                Map.Entry<String, Double> resourceInformation = this.resources.next();
                ++this.i;
                return new QueueCapacityVectorEntry(QueueCapacityVector.this.capacityTypes.get(resourceInformation.getKey()), resourceInformation.getKey(), resourceInformation.getValue());
            }
        };
    }

    public Set<ResourceUnitCapacityType> getDefinedCapacityTypes() {
        return this.capacityTypePerResource.keySet();
    }

    public boolean isMixedCapacityVector() {
        return this.getDefinedCapacityTypes().size() > 1;
    }

    public Set<String> getResourceNames() {
        return this.resource.getResourceNames();
    }

    private void storeResourceType(String resourceName, ResourceUnitCapacityType resourceType) {
        if (this.capacityTypes.get(resourceName) != null && !this.capacityTypes.get(resourceName).equals((Object)resourceType)) {
            this.capacityTypePerResource.get((Object)this.capacityTypes.get(resourceName)).remove(resourceName);
            if (this.capacityTypePerResource.get((Object)this.capacityTypes.get(resourceName)).isEmpty()) {
                this.capacityTypePerResource.remove((Object)this.capacityTypes.get(resourceName));
            }
        }
        this.capacityTypePerResource.putIfAbsent(resourceType, new HashSet());
        this.capacityTypePerResource.get((Object)resourceType).add(resourceName);
        this.capacityTypes.put(resourceName, resourceType);
    }

    public String toString() {
        StringBuilder stringVector = new StringBuilder();
        stringVector.append(START_PARENTHESES);
        int resourceCount = 0;
        for (Map.Entry<String, Double> resourceEntry : this.resource) {
            stringVector.append(resourceEntry.getKey()).append(VALUE_DELIMITER).append(resourceEntry.getValue()).append(this.capacityTypes.get((Object)resourceEntry.getKey()).postfix);
            if (++resourceCount >= this.capacityTypes.size()) continue;
            stringVector.append(RESOURCE_DELIMITER);
        }
        stringVector.append(END_PARENTHESES);
        return stringVector.toString();
    }

    public static enum ResourceUnitCapacityType {
        PERCENTAGE("%"),
        ABSOLUTE(""),
        WEIGHT("w");

        private final String postfix;

        private ResourceUnitCapacityType(String postfix) {
            this.postfix = postfix;
        }

        public String getPostfix() {
            return this.postfix;
        }
    }

    public static class QueueCapacityVectorEntry {
        private final ResourceUnitCapacityType vectorResourceType;
        private final double resourceValue;
        private final String resourceName;

        public QueueCapacityVectorEntry(ResourceUnitCapacityType vectorResourceType, String resourceName, double resourceValue) {
            this.vectorResourceType = vectorResourceType;
            this.resourceValue = resourceValue;
            this.resourceName = resourceName;
        }

        public ResourceUnitCapacityType getVectorResourceType() {
            return this.vectorResourceType;
        }

        public double getResourceValue() {
            return this.resourceValue;
        }

        public String getResourceName() {
            return this.resourceName;
        }

        public String getResourceWithPostfix() {
            return this.resourceValue + this.vectorResourceType.getPostfix();
        }
    }
}

