/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceInformation;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.QueuePath;
import org.apache.hadoop.yarn.util.resource.ResourceUtils;
import org.apache.hadoop.yarn.util.resource.Resources;

public class QueueAllocationSettings {
    private final Resource minimumAllocation;
    private Resource maximumAllocation;

    public QueueAllocationSettings(Resource minimumAllocation) {
        this.minimumAllocation = minimumAllocation;
    }

    void setupMaximumAllocation(CapacitySchedulerConfiguration configuration, QueuePath queuePath, CSQueue parent) {
        Resource clusterMax = ResourceUtils.fetchMaximumAllocationFromConfig((Configuration)configuration);
        Resource queueMax = configuration.getQueueMaximumAllocation(queuePath);
        this.maximumAllocation = Resources.clone((Resource)(parent == null ? clusterMax : parent.getMaximumAllocation()));
        String errMsg = "Queue maximum allocation cannot be larger than the cluster setting for queue " + queuePath + " max allocation per queue: %s cluster setting: " + clusterMax;
        if (queueMax == Resources.none()) {
            long queueMemory = configuration.getQueueMaximumAllocationMb(queuePath);
            int queueVcores = configuration.getQueueMaximumAllocationVcores(queuePath);
            if ((float)queueMemory != -1.0f) {
                this.maximumAllocation.setMemorySize(queueMemory);
            }
            if ((float)queueVcores != -1.0f) {
                this.maximumAllocation.setVirtualCores(queueVcores);
            }
            if ((float)queueMemory != -1.0f && queueMemory > clusterMax.getMemorySize() || (float)queueVcores != -1.0f && queueVcores > clusterMax.getVirtualCores()) {
                throw new IllegalArgumentException(String.format(errMsg, this.maximumAllocation));
            }
        } else {
            for (ResourceInformation ri : queueMax.getResources()) {
                if (ri.compareTo(clusterMax.getResourceInformation(ri.getName())) > 0) {
                    throw new IllegalArgumentException(String.format(errMsg, queueMax));
                }
                this.maximumAllocation.setResourceInformation(ri.getName(), ri);
            }
        }
    }

    public Resource getMinimumAllocation() {
        return this.minimumAllocation;
    }

    public Resource getMaximumAllocation() {
        return this.maximumAllocation;
    }
}

