/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import org.apache.hadoop.thirdparty.com.google.common.collect.ArrayListMultimap;
import org.apache.hadoop.thirdparty.com.google.common.collect.ListMultimap;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.AbstractCSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.AbstractLeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.AbstractParentQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.ParentQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.fica.FiCaSchedulerApp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CSMaxRunningAppsEnforcer {
    private static final Logger LOG = LoggerFactory.getLogger(CSMaxRunningAppsEnforcer.class);
    private final CapacityScheduler scheduler;
    private final Map<String, Integer> usersNumRunnableApps;
    private final ListMultimap<String, FiCaSchedulerApp> usersNonRunnableApps;

    public CSMaxRunningAppsEnforcer(CapacityScheduler scheduler) {
        this.scheduler = scheduler;
        this.usersNumRunnableApps = new HashMap<String, Integer>();
        this.usersNonRunnableApps = ArrayListMultimap.create();
    }

    public boolean checkRunnabilityWithUpdate(FiCaSchedulerApp attempt) {
        boolean attemptCanRun = !this.exceedUserMaxParallelApps(attempt.getUser()) && !this.exceedQueueMaxParallelApps(attempt.getCSLeafQueue());
        attempt.setRunnable(attemptCanRun);
        return attemptCanRun;
    }

    private boolean exceedUserMaxParallelApps(String user) {
        Integer userNumRunnable = this.usersNumRunnableApps.get(user);
        if (userNumRunnable == null) {
            userNumRunnable = 0;
        }
        if (userNumRunnable >= this.getUserMaxParallelApps(user)) {
            LOG.info("Maximum runnable apps exceeded for user {}", (Object)user);
            return true;
        }
        return false;
    }

    private boolean exceedQueueMaxParallelApps(AbstractCSQueue queue) {
        while (queue != null) {
            if (queue.getNumRunnableApps() >= queue.getMaxParallelApps()) {
                LOG.info("Maximum runnable apps exceeded for queue {}", (Object)queue.getQueuePath());
                return true;
            }
            queue = (AbstractCSQueue)queue.getParent();
        }
        return false;
    }

    public void trackApp(FiCaSchedulerApp app) {
        if (app.isRunnable()) {
            this.trackRunnableApp(app);
        } else {
            this.trackNonRunnableApp(app);
        }
    }

    private void trackRunnableApp(FiCaSchedulerApp app) {
        String user = app.getUser();
        AbstractCSQueue queue = (AbstractCSQueue)app.getQueue();
        for (AbstractParentQueue parent = (AbstractParentQueue)queue.getParent(); parent != null; parent = (AbstractParentQueue)parent.getParent()) {
            parent.incrementRunnableApps();
        }
        Integer userNumRunnable = this.usersNumRunnableApps.get(user);
        this.usersNumRunnableApps.put(user, (userNumRunnable == null ? 0 : userNumRunnable) + 1);
    }

    private void trackNonRunnableApp(FiCaSchedulerApp app) {
        String user = app.getUser();
        this.usersNonRunnableApps.put((Object)user, (Object)app);
    }

    public void updateRunnabilityOnReload() {
        ParentQueue rootQueue = (ParentQueue)this.scheduler.getRootQueue();
        ArrayList<List<FiCaSchedulerApp>> appsNowMaybeRunnable = new ArrayList<List<FiCaSchedulerApp>>();
        this.gatherPossiblyRunnableAppLists(rootQueue, appsNowMaybeRunnable);
        this.updateAppsRunnability(appsNowMaybeRunnable, Integer.MAX_VALUE);
    }

    public void updateRunnabilityOnAppRemoval(FiCaSchedulerApp app) {
        List userWaitingApps;
        String user;
        Integer userNumRunning;
        AbstractLeafQueue queue = app.getCSLeafQueue();
        AbstractCSQueue highestQueueWithAppsNowRunnable = queue.getNumRunnableApps() == queue.getMaxParallelApps() - 1 ? queue : null;
        for (AbstractParentQueue parent = (AbstractParentQueue)queue.getParent(); parent != null; parent = (AbstractParentQueue)parent.getParent()) {
            if (parent.getNumRunnableApps() != parent.getMaxParallelApps() - 1) continue;
            highestQueueWithAppsNowRunnable = parent;
        }
        ArrayList<List<FiCaSchedulerApp>> appsNowMaybeRunnable = new ArrayList<List<FiCaSchedulerApp>>();
        if (highestQueueWithAppsNowRunnable != null) {
            this.gatherPossiblyRunnableAppLists(highestQueueWithAppsNowRunnable, appsNowMaybeRunnable);
        }
        if ((userNumRunning = this.usersNumRunnableApps.get(user = app.getUser())) == null) {
            userNumRunning = 0;
        }
        if (userNumRunning == this.getUserMaxParallelApps(user) - 1 && (userWaitingApps = this.usersNonRunnableApps.get((Object)user)) != null) {
            appsNowMaybeRunnable.add(userWaitingApps);
        }
        this.updateAppsRunnability(appsNowMaybeRunnable, appsNowMaybeRunnable.size());
    }

    private void updateAppsRunnability(List<List<FiCaSchedulerApp>> appsNowMaybeRunnable, int maxRunnableApps) {
        MultiListStartTimeIterator iter = new MultiListStartTimeIterator(appsNowMaybeRunnable);
        FiCaSchedulerApp prev = null;
        ArrayList<FiCaSchedulerApp> noLongerPendingApps = new ArrayList<FiCaSchedulerApp>();
        while (iter.hasNext()) {
            FiCaSchedulerApp next = (FiCaSchedulerApp)iter.next();
            if (next == prev) continue;
            if (this.checkRunnabilityWithUpdate(next)) {
                AbstractLeafQueue nextQueue = next.getCSLeafQueue();
                LOG.info("{} is now runnable in {}", (Object)next.getApplicationAttemptId(), (Object)nextQueue);
                this.trackRunnableApp(next);
                FiCaSchedulerApp appSched = next;
                nextQueue.submitApplicationAttempt(next, next.getUser());
                noLongerPendingApps.add(appSched);
                if (noLongerPendingApps.size() >= maxRunnableApps) break;
            }
            prev = next;
        }
        for (FiCaSchedulerApp appSched : noLongerPendingApps) {
            if (!appSched.getCSLeafQueue().removeNonRunnableApp(appSched)) {
                LOG.error("Can't make app runnable that does not already exist in queue as non-runnable: {}. This should never happen.", (Object)appSched.getApplicationAttemptId());
            }
            if (this.usersNonRunnableApps.remove((Object)appSched.getUser(), (Object)appSched)) continue;
            LOG.error("Waiting app {} expected to be in usersNonRunnableApps, but was not. This should never happen.", (Object)appSched.getApplicationAttemptId());
        }
    }

    public void untrackApp(FiCaSchedulerApp app) {
        if (app.isRunnable()) {
            this.untrackRunnableApp(app);
        } else {
            this.untrackNonRunnableApp(app);
        }
    }

    private void untrackRunnableApp(FiCaSchedulerApp app) {
        String user = app.getUser();
        int newUserNumRunning = this.usersNumRunnableApps.get(user) - 1;
        if (newUserNumRunning == 0) {
            this.usersNumRunnableApps.remove(user);
        } else {
            this.usersNumRunnableApps.put(user, newUserNumRunning);
        }
        AbstractCSQueue queue = (AbstractCSQueue)app.getQueue();
        for (AbstractParentQueue parent = (AbstractParentQueue)queue.getParent(); parent != null; parent = (AbstractParentQueue)parent.getParent()) {
            parent.decrementRunnableApps();
        }
    }

    private void untrackNonRunnableApp(FiCaSchedulerApp app) {
        this.usersNonRunnableApps.remove((Object)app.getUser(), (Object)app);
    }

    private void gatherPossiblyRunnableAppLists(AbstractCSQueue queue, List<List<FiCaSchedulerApp>> appLists) {
        if (queue.getNumRunnableApps() < queue.getMaxParallelApps()) {
            if (queue instanceof AbstractLeafQueue) {
                appLists.add(((AbstractLeafQueue)queue).getCopyOfNonRunnableAppSchedulables());
            } else {
                for (CSQueue child : queue.getChildQueues()) {
                    this.gatherPossiblyRunnableAppLists((AbstractCSQueue)child, appLists);
                }
            }
        }
    }

    private int getUserMaxParallelApps(String user) {
        CapacitySchedulerConfiguration conf = this.scheduler.getConfiguration();
        if (conf == null) {
            return Integer.MAX_VALUE;
        }
        int userMaxParallelApps = conf.getMaxParallelAppsForUser(user);
        return userMaxParallelApps;
    }

    static class MultiListStartTimeIterator
    implements Iterator<FiCaSchedulerApp> {
        private List<FiCaSchedulerApp>[] appLists;
        private int[] curPositionsInAppLists;
        private PriorityQueue<IndexAndTime> appListsByCurStartTime;

        MultiListStartTimeIterator(List<List<FiCaSchedulerApp>> appListList) {
            this.appLists = appListList.toArray(new List[appListList.size()]);
            this.curPositionsInAppLists = new int[this.appLists.length];
            this.appListsByCurStartTime = new PriorityQueue();
            for (int i = 0; i < this.appLists.length; ++i) {
                long time = this.appLists[i].isEmpty() ? Long.MAX_VALUE : this.appLists[i].get(0).getStartTime();
                this.appListsByCurStartTime.add(new IndexAndTime(i, time));
            }
        }

        @Override
        public boolean hasNext() {
            return !this.appListsByCurStartTime.isEmpty() && this.appListsByCurStartTime.peek().time != Long.MAX_VALUE;
        }

        @Override
        public FiCaSchedulerApp next() {
            IndexAndTime indexAndTime = (IndexAndTime)this.appListsByCurStartTime.remove();
            int nextListIndex = indexAndTime.index;
            FiCaSchedulerApp next = this.appLists[nextListIndex].get(this.curPositionsInAppLists[nextListIndex]);
            int n = nextListIndex;
            this.curPositionsInAppLists[n] = this.curPositionsInAppLists[n] + 1;
            indexAndTime.time = this.curPositionsInAppLists[nextListIndex] < this.appLists[nextListIndex].size() ? this.appLists[nextListIndex].get(this.curPositionsInAppLists[nextListIndex]).getStartTime() : Long.MAX_VALUE;
            this.appListsByCurStartTime.add(indexAndTime);
            return next;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Remove not supported");
        }

        private static class IndexAndTime
        implements Comparable<IndexAndTime> {
            private int index;
            private long time;

            IndexAndTime(int index, long time) {
                this.index = index;
                this.time = time;
            }

            @Override
            public int compareTo(IndexAndTime o) {
                return this.time < o.time ? -1 : (this.time > o.time ? 1 : 0);
            }

            public boolean equals(Object o) {
                if (!(o instanceof IndexAndTime)) {
                    return false;
                }
                IndexAndTime other = (IndexAndTime)o;
                return other.time == this.time;
            }

            public int hashCode() {
                return (int)this.time;
            }
        }
    }
}

