/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.activities;

import java.util.LinkedList;
import java.util.List;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.activities.ActivityLevel;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.activities.ActivityState;

public class ActivityNode {
    private String activityNodeName;
    private String parentName;
    private Integer appPriority;
    private Integer requestPriority;
    private ActivityState state;
    private String diagnostic;
    private NodeId nodeId;
    private Long allocationRequestId;
    private List<ActivityNode> childNode;

    public ActivityNode(String activityNodeName, String parentName, Integer priority, ActivityState state, String diagnostic, ActivityLevel level, NodeId nodeId, Long allocationRequestId) {
        this.activityNodeName = activityNodeName;
        this.parentName = parentName;
        if (level != null) {
            switch (level) {
                case APP: {
                    this.appPriority = priority;
                    break;
                }
                case REQUEST: {
                    this.requestPriority = priority;
                    this.allocationRequestId = allocationRequestId;
                    break;
                }
                case NODE: {
                    this.requestPriority = priority;
                    this.allocationRequestId = allocationRequestId;
                    this.nodeId = nodeId;
                    break;
                }
            }
        }
        this.state = state;
        this.diagnostic = diagnostic;
        this.childNode = new LinkedList<ActivityNode>();
    }

    public String getName() {
        return this.activityNodeName;
    }

    public String getParentName() {
        return this.parentName;
    }

    public void addChild(ActivityNode node) {
        this.childNode.add(0, node);
    }

    public List<ActivityNode> getChildren() {
        return this.childNode;
    }

    public ActivityState getState() {
        return this.state;
    }

    public String getDiagnostic() {
        return this.diagnostic;
    }

    public Integer getAppPriority() {
        return this.appPriority;
    }

    public Integer getRequestPriority() {
        return this.requestPriority;
    }

    public NodeId getNodeId() {
        return this.nodeId;
    }

    public Long getAllocationRequestId() {
        return this.allocationRequestId;
    }

    public boolean isAppType() {
        return this.appPriority != null;
    }

    public boolean isRequestType() {
        return this.requestPriority != null && this.nodeId == null;
    }

    public String getShortDiagnostic() {
        if (this.diagnostic == null) {
            return "";
        }
        return StringUtils.split((String)this.diagnostic, (char)'\n')[0];
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.activityNodeName + " ").append(this.appPriority + " ").append(this.state + " ");
        if (this.nodeId != null) {
            sb.append(this.nodeId + " ");
        }
        if (!this.diagnostic.equals("")) {
            sb.append(this.diagnostic + "\n");
        }
        sb.append("\n");
        for (ActivityNode child : this.childNode) {
            sb.append(child.toString() + "\n");
        }
        return sb.toString();
    }
}

