/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.activities;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.shaded.org.apache.commons.collections4.CollectionUtils;
import org.apache.hadoop.shaded.org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.util.Lists;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerApplicationAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.activities.ActivityLevel;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.activities.ActivityNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.activities.ActivityState;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.activities.AllocationState;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.activities.AppAllocation;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.activities.DiagnosticsCollector;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.activities.GenericDiagnosticsCollector;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.activities.NodeAllocation;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.RMWSConsts;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.ActivitiesInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.AppActivitiesInfo;
import org.apache.hadoop.yarn.util.SystemClock;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActivitiesManager
extends AbstractService {
    private static final Logger LOG = LoggerFactory.getLogger(ActivitiesManager.class);
    public static final NodeId EMPTY_NODE_ID = NodeId.newInstance((String)"", (int)0);
    public static final char DIAGNOSTICS_DETAILS_SEPARATOR = '\n';
    public static final String EMPTY_DIAGNOSTICS = "";
    private ThreadLocal<Map<NodeId, List<NodeAllocation>>> recordingNodesAllocation;
    @VisibleForTesting
    ConcurrentMap<NodeId, List<NodeAllocation>> completedNodeAllocations;
    private Set<NodeId> activeRecordedNodes;
    private ConcurrentMap<ApplicationId, Long> recordingAppActivitiesUntilSpecifiedTime;
    private ThreadLocal<Map<ApplicationId, AppAllocation>> appsAllocation;
    @VisibleForTesting
    ConcurrentMap<ApplicationId, Queue<AppAllocation>> completedAppAllocations;
    private AtomicInteger recordCount = new AtomicInteger(0);
    private List<NodeAllocation> lastAvailableNodeActivities = null;
    private Thread cleanUpThread;
    private long activitiesCleanupIntervalMs;
    private long schedulerActivitiesTTL;
    private long appActivitiesTTL;
    private volatile int appActivitiesMaxQueueLength;
    private int configuredAppActivitiesMaxQueueLength;
    private final RMContext rmContext;
    private volatile boolean stopped;
    private ThreadLocal<DiagnosticsCollectorManager> diagnosticCollectorManager;
    private volatile ConcurrentLinkedDeque<Pair<NodeId, List<NodeAllocation>>> lastNActivities;

    public ActivitiesManager(RMContext rmContext) {
        super(ActivitiesManager.class.getName());
        this.recordingNodesAllocation = ThreadLocal.withInitial(() -> new HashMap());
        this.completedNodeAllocations = new ConcurrentHashMap<NodeId, List<NodeAllocation>>();
        this.appsAllocation = ThreadLocal.withInitial(() -> new HashMap());
        this.completedAppAllocations = new ConcurrentHashMap<ApplicationId, Queue<AppAllocation>>();
        this.activeRecordedNodes = Collections.newSetFromMap(new ConcurrentHashMap());
        this.recordingAppActivitiesUntilSpecifiedTime = new ConcurrentHashMap<ApplicationId, Long>();
        this.diagnosticCollectorManager = ThreadLocal.withInitial(() -> new DiagnosticsCollectorManager(new GenericDiagnosticsCollector()));
        this.rmContext = rmContext;
        if (rmContext.getYarnConfiguration() != null) {
            this.setupConfForCleanup(rmContext.getYarnConfiguration());
        }
        this.lastNActivities = new ConcurrentLinkedDeque();
    }

    private void setupConfForCleanup(Configuration conf) {
        this.activitiesCleanupIntervalMs = conf.getLong("yarn.resourcemanager.activities-manager.cleanup-interval-ms", 5000L);
        this.schedulerActivitiesTTL = conf.getLong("yarn.resourcemanager.activities-manager.scheduler-activities.ttl-ms", 600000L);
        this.appActivitiesTTL = conf.getLong("yarn.resourcemanager.activities-manager.app-activities.ttl-ms", 600000L);
        this.appActivitiesMaxQueueLength = this.configuredAppActivitiesMaxQueueLength = conf.getInt("yarn.resourcemanager.activities-manager.app-activities.max-queue-length", 100);
    }

    public AppActivitiesInfo getAppActivitiesInfo(ApplicationId applicationId, Set<Integer> requestPriorities, Set<Long> allocationRequestIds, RMWSConsts.ActivitiesGroupBy groupBy, int limit, boolean summarize, double maxTimeInSeconds) {
        RMApp app = (RMApp)this.rmContext.getRMApps().get(applicationId);
        if (app != null && app.getFinalApplicationStatus() == FinalApplicationStatus.UNDEFINED) {
            AppAllocation summaryAppAllocation;
            Queue curAllocations = (Queue)this.completedAppAllocations.get(applicationId);
            List<Object> allocations = null;
            if (curAllocations != null) {
                allocations = CollectionUtils.isNotEmpty(requestPriorities) || CollectionUtils.isNotEmpty(allocationRequestIds) ? curAllocations.stream().map(e -> e.filterAllocationAttempts(requestPriorities, allocationRequestIds)).filter(e -> !e.getAllocationAttempts().isEmpty()).collect(Collectors.toList()) : new ArrayList(curAllocations);
            }
            if (summarize && allocations != null && (summaryAppAllocation = this.getSummarizedAppAllocation(allocations, maxTimeInSeconds)) != null) {
                allocations = Lists.newArrayList((Object[])new AppAllocation[]{summaryAppAllocation});
            }
            if (allocations != null && limit > 0 && limit < allocations.size()) {
                allocations = allocations.subList(allocations.size() - limit, allocations.size());
            }
            return new AppActivitiesInfo((List<AppAllocation>)allocations, applicationId, groupBy);
        }
        return new AppActivitiesInfo("fail to get application activities after finished", applicationId.toString());
    }

    private AppAllocation getSummarizedAppAllocation(List<AppAllocation> allocations, double maxTimeInSeconds) {
        AppAllocation appAllocation;
        if (allocations == null || allocations.isEmpty()) {
            return null;
        }
        long startTime = allocations.get(allocations.size() - 1).getTime() - (long)(maxTimeInSeconds * 1000.0);
        HashMap<CallSite, ActivityNode> nodeActivities = new HashMap<CallSite, ActivityNode>();
        for (int i = allocations.size() - 1; i >= 0 && startTime <= (appAllocation = allocations.get(i)).getTime(); --i) {
            List<ActivityNode> activityNodes = appAllocation.getAllocationAttempts();
            for (ActivityNode an : activityNodes) {
                nodeActivities.putIfAbsent((CallSite)((Object)(an.getRequestPriority() + "_" + an.getAllocationRequestId() + "_" + an.getNodeId())), an);
            }
        }
        AppAllocation lastAppAllocation = allocations.get(allocations.size() - 1);
        AppAllocation summarizedAppAllocation = new AppAllocation(lastAppAllocation.getPriority(), null, lastAppAllocation.getQueueName());
        summarizedAppAllocation.updateAppContainerStateAndTime(null, lastAppAllocation.getActivityState(), lastAppAllocation.getTime(), lastAppAllocation.getDiagnostic());
        summarizedAppAllocation.setAllocationAttempts(new ArrayList<ActivityNode>(nodeActivities.values()));
        return summarizedAppAllocation;
    }

    public ActivitiesInfo getActivitiesInfo(String nodeId, RMWSConsts.ActivitiesGroupBy groupBy) {
        List allocations = nodeId == null ? this.lastAvailableNodeActivities : (List)this.completedNodeAllocations.get(NodeId.fromString((String)nodeId));
        return new ActivitiesInfo(allocations, nodeId, groupBy);
    }

    public List<ActivitiesInfo> recordAndGetBulkActivitiesInfo(int activitiesCount, RMWSConsts.ActivitiesGroupBy groupBy) throws InterruptedException {
        this.recordCount.set(activitiesCount);
        while (this.recordCount.get() > 0) {
            Thread.sleep(1L);
        }
        Iterator<Pair<NodeId, List<NodeAllocation>>> ite = this.lastNActivities.iterator();
        ArrayList<ActivitiesInfo> outList = new ArrayList<ActivitiesInfo>();
        while (ite.hasNext()) {
            Pair<NodeId, List<NodeAllocation>> pair = ite.next();
            outList.add(new ActivitiesInfo((List)pair.getRight(), ((NodeId)pair.getLeft()).toString(), groupBy));
        }
        this.lastNActivities = new ConcurrentLinkedDeque();
        return outList;
    }

    public void recordNextNodeUpdateActivities(String nodeId) {
        if (nodeId == null) {
            this.recordCount.compareAndSet(0, 1);
        } else {
            this.activeRecordedNodes.add(NodeId.fromString((String)nodeId));
        }
    }

    public void turnOnAppActivitiesRecording(ApplicationId applicationId, double maxTime) {
        long startTS = SystemClock.getInstance().getTime();
        long endTS = startTS + (long)(maxTime * 1000.0);
        this.recordingAppActivitiesUntilSpecifiedTime.put(applicationId, endTS);
    }

    private void dynamicallyUpdateAppActivitiesMaxQueueLengthIfNeeded() {
        if (this.rmContext.getRMNodes() == null) {
            return;
        }
        if (this.rmContext.getScheduler() instanceof CapacityScheduler) {
            CapacityScheduler cs = (CapacityScheduler)this.rmContext.getScheduler();
            if (!cs.isMultiNodePlacementEnabled()) {
                int numNodes = this.rmContext.getRMNodes().size();
                int numAsyncSchedulerThreads = cs.getNumAsyncSchedulerThreads();
                int newAppActivitiesMaxQueueLength = numAsyncSchedulerThreads > 0 ? Math.max(this.configuredAppActivitiesMaxQueueLength, numNodes * numAsyncSchedulerThreads) : Math.max(this.configuredAppActivitiesMaxQueueLength, (int)((double)numNodes * 1.2));
                if (this.appActivitiesMaxQueueLength != newAppActivitiesMaxQueueLength) {
                    LOG.info("Update max queue length of app activities from {} to {}, configured={}, numNodes={}, numAsyncSchedulerThreads={} when multi-node placement disabled.", new Object[]{this.appActivitiesMaxQueueLength, newAppActivitiesMaxQueueLength, this.configuredAppActivitiesMaxQueueLength, numNodes, numAsyncSchedulerThreads});
                    this.appActivitiesMaxQueueLength = newAppActivitiesMaxQueueLength;
                }
            } else if (this.appActivitiesMaxQueueLength != this.configuredAppActivitiesMaxQueueLength) {
                LOG.info("Update max queue length of app activities from {} to {} when multi-node placement enabled.", (Object)this.appActivitiesMaxQueueLength, (Object)this.configuredAppActivitiesMaxQueueLength);
                this.appActivitiesMaxQueueLength = this.configuredAppActivitiesMaxQueueLength;
            }
        }
    }

    protected void serviceStart() throws Exception {
        this.cleanUpThread = new Thread(new Runnable(){

            @Override
            public void run() {
                while (!ActivitiesManager.this.stopped && !Thread.currentThread().isInterrupted()) {
                    Iterator ite = ActivitiesManager.this.completedNodeAllocations.entrySet().iterator();
                    long curTS = SystemClock.getInstance().getTime();
                    while (ite.hasNext()) {
                        Map.Entry nodeAllocation = ite.next();
                        List allocations = (List)nodeAllocation.getValue();
                        if (allocations.size() <= 0 || curTS - ((NodeAllocation)allocations.get(0)).getTimestamp() <= ActivitiesManager.this.schedulerActivitiesTTL) continue;
                        ite.remove();
                    }
                    Iterator iteApp = ActivitiesManager.this.completedAppAllocations.entrySet().iterator();
                    while (iteApp.hasNext()) {
                        Map.Entry appAllocation = iteApp.next();
                        RMApp rmApp = (RMApp)ActivitiesManager.this.rmContext.getRMApps().get(appAllocation.getKey());
                        if (rmApp == null || rmApp.getFinalApplicationStatus() != FinalApplicationStatus.UNDEFINED) {
                            iteApp.remove();
                            continue;
                        }
                        Iterator appActivitiesIt = ((Queue)appAllocation.getValue()).iterator();
                        while (appActivitiesIt.hasNext() && curTS - ((AppAllocation)appActivitiesIt.next()).getTime() > ActivitiesManager.this.appActivitiesTTL) {
                            appActivitiesIt.remove();
                        }
                        if (!((Queue)appAllocation.getValue()).isEmpty()) continue;
                        iteApp.remove();
                        LOG.debug("Removed all expired activities from cache for {}.", (Object)rmApp.getApplicationId());
                    }
                    LOG.debug("Remaining apps in app activities cache: {}", ActivitiesManager.this.completedAppAllocations.keySet());
                    ActivitiesManager.this.dynamicallyUpdateAppActivitiesMaxQueueLengthIfNeeded();
                    try {
                        Thread.sleep(ActivitiesManager.this.activitiesCleanupIntervalMs);
                    }
                    catch (InterruptedException e) {
                        LOG.info(ActivitiesManager.this.getName() + " thread interrupted");
                        break;
                    }
                }
            }
        });
        this.cleanUpThread.setName("ActivitiesManager thread.");
        this.cleanUpThread.start();
        super.serviceStart();
    }

    protected void serviceStop() throws Exception {
        this.stopped = true;
        if (this.cleanUpThread != null) {
            this.cleanUpThread.interrupt();
            try {
                this.cleanUpThread.join();
            }
            catch (InterruptedException ie) {
                LOG.warn("Interrupted Exception while stopping", (Throwable)ie);
            }
        }
        super.serviceStop();
    }

    void startNodeUpdateRecording(NodeId nodeID) {
        if (this.recordCount.get() > 0) {
            this.recordNextNodeUpdateActivities(nodeID.toString());
        }
        if (this.activeRecordedNodes.remove(nodeID)) {
            ArrayList nodeAllocation = new ArrayList();
            this.recordingNodesAllocation.get().put(nodeID, nodeAllocation);
            this.diagnosticCollectorManager.get().enable();
        }
    }

    void startAppAllocationRecording(NodeId nodeID, long currTS, SchedulerApplicationAttempt application) {
        ApplicationId applicationId = application.getApplicationId();
        Long turnOffTimestamp = (Long)this.recordingAppActivitiesUntilSpecifiedTime.get(applicationId);
        if (turnOffTimestamp != null) {
            if (turnOffTimestamp > currTS) {
                this.appsAllocation.get().put(applicationId, new AppAllocation(application.getPriority(), nodeID, application.getQueueName()));
                this.diagnosticCollectorManager.get().enable();
            } else {
                this.turnOffActivityMonitoringForApp(applicationId);
            }
        }
    }

    void addSchedulingActivityForNode(NodeId nodeId, String parentName, String childName, Integer priority, ActivityState state, String diagnostic, ActivityLevel level, Long allocationRequestId) {
        if (this.shouldRecordThisNode(nodeId)) {
            NodeAllocation nodeAllocation = this.getCurrentNodeAllocation(nodeId);
            ResourceScheduler scheduler = this.rmContext.getScheduler();
            if (scheduler instanceof CapacityScheduler) {
                CapacityScheduler cs = (CapacityScheduler)this.rmContext.getScheduler();
                parentName = cs.normalizeQueueName(parentName);
                childName = cs.normalizeQueueName(childName);
            }
            nodeAllocation.addAllocationActivity(parentName, childName, priority, state, diagnostic, level, nodeId, allocationRequestId);
        }
    }

    void addSchedulingActivityForApp(ApplicationId applicationId, ContainerId containerId, Integer priority, ActivityState state, String diagnostic, ActivityLevel level, NodeId nodeId, Long allocationRequestId) {
        if (this.shouldRecordThisApp(applicationId)) {
            AppAllocation appAllocation = this.appsAllocation.get().get(applicationId);
            appAllocation.addAppAllocationActivity(containerId == null ? "Container-Id-Not-Assigned" : containerId.toString(), priority, state, diagnostic, level, nodeId, allocationRequestId);
        }
    }

    void updateAllocationFinalState(NodeId nodeID, ContainerId containerId, AllocationState containerState) {
        if (this.shouldRecordThisNode(nodeID)) {
            NodeAllocation nodeAllocation = this.getCurrentNodeAllocation(nodeID);
            nodeAllocation.updateContainerState(containerId, containerState);
        }
    }

    void finishAppAllocationRecording(ApplicationId applicationId, ContainerId containerId, ActivityState appState, String diagnostic) {
        if (this.shouldRecordThisApp(applicationId)) {
            Queue curAppAllocations;
            long currTS = SystemClock.getInstance().getTime();
            AppAllocation appAllocation = this.appsAllocation.get().remove(applicationId);
            appAllocation.updateAppContainerStateAndTime(containerId, appState, currTS, diagnostic);
            Queue<AppAllocation> appAllocations = (ConcurrentLinkedQueue<AppAllocation>)this.completedAppAllocations.get(applicationId);
            if (appAllocations == null && (curAppAllocations = (Queue)this.completedAppAllocations.putIfAbsent(applicationId, appAllocations = new ConcurrentLinkedQueue<AppAllocation>())) != null) {
                appAllocations = curAppAllocations;
            }
            for (int curQueueLength = appAllocations.size(); curQueueLength >= this.appActivitiesMaxQueueLength; --curQueueLength) {
                appAllocations.poll();
            }
            appAllocations.add(appAllocation);
            Long stopTime = (Long)this.recordingAppActivitiesUntilSpecifiedTime.get(applicationId);
            if (stopTime != null && stopTime <= currTS) {
                this.turnOffActivityMonitoringForApp(applicationId);
            }
        }
    }

    void finishNodeUpdateRecording(NodeId nodeID, String partition) {
        List<NodeAllocation> value = this.recordingNodesAllocation.get().get(nodeID);
        long timestamp = SystemClock.getInstance().getTime();
        if (value != null) {
            if (value.size() > 0) {
                this.lastAvailableNodeActivities = value;
                for (NodeAllocation allocation : this.lastAvailableNodeActivities) {
                    allocation.transformToTree();
                    allocation.setTimestamp(timestamp);
                    allocation.setPartition(partition);
                }
                if (this.recordCount.get() > 0) {
                    this.recordCount.getAndDecrement();
                }
            }
            if (this.shouldRecordThisNode(nodeID)) {
                this.recordingNodesAllocation.get().remove(nodeID);
                this.completedNodeAllocations.put(nodeID, value);
                if (this.recordCount.get() >= 0) {
                    this.lastNActivities.add((Pair<NodeId, List<NodeAllocation>>)Pair.of((Object)nodeID, value));
                }
            }
        }
        this.diagnosticCollectorManager.get().disable();
    }

    boolean shouldRecordThisApp(ApplicationId applicationId) {
        if (this.recordingAppActivitiesUntilSpecifiedTime.isEmpty() || this.appsAllocation.get().isEmpty()) {
            return false;
        }
        return this.recordingAppActivitiesUntilSpecifiedTime.containsKey(applicationId) && this.appsAllocation.get().containsKey(applicationId);
    }

    boolean shouldRecordThisNode(NodeId nodeID) {
        return this.isRecordingMultiNodes() || this.recordingNodesAllocation.get().containsKey(nodeID);
    }

    private NodeAllocation getCurrentNodeAllocation(NodeId nodeID) {
        NodeAllocation nodeAllocation;
        NodeId recordingKey = this.isRecordingMultiNodes() ? EMPTY_NODE_ID : nodeID;
        List<NodeAllocation> nodeAllocations = this.recordingNodesAllocation.get().get(recordingKey);
        if (nodeAllocations.size() != 0) {
            nodeAllocation = nodeAllocations.get(nodeAllocations.size() - 1);
            if (nodeAllocation.getFinalAllocationState() != AllocationState.DEFAULT) {
                nodeAllocation = new NodeAllocation(nodeID);
                nodeAllocations.add(nodeAllocation);
            }
        } else {
            nodeAllocation = new NodeAllocation(nodeID);
            nodeAllocations.add(nodeAllocation);
        }
        return nodeAllocation;
    }

    private void turnOffActivityMonitoringForApp(ApplicationId applicationId) {
        this.recordingAppActivitiesUntilSpecifiedTime.remove(applicationId);
    }

    public boolean isRecordingMultiNodes() {
        return this.recordingNodesAllocation.get().containsKey(EMPTY_NODE_ID);
    }

    public NodeId getRecordingNodeId(SchedulerNode node) {
        if (node != null) {
            return node.getNodeID();
        }
        if (this.isRecordingMultiNodes()) {
            return EMPTY_NODE_ID;
        }
        return null;
    }

    public Optional<DiagnosticsCollector> getOptionalDiagnosticsCollector() {
        return this.diagnosticCollectorManager.get().getOptionalDiagnosticsCollector();
    }

    public String getResourceDiagnostics(ResourceCalculator rc, Resource required, Resource available) {
        Optional<DiagnosticsCollector> dcOpt = this.getOptionalDiagnosticsCollector();
        if (dcOpt.isPresent()) {
            dcOpt.get().collectResourceDiagnostics(rc, required, available);
            return ActivitiesManager.getDiagnostics(dcOpt.get());
        }
        return EMPTY_DIAGNOSTICS;
    }

    public static String getDiagnostics(Optional<DiagnosticsCollector> dcOpt) {
        DiagnosticsCollector dc;
        if (dcOpt != null && dcOpt.isPresent() && (dc = dcOpt.get()) != null && dc.getDiagnostics() != null) {
            return ActivitiesManager.getDiagnostics(dc);
        }
        return EMPTY_DIAGNOSTICS;
    }

    private static String getDiagnostics(DiagnosticsCollector dc) {
        StringBuilder sb = new StringBuilder();
        sb.append(", ").append(dc.getDiagnostics());
        if (dc.getDetails() != null) {
            sb.append('\n').append(dc.getDetails());
        }
        return sb.toString();
    }

    @VisibleForTesting
    public int getAppActivitiesMaxQueueLength() {
        return this.appActivitiesMaxQueueLength;
    }

    public static class DiagnosticsCollectorManager {
        private boolean enabled = false;
        private DiagnosticsCollector gdc;

        public boolean isEnabled() {
            return this.enabled;
        }

        public void enable() {
            this.enabled = true;
        }

        public void disable() {
            this.enabled = false;
        }

        public DiagnosticsCollectorManager(DiagnosticsCollector gdc) {
            this.gdc = gdc;
        }

        public Optional<DiagnosticsCollector> getOptionalDiagnosticsCollector() {
            if (this.enabled) {
                return Optional.of(this.gdc);
            }
            return Optional.empty();
        }
    }
}

