/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.rmcontainer;

import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerReport;
import org.apache.hadoop.yarn.api.records.ContainerState;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.ContainerUpdateType;
import org.apache.hadoop.yarn.api.records.ExecutionType;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.server.api.protocolrecords.NMContainerStatus;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppRunningOnNodeEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.event.RMAppAttemptContainerFinishedEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.AllocationExpirationInfo;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.ContainerAllocationExpirer;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerFinishedEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerNMDoneChangeResourceEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerRecoverEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerReservedEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerState;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerUpdatesAcquiredEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeCleanContainerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeUpdateContainerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.ContainerRequest;
import org.apache.hadoop.yarn.server.scheduler.SchedulerRequestKey;
import org.apache.hadoop.yarn.state.InvalidStateTransitionException;
import org.apache.hadoop.yarn.state.MultipleArcTransition;
import org.apache.hadoop.yarn.state.SingleArcTransition;
import org.apache.hadoop.yarn.state.StateMachine;
import org.apache.hadoop.yarn.state.StateMachineFactory;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.apache.hadoop.yarn.webapp.util.WebAppUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RMContainerImpl
implements RMContainer {
    private static final Logger LOG = LoggerFactory.getLogger(RMContainerImpl.class);
    private static final StateMachineFactory<RMContainerImpl, RMContainerState, RMContainerEventType, RMContainerEvent> stateMachineFactory = new StateMachineFactory((Enum)RMContainerState.NEW).addTransition((Enum)RMContainerState.NEW, (Enum)RMContainerState.ALLOCATED, (Enum)RMContainerEventType.START, (SingleArcTransition)new ContainerStartedTransition()).addTransition((Enum)RMContainerState.NEW, (Enum)RMContainerState.KILLED, (Enum)RMContainerEventType.KILL).addTransition((Enum)RMContainerState.NEW, (Enum)RMContainerState.RESERVED, (Enum)RMContainerEventType.RESERVED, (SingleArcTransition)new ContainerReservedTransition()).addTransition((Enum)RMContainerState.NEW, (Enum)RMContainerState.ACQUIRED, (Enum)RMContainerEventType.ACQUIRED, (SingleArcTransition)new AcquiredTransition()).addTransition((Enum)RMContainerState.NEW, EnumSet.of(RMContainerState.RUNNING, RMContainerState.COMPLETED), (Enum)RMContainerEventType.RECOVER, (MultipleArcTransition)new ContainerRecoveredTransition()).addTransition((Enum)RMContainerState.RESERVED, (Enum)RMContainerState.RESERVED, (Enum)RMContainerEventType.RESERVED, (SingleArcTransition)new ContainerReservedTransition()).addTransition((Enum)RMContainerState.RESERVED, (Enum)RMContainerState.ALLOCATED, (Enum)RMContainerEventType.START, (SingleArcTransition)new ContainerStartedTransition()).addTransition((Enum)RMContainerState.RESERVED, (Enum)RMContainerState.KILLED, (Enum)RMContainerEventType.KILL).addTransition((Enum)RMContainerState.RESERVED, (Enum)RMContainerState.RELEASED, (Enum)RMContainerEventType.RELEASED).addTransition((Enum)RMContainerState.ALLOCATED, (Enum)RMContainerState.ACQUIRED, (Enum)RMContainerEventType.ACQUIRED, (SingleArcTransition)new AcquiredTransition()).addTransition((Enum)RMContainerState.ALLOCATED, (Enum)RMContainerState.EXPIRED, (Enum)RMContainerEventType.EXPIRE, (SingleArcTransition)new FinishedTransition()).addTransition((Enum)RMContainerState.ALLOCATED, (Enum)RMContainerState.KILLED, (Enum)RMContainerEventType.KILL, (SingleArcTransition)new FinishedTransition()).addTransition((Enum)RMContainerState.ACQUIRED, (Enum)RMContainerState.RUNNING, (Enum)RMContainerEventType.LAUNCHED).addTransition((Enum)RMContainerState.ACQUIRED, (Enum)RMContainerState.ACQUIRED, (Enum)RMContainerEventType.ACQUIRED).addTransition((Enum)RMContainerState.ACQUIRED, (Enum)RMContainerState.COMPLETED, (Enum)RMContainerEventType.FINISHED, (SingleArcTransition)new FinishedTransition()).addTransition((Enum)RMContainerState.ACQUIRED, (Enum)RMContainerState.RELEASED, (Enum)RMContainerEventType.RELEASED, (SingleArcTransition)new KillTransition()).addTransition((Enum)RMContainerState.ACQUIRED, (Enum)RMContainerState.EXPIRED, (Enum)RMContainerEventType.EXPIRE, (SingleArcTransition)new KillTransition()).addTransition((Enum)RMContainerState.ACQUIRED, (Enum)RMContainerState.KILLED, (Enum)RMContainerEventType.KILL, (SingleArcTransition)new KillTransition()).addTransition((Enum)RMContainerState.RUNNING, (Enum)RMContainerState.COMPLETED, (Enum)RMContainerEventType.FINISHED, (SingleArcTransition)new FinishedTransition()).addTransition((Enum)RMContainerState.RUNNING, (Enum)RMContainerState.KILLED, (Enum)RMContainerEventType.KILL, (SingleArcTransition)new KillTransition()).addTransition((Enum)RMContainerState.RUNNING, (Enum)RMContainerState.RELEASED, (Enum)RMContainerEventType.RELEASED, (SingleArcTransition)new KillTransition()).addTransition((Enum)RMContainerState.RUNNING, (Enum)RMContainerState.RUNNING, (Enum)RMContainerEventType.ACQUIRED).addTransition((Enum)RMContainerState.RUNNING, (Enum)RMContainerState.RUNNING, (Enum)RMContainerEventType.RESERVED, (SingleArcTransition)new ContainerReservedTransition()).addTransition((Enum)RMContainerState.RUNNING, (Enum)RMContainerState.RUNNING, (Enum)RMContainerEventType.ACQUIRE_UPDATED_CONTAINER, (SingleArcTransition)new ContainerAcquiredWhileRunningTransition()).addTransition((Enum)RMContainerState.RUNNING, (Enum)RMContainerState.RUNNING, (Enum)RMContainerEventType.NM_DONE_CHANGE_RESOURCE, (SingleArcTransition)new NMReportedContainerChangeIsDoneTransition()).addTransition((Enum)RMContainerState.COMPLETED, (Enum)RMContainerState.COMPLETED, EnumSet.of(RMContainerEventType.EXPIRE, RMContainerEventType.RELEASED, RMContainerEventType.KILL)).addTransition((Enum)RMContainerState.EXPIRED, (Enum)RMContainerState.EXPIRED, EnumSet.of(RMContainerEventType.RELEASED, RMContainerEventType.KILL)).addTransition((Enum)RMContainerState.RELEASED, (Enum)RMContainerState.RELEASED, EnumSet.of(RMContainerEventType.EXPIRE, RMContainerEventType.RELEASED, RMContainerEventType.KILL, RMContainerEventType.FINISHED)).addTransition((Enum)RMContainerState.KILLED, (Enum)RMContainerState.KILLED, EnumSet.of(RMContainerEventType.EXPIRE, RMContainerEventType.RELEASED, RMContainerEventType.KILL, RMContainerEventType.ACQUIRED, RMContainerEventType.FINISHED)).installTopology();
    private final StateMachine<RMContainerState, RMContainerEventType, RMContainerEvent> stateMachine = stateMachineFactory.make((Object)this);
    private final ReentrantReadWriteLock.ReadLock readLock;
    private final ReentrantReadWriteLock.WriteLock writeLock;
    private final ApplicationAttemptId appAttemptId;
    private final NodeId nodeId;
    private final RMContext rmContext;
    private final EventHandler eventHandler;
    private final ContainerAllocationExpirer containerAllocationExpirer;
    private final String user;
    private final String nodeLabelExpression;
    private volatile Container container;
    private Resource reservedResource;
    private NodeId reservedNode;
    private SchedulerRequestKey reservedSchedulerKey;
    private long creationTime;
    private long finishTime;
    private ContainerStatus finishedStatus;
    private boolean isAMContainer;
    private ContainerRequest containerRequestForRecovery;
    private Resource lastConfirmedResource;
    private volatile String queueName;
    private boolean isExternallyAllocated;
    private SchedulerRequestKey allocatedSchedulerKey;
    private volatile Set<String> allocationTags = null;
    private boolean saveNonAMContainerMetaInfo;

    public RMContainerImpl(Container container, SchedulerRequestKey schedulerKey, ApplicationAttemptId appAttemptId, NodeId nodeId, String user, RMContext rmContext) {
        this(container, schedulerKey, appAttemptId, nodeId, user, rmContext, System.currentTimeMillis(), "");
    }

    public RMContainerImpl(Container container, SchedulerRequestKey schedulerKey, ApplicationAttemptId appAttemptId, NodeId nodeId, String user, RMContext rmContext, boolean isExternallyAllocated) {
        this(container, schedulerKey, appAttemptId, nodeId, user, rmContext, System.currentTimeMillis(), "", isExternallyAllocated);
    }

    public RMContainerImpl(Container container, SchedulerRequestKey schedulerKey, ApplicationAttemptId appAttemptId, NodeId nodeId, String user, RMContext rmContext, String nodeLabelExpression) {
        this(container, schedulerKey, appAttemptId, nodeId, user, rmContext, System.currentTimeMillis(), nodeLabelExpression);
    }

    public RMContainerImpl(Container container, SchedulerRequestKey schedulerKey, ApplicationAttemptId appAttemptId, NodeId nodeId, String user, RMContext rmContext, long creationTime, String nodeLabelExpression) {
        this(container, schedulerKey, appAttemptId, nodeId, user, rmContext, creationTime, nodeLabelExpression, false);
    }

    public RMContainerImpl(Container container, SchedulerRequestKey schedulerKey, ApplicationAttemptId appAttemptId, NodeId nodeId, String user, RMContext rmContext, long creationTime, String nodeLabelExpression, boolean isExternallyAllocated) {
        this.nodeId = nodeId;
        this.container = container;
        this.allocatedSchedulerKey = schedulerKey;
        this.appAttemptId = appAttemptId;
        this.user = user;
        this.creationTime = creationTime;
        this.rmContext = rmContext;
        this.eventHandler = rmContext.getDispatcher().getEventHandler();
        this.containerAllocationExpirer = rmContext.getContainerAllocationExpirer();
        this.isAMContainer = false;
        this.nodeLabelExpression = nodeLabelExpression;
        this.lastConfirmedResource = container.getResource();
        this.isExternallyAllocated = isExternallyAllocated;
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        this.readLock = lock.readLock();
        this.writeLock = lock.writeLock();
        this.saveNonAMContainerMetaInfo = RMContainerImpl.shouldPublishNonAMContainerEventstoATS(rmContext);
        if (container.getId() != null) {
            rmContext.getRMApplicationHistoryWriter().containerStarted(this);
        }
        if (this.container != null) {
            this.allocationTags = this.container.getAllocationTags();
        }
    }

    @Override
    public ContainerId getContainerId() {
        return this.container.getId();
    }

    @Override
    public ApplicationAttemptId getApplicationAttemptId() {
        return this.appAttemptId;
    }

    @Override
    public Container getContainer() {
        return this.container;
    }

    public void setContainer(Container container) {
        this.container = container;
    }

    @Override
    public RMContainerState getState() {
        this.readLock.lock();
        try {
            RMContainerState rMContainerState = (RMContainerState)this.stateMachine.getCurrentState();
            return rMContainerState;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public Resource getReservedResource() {
        return this.reservedResource;
    }

    @Override
    public NodeId getReservedNode() {
        return this.reservedNode;
    }

    @Override
    public SchedulerRequestKey getReservedSchedulerKey() {
        return this.reservedSchedulerKey;
    }

    @Override
    public Resource getAllocatedResource() {
        this.readLock.lock();
        try {
            Resource resource = this.container.getResource();
            return resource;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public Resource getLastConfirmedResource() {
        this.readLock.lock();
        try {
            Resource resource = this.lastConfirmedResource;
            return resource;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public NodeId getAllocatedNode() {
        return this.container.getNodeId();
    }

    @Override
    public SchedulerRequestKey getAllocatedSchedulerKey() {
        return this.allocatedSchedulerKey;
    }

    @Override
    public Priority getAllocatedPriority() {
        return this.container.getPriority();
    }

    @Override
    public long getCreationTime() {
        return this.creationTime;
    }

    @Override
    public long getFinishTime() {
        this.readLock.lock();
        try {
            long l = this.finishTime;
            return l;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public String getDiagnosticsInfo() {
        this.readLock.lock();
        try {
            if (this.finishedStatus != null) {
                String string = this.finishedStatus.getDiagnostics();
                return string;
            }
            String string = null;
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public String getLogURL() {
        this.readLock.lock();
        try {
            StringBuilder logURL = new StringBuilder();
            logURL.append(WebAppUtils.getHttpSchemePrefix((Configuration)this.rmContext.getYarnConfiguration()));
            logURL.append(WebAppUtils.getRunningLogURL((String)this.container.getNodeHttpAddress(), (String)this.getContainerId().toString(), (String)this.user));
            String string = logURL.toString();
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public int getContainerExitStatus() {
        this.readLock.lock();
        try {
            if (this.finishedStatus != null) {
                int n = this.finishedStatus.getExitStatus();
                return n;
            }
            int n = 0;
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public ContainerState getContainerState() {
        this.readLock.lock();
        try {
            if (this.finishedStatus != null) {
                ContainerState containerState = this.finishedStatus.getState();
                return containerState;
            }
            ContainerState containerState = ContainerState.RUNNING;
            return containerState;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public ContainerRequest getContainerRequest() {
        this.readLock.lock();
        try {
            ContainerRequest containerRequest = this.containerRequestForRecovery;
            return containerRequest;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void setContainerRequest(ContainerRequest request) {
        this.writeLock.lock();
        try {
            this.containerRequestForRecovery = request;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public String toString() {
        return this.getContainerId().toString();
    }

    @Override
    public boolean isAMContainer() {
        this.readLock.lock();
        try {
            boolean bl = this.isAMContainer;
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void setAMContainer(boolean isAMContainer) {
        this.writeLock.lock();
        try {
            this.isAMContainer = isAMContainer;
        }
        finally {
            this.writeLock.unlock();
        }
        if (!this.saveNonAMContainerMetaInfo && this.isAMContainer) {
            this.rmContext.getSystemMetricsPublisher().containerCreated(this, this.creationTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(RMContainerEvent event) {
        LOG.debug("Processing {} of type {}", (Object)event.getContainerId(), (Object)event.getType());
        this.writeLock.lock();
        try {
            RMContainerState oldState = this.getState();
            try {
                this.stateMachine.doTransition((Enum)((RMContainerEventType)event.getType()), (Object)event);
            }
            catch (InvalidStateTransitionException e) {
                LOG.error("Can't handle this event at current state", (Throwable)e);
                this.onInvalidStateTransition((RMContainerEventType)event.getType(), oldState);
            }
            if (oldState != this.getState()) {
                LOG.info(event.getContainerId() + " Container Transitioned from " + oldState + " to " + this.getState());
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public boolean completed() {
        return this.finishedStatus != null;
    }

    @Override
    public NodeId getNodeId() {
        return this.nodeId;
    }

    @Override
    public Set<String> getAllocationTags() {
        return this.allocationTags;
    }

    public void setAllocationTags(Set<String> tags) {
        this.allocationTags = tags;
    }

    private static boolean shouldPublishNonAMContainerEventstoATS(RMContext rmContext) {
        return rmContext.getYarnConfiguration().getBoolean("yarn.timeline-service.generic-application-history.save-non-am-container-meta-info", true);
    }

    private static void publishNonAMContainerEventstoATS(RMContainerImpl rmContainer) {
        boolean saveNonAMContainerMetaInfo = RMContainerImpl.shouldPublishNonAMContainerEventstoATS(rmContainer.rmContext);
        if (saveNonAMContainerMetaInfo && null != rmContainer.container.getId()) {
            rmContainer.rmContext.getSystemMetricsPublisher().containerCreated(rmContainer, rmContainer.creationTime);
        }
    }

    @Override
    public ContainerReport createContainerReport() {
        this.readLock.lock();
        ContainerReport containerReport = null;
        try {
            containerReport = ContainerReport.newInstance((ContainerId)this.getContainerId(), (Resource)this.getAllocatedResource(), (NodeId)this.getAllocatedNode(), (Priority)this.getAllocatedSchedulerKey().getPriority(), (long)this.getCreationTime(), (long)this.getFinishTime(), (String)this.getDiagnosticsInfo(), (String)this.getLogURL(), (int)this.getContainerExitStatus(), (ContainerState)this.getContainerState(), (String)this.getNodeHttpAddress(), (ExecutionType)this.getExecutionType());
            containerReport.setExposedPorts(this.getExposedPorts());
        }
        finally {
            this.readLock.unlock();
        }
        return containerReport;
    }

    @Override
    public String getNodeHttpAddress() {
        this.readLock.lock();
        try {
            if (this.container.getNodeHttpAddress() != null) {
                StringBuilder httpAddress = new StringBuilder();
                httpAddress.append(WebAppUtils.getHttpSchemePrefix((Configuration)this.rmContext.getYarnConfiguration()));
                httpAddress.append(this.container.getNodeHttpAddress());
                String string = httpAddress.toString();
                return string;
            }
            String string = null;
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public Map<String, List<Map<String, String>>> getExposedPorts() {
        if (this.container.getExposedPorts() == null) {
            return null;
        }
        return this.container.getExposedPorts();
    }

    @Override
    public void setExposedPorts(Map<String, List<Map<String, String>>> ports) {
        this.container.setExposedPorts(ports);
    }

    @Override
    public String getNodeLabelExpression() {
        if (this.nodeLabelExpression == null) {
            return "";
        }
        return this.nodeLabelExpression;
    }

    public boolean equals(Object obj) {
        if (obj instanceof RMContainer && null != this.getContainerId()) {
            return this.getContainerId().equals((Object)((RMContainer)obj).getContainerId());
        }
        return false;
    }

    public int hashCode() {
        if (null != this.getContainerId()) {
            return this.getContainerId().hashCode();
        }
        return super.hashCode();
    }

    @Override
    public int compareTo(RMContainer o) {
        if (this.getContainerId() != null && o.getContainerId() != null) {
            return this.getContainerId().compareTo(o.getContainerId());
        }
        return -1;
    }

    public void setQueueName(String queueName) {
        this.queueName = queueName;
    }

    @Override
    public String getQueueName() {
        return this.queueName;
    }

    @Override
    public ExecutionType getExecutionType() {
        return this.container.getExecutionType();
    }

    @Override
    public boolean isRemotelyAllocated() {
        return this.isExternallyAllocated;
    }

    @Override
    public Resource getAllocatedOrReservedResource() {
        this.readLock.lock();
        try {
            if (this.getState().equals((Object)RMContainerState.RESERVED)) {
                Resource resource = this.getReservedResource();
                return resource;
            }
            Resource resource = this.getAllocatedResource();
            return resource;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public void setContainerId(ContainerId containerId) {
        this.container.setId(containerId);
        if (containerId != null) {
            this.rmContext.getRMApplicationHistoryWriter().containerStarted(this);
        }
    }

    @VisibleForTesting
    protected void onInvalidStateTransition(RMContainerEventType rmContainerEventType, RMContainerState state) {
        LOG.error("Invalid event " + rmContainerEventType + " on container " + this.getContainerId());
    }

    private static final class ContainerStartedTransition
    extends BaseTransition {
        private ContainerStartedTransition() {
        }

        @Override
        public void transition(RMContainerImpl container, RMContainerEvent event) {
            container.rmContext.getAllocationTagsManager().addContainer(container.getNodeId(), container.getContainerId(), container.getAllocationTags());
            container.eventHandler.handle((Event)new RMAppAttemptEvent(container.appAttemptId, RMAppAttemptEventType.CONTAINER_ALLOCATED));
            RMContainerImpl.publishNonAMContainerEventstoATS(container);
        }
    }

    private static final class ContainerReservedTransition
    extends BaseTransition {
        private ContainerReservedTransition() {
        }

        @Override
        public void transition(RMContainerImpl container, RMContainerEvent event) {
            RMContainerReservedEvent e = (RMContainerReservedEvent)event;
            container.reservedResource = e.getReservedResource();
            container.reservedNode = e.getReservedNode();
            container.reservedSchedulerKey = e.getReservedSchedulerKey();
            Container c = container.getContainer();
            if (c != null) {
                c.setNodeId(container.reservedNode);
            }
        }
    }

    private static final class AcquiredTransition
    extends BaseTransition {
        private AcquiredTransition() {
        }

        @Override
        public void transition(RMContainerImpl container, RMContainerEvent event) {
            container.setContainerRequest(null);
            container.containerAllocationExpirer.register(new AllocationExpirationInfo(container.getContainerId()));
            container.eventHandler.handle((Event)new RMAppRunningOnNodeEvent(container.getApplicationAttemptId().getApplicationId(), container.nodeId, true));
            if (container.getState() == RMContainerState.NEW) {
                RMContainerImpl.publishNonAMContainerEventstoATS(container);
            }
        }
    }

    private static final class ContainerRecoveredTransition
    implements MultipleArcTransition<RMContainerImpl, RMContainerEvent, RMContainerState> {
        private ContainerRecoveredTransition() {
        }

        public RMContainerState transition(RMContainerImpl container, RMContainerEvent event) {
            NMContainerStatus report = ((RMContainerRecoverEvent)event).getContainerReport();
            container.setAllocationTags(report.getAllocationTags());
            container.rmContext.getAllocationTagsManager().addContainer(container.getNodeId(), container.getContainerId(), container.getAllocationTags());
            if (report.getContainerState().equals((Object)ContainerState.COMPLETE)) {
                ContainerStatus status = ContainerStatus.newInstance((ContainerId)report.getContainerId(), (ContainerState)report.getContainerState(), (String)report.getDiagnostics(), (int)report.getContainerExitStatus());
                new FinishedTransition().transition(container, new RMContainerFinishedEvent(container.getContainerId(), status, RMContainerEventType.FINISHED));
                return RMContainerState.COMPLETED;
            }
            if (report.getContainerState().equals((Object)ContainerState.RUNNING)) {
                container.eventHandler.handle((Event)new RMAppRunningOnNodeEvent(container.getApplicationAttemptId().getApplicationId(), container.nodeId));
                return RMContainerState.RUNNING;
            }
            LOG.warn("RMContainer received unexpected recover event with container state " + report.getContainerState() + " while recovering.");
            return RMContainerState.RUNNING;
        }
    }

    private static class FinishedTransition
    extends BaseTransition {
        private FinishedTransition() {
        }

        @Override
        public void transition(RMContainerImpl container, RMContainerEvent event) {
            RMContainerFinishedEvent finishedEvent = (RMContainerFinishedEvent)event;
            container.finishTime = System.currentTimeMillis();
            container.finishedStatus = finishedEvent.getRemoteContainerStatus();
            FinishedTransition.updateAttemptMetrics(container);
            container.eventHandler.handle((Event)new RMAppAttemptContainerFinishedEvent(container.appAttemptId, finishedEvent.getRemoteContainerStatus(), container.getAllocatedNode()));
            container.rmContext.getRMApplicationHistoryWriter().containerFinished(container);
            boolean saveNonAMContainerMetaInfo = RMContainerImpl.shouldPublishNonAMContainerEventstoATS(container.rmContext);
            if (saveNonAMContainerMetaInfo || container.isAMContainer()) {
                container.rmContext.getSystemMetricsPublisher().containerFinished(container, container.finishTime);
            }
        }

        private static void updateAttemptMetrics(RMContainerImpl container) {
            RMAppAttempt rmAttempt;
            Resource resource = container.getContainer().getResource();
            RMApp app = (RMApp)container.rmContext.getRMApps().get(container.getApplicationAttemptId().getApplicationId());
            if (app != null && (rmAttempt = app.getCurrentAppAttempt()) != null) {
                long usedMillis = container.finishTime - container.creationTime;
                rmAttempt.getRMAppAttemptMetrics().updateAggregateAppResourceUsage(resource, usedMillis);
                if (-102 == container.finishedStatus.getExitStatus()) {
                    rmAttempt.getRMAppAttemptMetrics().updatePreemptionInfo(resource, container);
                    rmAttempt.getRMAppAttemptMetrics().updateAggregatePreemptedAppResourceUsage(resource, usedMillis);
                }
            }
        }
    }

    private static final class KillTransition
    extends FinishedTransition {
        private KillTransition() {
        }

        @Override
        public void transition(RMContainerImpl container, RMContainerEvent event) {
            container.containerAllocationExpirer.unregister(new AllocationExpirationInfo(container.getContainerId()));
            container.eventHandler.handle((Event)new RMNodeCleanContainerEvent(container.nodeId, container.getContainerId()));
            super.transition(container, event);
        }
    }

    private static final class ContainerAcquiredWhileRunningTransition
    extends BaseTransition {
        private ContainerAcquiredWhileRunningTransition() {
        }

        @Override
        public void transition(RMContainerImpl container, RMContainerEvent event) {
            RMContainerUpdatesAcquiredEvent acquiredEvent = (RMContainerUpdatesAcquiredEvent)event;
            if (acquiredEvent.isIncreasedContainer()) {
                container.containerAllocationExpirer.register(new AllocationExpirationInfo(event.getContainerId(), true));
            }
        }
    }

    private static final class NMReportedContainerChangeIsDoneTransition
    extends BaseTransition {
        private NMReportedContainerChangeIsDoneTransition() {
        }

        @Override
        public void transition(RMContainerImpl container, RMContainerEvent event) {
            Resource nmContainerResource;
            RMContainerNMDoneChangeResourceEvent nmDoneChangeResourceEvent = (RMContainerNMDoneChangeResourceEvent)event;
            Resource rmContainerResource = container.getAllocatedResource();
            if (Resources.equals((Resource)rmContainerResource, (Resource)(nmContainerResource = nmDoneChangeResourceEvent.getNMContainerResource()))) {
                container.lastConfirmedResource = nmContainerResource;
                container.containerAllocationExpirer.unregister(new AllocationExpirationInfo(event.getContainerId()));
            } else if (Resources.fitsIn((Resource)rmContainerResource, (Resource)nmContainerResource)) {
                container.lastConfirmedResource = rmContainerResource;
                container.containerAllocationExpirer.unregister(new AllocationExpirationInfo(event.getContainerId()));
                container.eventHandler.handle((Event)new RMNodeUpdateContainerEvent(container.nodeId, Collections.singletonMap(container.getContainer(), ContainerUpdateType.DECREASE_RESOURCE)));
            } else if (Resources.fitsIn((Resource)nmContainerResource, (Resource)rmContainerResource)) {
                container.lastConfirmedResource = Resources.componentwiseMax((Resource)nmContainerResource, (Resource)container.lastConfirmedResource);
            } else {
                LOG.warn("Something wrong happened, container size reported by NM is not expected, ContainerID=" + container.getContainerId() + " rm-size-resource:" + rmContainerResource + " nm-size-resource:" + nmContainerResource);
                container.eventHandler.handle((Event)new RMNodeCleanContainerEvent(container.nodeId, container.getContainerId()));
            }
        }
    }

    private static class BaseTransition
    implements SingleArcTransition<RMContainerImpl, RMContainerEvent> {
        private BaseTransition() {
        }

        public void transition(RMContainerImpl cont, RMContainerEvent event) {
        }
    }
}

