/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.placement.csmappingrule;

import java.util.Arrays;
import java.util.Set;
import org.apache.hadoop.yarn.server.resourcemanager.placement.VariableContext;
import org.apache.hadoop.yarn.server.resourcemanager.placement.csmappingrule.MappingRuleMatcher;

public class MappingRuleMatchers {
    private MappingRuleMatchers() {
    }

    public static MappingRuleMatcher createUserMatcher(String userName) {
        return new VariableMatcher("%user", userName);
    }

    public static MappingRuleMatcher createUserGroupMatcher(String groupName) {
        return new UserGroupMatcher(groupName);
    }

    public static MappingRuleMatcher createUserGroupMatcher(String userName, String groupName) {
        return new AndMatcher(MappingRuleMatchers.createUserMatcher(userName), MappingRuleMatchers.createUserGroupMatcher(groupName));
    }

    public static MappingRuleMatcher createApplicationNameMatcher(String name) {
        return new VariableMatcher("%application", name);
    }

    public static MappingRuleMatcher createAllMatcher() {
        return new MatchAllMatcher();
    }

    public static class VariableMatcher
    implements MappingRuleMatcher {
        private String variable;
        private String value;

        VariableMatcher(String variable, String value) {
            this.variable = variable;
            this.value = value == null ? "" : value;
        }

        @Override
        public boolean match(VariableContext variables) {
            if (this.variable == null) {
                return false;
            }
            String substituted = variables.replaceVariables(this.value);
            String originalVariableValue = variables.getOriginal(this.variable);
            if (originalVariableValue != null) {
                return substituted.equals(originalVariableValue);
            }
            return substituted.equals(variables.get(this.variable));
        }

        public String toString() {
            return "VariableMatcher{variable='" + this.variable + "', value='" + this.value + "'}";
        }
    }

    public static class UserGroupMatcher
    implements MappingRuleMatcher {
        private String group;

        UserGroupMatcher(String value) {
            this.group = value;
        }

        @Override
        public boolean match(VariableContext variables) {
            Set<String> groups = variables.getExtraDataset("groups");
            if (this.group == null || groups == null) {
                return false;
            }
            String substituted = variables.replaceVariables(this.group);
            return groups.contains(substituted);
        }

        public String toString() {
            return "GroupMatcher{group='" + this.group + "'}";
        }
    }

    public static class AndMatcher
    implements MappingRuleMatcher {
        private MappingRuleMatcher[] matchers;

        AndMatcher(MappingRuleMatcher ... matchers) {
            this.matchers = matchers;
        }

        @Override
        public boolean match(VariableContext variables) {
            for (MappingRuleMatcher matcher : this.matchers) {
                if (matcher.match(variables)) continue;
                return false;
            }
            return true;
        }

        public String toString() {
            return "AndMatcher{matchers=" + Arrays.toString(this.matchers) + "}";
        }
    }

    public static class MatchAllMatcher
    implements MappingRuleMatcher {
        @Override
        public boolean match(VariableContext variables) {
            return true;
        }

        public String toString() {
            return "MatchAllMatcher";
        }
    }

    public static class OrMatcher
    implements MappingRuleMatcher {
        private MappingRuleMatcher[] matchers;

        OrMatcher(MappingRuleMatcher ... matchers) {
            this.matchers = matchers;
        }

        @Override
        public boolean match(VariableContext variables) {
            for (MappingRuleMatcher matcher : this.matchers) {
                if (!matcher.match(variables)) continue;
                return true;
            }
            return false;
        }

        public String toString() {
            return "OrMatcher{matchers=" + Arrays.toString(this.matchers) + "}";
        }
    }
}

