/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.placement.csmappingrule;

import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.resourcemanager.placement.VariableContext;
import org.apache.hadoop.yarn.server.resourcemanager.placement.csmappingrule.MappingRuleAction;
import org.apache.hadoop.yarn.server.resourcemanager.placement.csmappingrule.MappingRuleActions;
import org.apache.hadoop.yarn.server.resourcemanager.placement.csmappingrule.MappingRuleMatcher;
import org.apache.hadoop.yarn.server.resourcemanager.placement.csmappingrule.MappingRuleMatchers;
import org.apache.hadoop.yarn.server.resourcemanager.placement.csmappingrule.MappingRuleResult;
import org.apache.hadoop.yarn.server.resourcemanager.placement.csmappingrule.MappingRuleValidationContext;

public class MappingRule {
    public static final String USER_MAPPING = "u";
    public static final String GROUP_MAPPING = "g";
    public static final String APPLICATION_MAPPING = "a";
    private final MappingRuleMatcher matcher;
    private final MappingRuleAction action;

    public MappingRule(MappingRuleMatcher matcher, MappingRuleAction action) {
        this.matcher = matcher;
        this.action = action;
    }

    public MappingRuleResult evaluate(VariableContext variables) {
        if (this.matcher.match(variables)) {
            return this.action.execute(variables);
        }
        return MappingRuleResult.createSkipResult();
    }

    public MappingRuleResult getFallback() {
        return this.action.getFallback();
    }

    public static MappingRule createLegacyRule(String source, String path) {
        return MappingRule.createLegacyRule(APPLICATION_MAPPING, source, path);
    }

    public static MappingRule createLegacyRule(String type, String source, String path) {
        MappingRuleAction action = MappingRuleActions.createPlaceToQueueAction(path, true);
        action.setFallbackDefaultPlacement();
        return new MappingRule(switch (type) {
            case USER_MAPPING -> {
                if (source.equals("%user")) {
                    yield MappingRuleMatchers.createAllMatcher();
                }
                yield MappingRuleMatchers.createUserMatcher(source);
            }
            case GROUP_MAPPING -> MappingRuleMatchers.createUserGroupMatcher(source);
            case APPLICATION_MAPPING -> MappingRuleMatchers.createApplicationNameMatcher(source);
            default -> throw new IllegalArgumentException("Invalid mapping rule type '" + type + "'");
        }, action);
    }

    public void validate(MappingRuleValidationContext ctx) throws YarnException {
        this.action.validate(ctx);
    }

    public String toString() {
        return "MappingRule{matcher=" + this.matcher + ", action=" + this.action + "}";
    }
}

