/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.placement;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairSchedulerUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public final class FairQueuePlacementUtils {
    private static final Logger LOG = LoggerFactory.getLogger(FairQueuePlacementUtils.class);
    protected static final String DOT = ".";
    protected static final String DOT_REPLACEMENT = "_dot_";
    protected static final String ROOT_QUEUE = "root";

    private FairQueuePlacementUtils() {
    }

    protected static String cleanName(String name) {
        if ((name = FairSchedulerUtilities.trimQueueName(name)).contains(DOT)) {
            String converted = name.replaceAll("\\.", DOT_REPLACEMENT);
            LOG.warn("Name {} is converted to {} when it is used as a queue name.", (Object)name, (Object)converted);
            return converted;
        }
        return name;
    }

    protected static String assureRoot(String queueName) {
        if (queueName != null && !((String)queueName).isEmpty()) {
            if (!((String)queueName).startsWith("root.") && !((String)queueName).equals(ROOT_QUEUE)) {
                queueName = "root." + (String)queueName;
            }
        } else {
            LOG.warn("AssureRoot: queueName is empty or null.");
        }
        return queueName;
    }

    protected static boolean isValidQueueName(String queueName) {
        return queueName != null && queueName.equals(FairSchedulerUtilities.trimQueueName(queueName)) && !queueName.startsWith(DOT) && !queueName.endsWith(DOT);
    }
}

