/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.webapp.dao.gpu;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.server.nodemanager.webapp.dao.gpu.PerGpuMemoryUsage;
import org.apache.hadoop.yarn.server.nodemanager.webapp.dao.gpu.PerGpuTemperature;
import org.apache.hadoop.yarn.server.nodemanager.webapp.dao.gpu.PerGpuUtilizations;

@InterfaceAudience.Private
@InterfaceStability.Unstable
@XmlRootElement(name="gpu")
public class PerGpuDeviceInformation {
    private String productName = "N/A";
    private String uuid = "N/A";
    private int minorNumber = -1;
    private PerGpuUtilizations gpuUtilizations;
    private PerGpuMemoryUsage gpuMemoryUsage;
    private PerGpuTemperature temperature;

    @XmlElement(name="temperature")
    public PerGpuTemperature getTemperature() {
        return this.temperature;
    }

    public void setTemperature(PerGpuTemperature temperature) {
        this.temperature = temperature;
    }

    @XmlElement(name="uuid")
    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    @XmlElement(name="product_name")
    public String getProductName() {
        return this.productName;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }

    @XmlElement(name="minor_number")
    public int getMinorNumber() {
        return this.minorNumber;
    }

    public void setMinorNumber(int minorNumber) {
        this.minorNumber = minorNumber;
    }

    @XmlElement(name="utilization")
    public PerGpuUtilizations getGpuUtilizations() {
        return this.gpuUtilizations;
    }

    public void setGpuUtilizations(PerGpuUtilizations utilizations) {
        this.gpuUtilizations = utilizations;
    }

    @XmlElement(name="fb_memory_usage")
    public PerGpuMemoryUsage getGpuMemoryUsage() {
        return this.gpuMemoryUsage;
    }

    public void setGpuMemoryUsage(PerGpuMemoryUsage gpuMemoryUsage) {
        this.gpuMemoryUsage = gpuMemoryUsage;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ProductName=").append(this.productName).append(", MinorNumber=").append(this.minorNumber);
        if (this.getGpuMemoryUsage() != null) {
            sb.append(", TotalMemory=").append(this.getGpuMemoryUsage().getTotalMemoryMiB()).append("MiB");
        }
        if (this.getGpuUtilizations() != null) {
            sb.append(", Utilization=").append(this.getGpuUtilizations().getOverallGpuUtilization()).append("%");
        }
        return sb.toString();
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    static class StrToMemAdapter
    extends XmlAdapter<String, Long> {
        StrToMemAdapter() {
        }

        @Override
        public String marshal(Long v) throws Exception {
            if (v == null) {
                return "";
            }
            return String.valueOf(v) + " MiB";
        }

        @Override
        public Long unmarshal(String v) throws Exception {
            if (v == null) {
                return -1L;
            }
            return Long.valueOf(v.split(" ")[0]);
        }
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    static class StrToFloatBeforeSpaceAdapter
    extends XmlAdapter<String, Float> {
        StrToFloatBeforeSpaceAdapter() {
        }

        @Override
        public String marshal(Float v) throws Exception {
            if (v == null) {
                return "";
            }
            return String.valueOf(v);
        }

        @Override
        public Float unmarshal(String v) throws Exception {
            if (v == null) {
                return Float.valueOf(-1.0f);
            }
            return Float.valueOf(v.split(" ")[0]);
        }
    }
}

