/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.webapp;

import java.util.ArrayList;
import java.util.HashMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.AuthenticationFilterInitializer;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.shaded.javax.servlet.Filter;
import org.apache.hadoop.shaded.org.glassfish.jersey.internal.inject.AbstractBinder;
import org.apache.hadoop.shaded.org.glassfish.jersey.internal.inject.InstanceBinding;
import org.apache.hadoop.shaded.org.glassfish.jersey.jettison.JettisonFeature;
import org.apache.hadoop.shaded.org.glassfish.jersey.server.ResourceConfig;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.server.nodemanager.Context;
import org.apache.hadoop.yarn.server.nodemanager.LocalDirsHandlerService;
import org.apache.hadoop.yarn.server.nodemanager.ResourceView;
import org.apache.hadoop.yarn.server.nodemanager.webapp.ContainerShellWebSocket;
import org.apache.hadoop.yarn.server.nodemanager.webapp.ContainerShellWebSocketServlet;
import org.apache.hadoop.yarn.server.nodemanager.webapp.JAXBContextResolver;
import org.apache.hadoop.yarn.server.nodemanager.webapp.NMController;
import org.apache.hadoop.yarn.server.nodemanager.webapp.NMWebAppFilter;
import org.apache.hadoop.yarn.server.nodemanager.webapp.NMWebServices;
import org.apache.hadoop.yarn.server.nodemanager.webapp.TerminalServlet;
import org.apache.hadoop.yarn.server.security.ApplicationACLsManager;
import org.apache.hadoop.yarn.util.StringHelper;
import org.apache.hadoop.yarn.webapp.GenericExceptionHandler;
import org.apache.hadoop.yarn.webapp.WebApp;
import org.apache.hadoop.yarn.webapp.WebApps;
import org.apache.hadoop.yarn.webapp.YarnWebParams;
import org.apache.hadoop.yarn.webapp.util.WebAppUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebServer
extends AbstractService {
    private static final Logger LOG = LoggerFactory.getLogger(WebServer.class);
    private final Context nmContext;
    private final NMWebApp nmWebApp;
    private final ResourceView resourceView;
    private WebApp webApp;
    private int port;

    public WebServer(Context nmContext, ResourceView resView, ApplicationACLsManager aclsManager, LocalDirsHandlerService dirsHandler) {
        super(WebServer.class.getName());
        this.nmContext = nmContext;
        this.nmWebApp = new NMWebApp(resView, aclsManager, dirsHandler);
        this.resourceView = resView;
    }

    protected ResourceConfig configure() {
        ResourceConfig config = new ResourceConfig();
        config.packages("org.apache.hadoop.yarn.server.nodemanager.webapp");
        config.register(new JerseyBinder());
        config.register((Class)NMWebServices.class);
        config.register((Class)GenericExceptionHandler.class);
        config.register(new JettisonFeature()).register((Class)JAXBContextResolver.class);
        return config;
    }

    protected void serviceStart() throws Exception {
        Configuration conf = this.getConfig();
        HashMap params = new HashMap();
        HashMap<String, String> terminalParams = new HashMap<String, String>();
        terminalParams.put("resourceBase", WebServer.class.getClassLoader().getResource("TERMINAL").toExternalForm());
        terminalParams.put("dirAllowed", "false");
        terminalParams.put("pathInfoOnly", "true");
        String bindAddress = WebAppUtils.getWebAppBindURL((Configuration)conf, (String)"yarn.nodemanager.bind-host", (String)WebAppUtils.getNMWebAppURLWithoutScheme((Configuration)conf));
        boolean enableCors = conf.getBoolean("yarn.nodemanager.webapp.cross-origin.enabled", false);
        if (enableCors) {
            this.getConfig().setBoolean("hadoop.http.cross-origin.enabled", true);
        }
        boolean hasHadoopAuthFilterInitializer = false;
        String filterInitializerConfKey = "hadoop.http.filter.initializers";
        Class[] initializersClasses = conf.getClasses(filterInitializerConfKey, new Class[0]);
        ArrayList<String> targets = new ArrayList<String>();
        if (initializersClasses != null) {
            for (Class initializer : initializersClasses) {
                if (initializer.getName().equals(AuthenticationFilterInitializer.class.getName())) {
                    hasHadoopAuthFilterInitializer = true;
                    break;
                }
                targets.add(initializer.getName());
            }
        }
        if (!hasHadoopAuthFilterInitializer) {
            targets.add(AuthenticationFilterInitializer.class.getName());
            conf.set(filterInitializerConfKey, StringUtils.join((CharSequence)",", targets));
        }
        ContainerShellWebSocket.init(this.nmContext);
        LOG.info("Instantiating NMWebApp at {}.", (Object)bindAddress);
        try {
            this.webApp = WebApps.$for((String)"node", Context.class, (Object)this.nmContext, (String)"jersey-ws").at(bindAddress).withServlet("ContainerShellWebSocket", "/container/*", ContainerShellWebSocketServlet.class, params, false).withServlet("Terminal", "/terminal/*", TerminalServlet.class, terminalParams, false).with(conf).withHttpSpnegoPrincipalKey("yarn.nodemanager.webapp.spnego-principal").withHttpSpnegoKeytabKey("yarn.nodemanager.webapp.spnego-keytab-file").withCSRFProtection("yarn.nodemanager.webapp.rest-csrf.").withXFSProtection("yarn.nodemanager.webapp.xfs-filter.").withResourceConfig(this.configure()).start((WebApp)this.nmWebApp);
            this.port = this.webApp.httpServer().getConnectorAddress(0).getPort();
        }
        catch (Exception e) {
            String msg = "NMWebapps failed to start.";
            LOG.error(msg, (Throwable)e);
            throw new YarnRuntimeException(msg, (Throwable)e);
        }
        super.serviceStart();
    }

    public int getPort() {
        return this.port;
    }

    protected void serviceStop() throws Exception {
        if (this.webApp != null) {
            LOG.debug("Stopping webapp");
            this.webApp.stop();
        }
        super.serviceStop();
    }

    public static class NMWebApp
    extends WebApp
    implements YarnWebParams {
        private final ResourceView resourceView;
        private final ApplicationACLsManager aclsManager;
        private final LocalDirsHandlerService dirsHandler;

        public NMWebApp(ResourceView resourceView, ApplicationACLsManager aclsManager, LocalDirsHandlerService dirsHandler) {
            this.resourceView = resourceView;
            this.aclsManager = aclsManager;
            this.dirsHandler = dirsHandler;
        }

        public void setup() {
            this.bind(ResourceView.class).toInstance(this.resourceView);
            this.bind(ApplicationACLsManager.class).toInstance(this.aclsManager);
            this.bind(LocalDirsHandlerService.class).toInstance(this.dirsHandler);
            this.route("/", NMController.class, "info");
            this.route("/node", NMController.class, "node");
            this.route("/allApplications", NMController.class, "allApplications");
            this.route("/allContainers", NMController.class, "allContainers");
            this.route(StringHelper.pajoin((Object[])new Object[]{"/application", "app.id"}), NMController.class, "application");
            this.route(StringHelper.pajoin((Object[])new Object[]{"/container", "container.id"}), NMController.class, "container");
            this.route(StringHelper.pajoin((Object[])new Object[]{"/containerlogs", "container.id", "app.owner", "log.type"}), NMController.class, "logs");
            this.route("/errors-and-warnings", NMController.class, "errorsAndWarnings");
        }

        protected Class<? extends Filter> getWebAppFilterClass() {
            return NMWebAppFilter.class;
        }
    }

    private class JerseyBinder
    extends AbstractBinder {
        private JerseyBinder() {
        }

        @Override
        protected void configure() {
            ((InstanceBinding)this.bind(WebServer.this.nmContext).to(Context.class)).named("nm");
            ((InstanceBinding)this.bind(WebServer.this.nmWebApp).to(WebApp.class)).named("webapp");
            ((InstanceBinding)this.bind(WebServer.this.resourceView).to(ResourceView.class)).named("view");
        }
    }
}

