/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.webapp;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.http.HtmlQuoting;
import org.apache.hadoop.shaded.com.google.inject.Inject;
import org.apache.hadoop.shaded.com.google.inject.Injector;
import org.apache.hadoop.shaded.com.google.inject.Singleton;
import org.apache.hadoop.shaded.javax.servlet.Filter;
import org.apache.hadoop.shaded.javax.servlet.FilterChain;
import org.apache.hadoop.shaded.javax.servlet.FilterConfig;
import org.apache.hadoop.shaded.javax.servlet.ServletException;
import org.apache.hadoop.shaded.javax.servlet.ServletRequest;
import org.apache.hadoop.shaded.javax.servlet.ServletResponse;
import org.apache.hadoop.shaded.javax.servlet.http.HttpServletRequest;
import org.apache.hadoop.shaded.javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.shaded.org.apache.http.NameValuePair;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.server.nodemanager.Context;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.application.Application;
import org.apache.hadoop.yarn.webapp.Controller;
import org.apache.hadoop.yarn.webapp.util.WebAppUtils;

@Singleton
public class NMWebAppFilter
implements Filter {
    private Injector injector;
    private Context nmContext;
    private static final long serialVersionUID = 1L;

    @Inject
    public NMWebAppFilter(Injector injector, Context nmContext) {
        this.injector = injector;
        this.nmContext = nmContext;
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        String redirectPath = this.containerLogPageRedirectPath(request);
        if (redirectPath != null) {
            String redirectMsg = "Redirecting to log server : " + redirectPath;
            PrintWriter out = response.getWriter();
            out.println(redirectMsg);
            response.setHeader("Location", redirectPath);
            response.setStatus(307);
            return;
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    private String containerLogPageRedirectPath(HttpServletRequest request) {
        String uri = HtmlQuoting.quoteHtmlChars((String)request.getRequestURI());
        String redirectPath = null;
        if (!uri.contains("/ws/v1/node") && uri.contains("/containerlogs")) {
            String[] parts = uri.split("/");
            String containerIdStr = parts[3];
            String appOwner = parts[4];
            String logType = null;
            if (parts.length > 5) {
                logType = parts[5];
            }
            if (containerIdStr != null && !containerIdStr.isEmpty()) {
                ContainerId containerId;
                try {
                    containerId = ContainerId.fromString((String)containerIdStr);
                }
                catch (IllegalArgumentException ex) {
                    return redirectPath;
                }
                ApplicationId appId = containerId.getApplicationAttemptId().getApplicationId();
                Application app = (Application)this.nmContext.getApplications().get(appId);
                boolean fetchAggregatedLog = false;
                List params = WebAppUtils.getURLEncodedQueryParam((HttpServletRequest)request);
                if (params != null) {
                    for (NameValuePair param : params) {
                        if (!param.getName().equals("log.aggregation.type") || !param.getValue().equals("remote")) continue;
                        fetchAggregatedLog = true;
                    }
                }
                Configuration nmConf = this.nmContext.getLocalDirsHandler().getConfig();
                if ((app == null || fetchAggregatedLog) && nmConf.getBoolean("yarn.log-aggregation-enable", false)) {
                    String logServerUrl = nmConf.get("yarn.log.server.url");
                    if (logServerUrl != null && !logServerUrl.isEmpty()) {
                        StringBuilder sb = new StringBuilder();
                        sb.append(logServerUrl);
                        sb.append("/");
                        sb.append(this.nmContext.getNodeId().toString());
                        sb.append("/");
                        sb.append(containerIdStr);
                        sb.append("/");
                        sb.append(containerIdStr);
                        sb.append("/");
                        sb.append(appOwner);
                        if (logType != null && !logType.isEmpty()) {
                            sb.append("/");
                            sb.append(logType);
                        }
                        redirectPath = WebAppUtils.appendQueryParams((HttpServletRequest)request, (String)sb.toString());
                    } else {
                        this.injector.getInstance(Controller.RequestContext.class).set("redirect.url", "false");
                    }
                }
            }
        }
        return redirectPath;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }
}

