/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.containermanager.resourceplugin;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.shaded.org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.thirdparty.com.google.common.collect.ImmutableSet;
import org.apache.hadoop.thirdparty.com.google.common.collect.Maps;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.server.nodemanager.Context;
import org.apache.hadoop.yarn.server.nodemanager.api.deviceplugin.DevicePlugin;
import org.apache.hadoop.yarn.server.nodemanager.api.deviceplugin.DevicePluginScheduler;
import org.apache.hadoop.yarn.server.nodemanager.api.deviceplugin.DeviceRegisterRequest;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.resourceplugin.ResourcePlugin;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.resourceplugin.deviceframework.DeviceMappingManager;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.resourceplugin.deviceframework.DevicePluginAdapter;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.resourceplugin.fpga.FpgaResourcePlugin;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.resourceplugin.gpu.GpuDiscoverer;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.resourceplugin.gpu.GpuNodeResourceUpdateHandler;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.resourceplugin.gpu.GpuResourcePlugin;
import org.apache.hadoop.yarn.util.resource.ResourceUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourcePluginManager {
    private static final Logger LOG = LoggerFactory.getLogger(ResourcePluginManager.class);
    private static final Set<String> SUPPORTED_RESOURCE_PLUGINS = ImmutableSet.of((Object)"yarn.io/gpu", (Object)"yarn.io/fpga");
    private Map<String, ResourcePlugin> configuredPlugins = Collections.emptyMap();
    private DeviceMappingManager deviceMappingManager = null;

    public void initialize(Context context) throws YarnException, ClassNotFoundException {
        boolean pluggableDeviceFrameworkEnabled;
        Configuration conf = context.getConf();
        String[] plugins = this.getPluginsFromConfig(conf);
        Map<Object, Object> pluginMap = Maps.newHashMap();
        if (plugins != null) {
            pluginMap = this.initializePlugins(conf, context, plugins);
        }
        if (pluggableDeviceFrameworkEnabled = conf.getBoolean("yarn.nodemanager.pluggable-device-framework.enabled", false)) {
            this.initializePluggableDevicePlugins(context, conf, pluginMap);
        } else {
            LOG.info("The pluggable device framework is not enabled. If you want, please set true to {}", (Object)"yarn.nodemanager.pluggable-device-framework.enabled");
        }
        this.configuredPlugins = Collections.unmodifiableMap(pluginMap);
    }

    private String[] getPluginsFromConfig(Configuration conf) {
        Object[] plugins = conf.getStrings("yarn.nodemanager.resource-plugins");
        if (plugins == null || plugins.length == 0) {
            LOG.info("No Resource plugins found from configuration!");
        }
        LOG.info("Found Resource plugins from configuration: " + Arrays.toString(plugins));
        return plugins;
    }

    private Map<String, ResourcePlugin> initializePlugins(Configuration conf, Context context, String[] plugins) throws YarnException {
        HashMap pluginMap = Maps.newHashMap();
        for (String resourceName : plugins) {
            resourceName = resourceName.trim();
            this.ensurePluginIsSupported(resourceName);
            if (this.isPluginDuplicate(pluginMap, resourceName)) continue;
            ResourcePlugin plugin = null;
            if (resourceName.equals("yarn.io/gpu")) {
                GpuDiscoverer gpuDiscoverer = new GpuDiscoverer();
                GpuNodeResourceUpdateHandler updateHandler = new GpuNodeResourceUpdateHandler(gpuDiscoverer, conf);
                plugin = new GpuResourcePlugin(updateHandler, gpuDiscoverer);
            } else if (resourceName.equals("yarn.io/fpga")) {
                plugin = new FpgaResourcePlugin();
            }
            if (plugin == null) {
                throw new YarnException("This shouldn't happen, plugin=" + resourceName + " should be loaded and initialized");
            }
            plugin.initialize(context);
            LOG.info("Initialized plugin {}", (Object)plugin);
            pluginMap.put(resourceName, plugin);
        }
        return pluginMap;
    }

    private void ensurePluginIsSupported(String resourceName) throws YarnException {
        if (!SUPPORTED_RESOURCE_PLUGINS.contains(resourceName)) {
            String msg = "Trying to initialize resource plugin with name=" + resourceName + ", it is not supported, list of supported plugins:" + StringUtils.join((Object[])new Object[]{",", SUPPORTED_RESOURCE_PLUGINS});
            LOG.error(msg);
            throw new YarnException(msg);
        }
    }

    private boolean isPluginDuplicate(Map<String, ResourcePlugin> pluginMap, String resourceName) {
        if (pluginMap.containsKey(resourceName)) {
            LOG.warn("Ignoring duplicate Resource plugin definition: " + resourceName);
            return true;
        }
        return false;
    }

    public void initializePluggableDevicePlugins(Context context, Configuration configuration, Map<String, ResourcePlugin> pluginMap) throws YarnRuntimeException, ClassNotFoundException {
        String[] pluginClassNames;
        LOG.info("The pluggable device framework enabled,trying to load the vendor plugins");
        if (null == this.deviceMappingManager) {
            LOG.debug("DeviceMappingManager initialized.");
            this.deviceMappingManager = new DeviceMappingManager(context);
        }
        if (null == (pluginClassNames = configuration.getStrings("yarn.nodemanager.pluggable-device-framework.device-classes"))) {
            throw new YarnRuntimeException("Null value found in configuration: yarn.nodemanager.pluggable-device-framework.device-classes");
        }
        for (String pluginClassName : pluginClassNames) {
            Class<?> pluginClazz = Class.forName(pluginClassName);
            if (!DevicePlugin.class.isAssignableFrom(pluginClazz)) {
                throw new YarnRuntimeException("Class: " + pluginClassName + " not instance of " + DevicePlugin.class.getCanonicalName());
            }
            this.checkInterfaceCompatibility(DevicePlugin.class, pluginClazz);
            DevicePlugin dpInstance = (DevicePlugin)ReflectionUtils.newInstance(pluginClazz, (Configuration)configuration);
            DeviceRegisterRequest request = null;
            try {
                request = dpInstance.getRegisterRequestInfo();
            }
            catch (Exception e) {
                throw new YarnRuntimeException("Exception thrown from plugin's getRegisterRequestInfo:" + e.getMessage());
            }
            String resourceName = request.getResourceName();
            if (pluginMap.containsKey(resourceName)) {
                throw new YarnRuntimeException(resourceName + " already registered! Please change resource type name or configure correct resource type name in resource-types.xml for " + pluginClassName);
            }
            if (!this.isConfiguredResourceName(resourceName)) {
                throw new YarnRuntimeException(resourceName + " is not configured inside resource-types.xml , please configure it first");
            }
            LOG.info("New resource type: {} registered successfully by {}", (Object)resourceName, (Object)pluginClassName);
            DevicePluginAdapter pluginAdapter = new DevicePluginAdapter(resourceName, dpInstance, this.deviceMappingManager);
            LOG.info("Adapter of {} created. Initializing..", (Object)pluginClassName);
            try {
                pluginAdapter.initialize(context);
            }
            catch (YarnException e) {
                throw new YarnRuntimeException("Adapter of " + pluginClassName + " init failed!");
            }
            LOG.info("Adapter of {} init success!", (Object)pluginClassName);
            pluginMap.put(request.getResourceName(), pluginAdapter);
            if (!(dpInstance instanceof DevicePluginScheduler)) continue;
            this.checkInterfaceCompatibility(DevicePluginScheduler.class, pluginClazz);
            LOG.info("{} can schedule {} devices.Added as preferred device plugin scheduler", (Object)pluginClassName, (Object)resourceName);
            this.deviceMappingManager.addDevicePluginScheduler(resourceName, (DevicePluginScheduler)((Object)dpInstance));
        }
    }

    @VisibleForTesting
    public void checkInterfaceCompatibility(Class<?> expectedClass, Class<?> actualClass) throws YarnRuntimeException {
        Method[] expectedDevicePluginMethods;
        LOG.debug("Checking implemented interface's compatibility: {}", (Object)expectedClass.getSimpleName());
        for (Method method : expectedDevicePluginMethods = expectedClass.getMethods()) {
            boolean found = false;
            LOG.debug("Try to find method: {}", (Object)method.getName());
            for (Method m : actualClass.getDeclaredMethods()) {
                if (!m.getName().equals(method.getName())) continue;
                LOG.debug("Method {} found in class {}", (Object)m.getName(), (Object)actualClass.getSimpleName());
                found = true;
                break;
            }
            if (found) continue;
            LOG.error("Method {} is not found in plugin", (Object)method.getName());
            throw new YarnRuntimeException("Method " + method.getName() + " is expected but not implemented in " + actualClass.getCanonicalName());
        }
        LOG.info("{} compatibility is ok.", (Object)expectedClass.getSimpleName());
    }

    @VisibleForTesting
    public boolean isConfiguredResourceName(String resourceName) {
        Map configuredResourceTypes = ResourceUtils.getResourceTypes();
        return configuredResourceTypes.containsKey(resourceName);
    }

    @VisibleForTesting
    public void setDeviceMappingManager(DeviceMappingManager deviceMappingManager) {
        this.deviceMappingManager = deviceMappingManager;
    }

    public DeviceMappingManager getDeviceMappingManager() {
        return this.deviceMappingManager;
    }

    public void cleanup() throws YarnException {
        for (ResourcePlugin plugin : this.configuredPlugins.values()) {
            plugin.cleanup();
        }
    }

    public synchronized Map<String, ResourcePlugin> getNameToPlugins() {
        return this.configuredPlugins;
    }
}

