/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.CGroupsResourceCalculator;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.CGroupsV2ResourceCalculator;
import org.apache.hadoop.yarn.util.ProcfsBasedProcessTree;
import org.apache.hadoop.yarn.util.ResourceCalculatorProcessTree;

public class CombinedResourceCalculator
extends ResourceCalculatorProcessTree {
    private final List<ResourceCalculatorProcessTree> resourceCalculators;
    private final ProcfsBasedProcessTree procfsBasedProcessTree;

    public CombinedResourceCalculator(String pid) {
        super(pid);
        this.procfsBasedProcessTree = new ProcfsBasedProcessTree(pid);
        this.resourceCalculators = Arrays.asList(new ResourceCalculatorProcessTree[]{new CGroupsV2ResourceCalculator(pid), new CGroupsResourceCalculator(pid), this.procfsBasedProcessTree});
    }

    public void initialize() throws YarnException {
        for (ResourceCalculatorProcessTree calculator : this.resourceCalculators) {
            calculator.initialize();
        }
    }

    public void updateProcessTree() {
        ((Stream)this.resourceCalculators.stream().parallel()).forEach(ResourceCalculatorProcessTree::updateProcessTree);
    }

    public String getProcessTreeDump() {
        return this.procfsBasedProcessTree.getProcessTreeDump();
    }

    public boolean checkPidPgrpidForMatch() {
        return this.procfsBasedProcessTree.checkPidPgrpidForMatch();
    }

    public long getVirtualMemorySize(int olderThanAge) {
        return this.procfsBasedProcessTree.getVirtualMemorySize(olderThanAge);
    }

    public long getRssMemorySize(int olderThanAge) {
        return this.resourceCalculators.stream().map(calculator -> calculator.getRssMemorySize(olderThanAge)).filter(result -> -1L < result).findAny().orElse(-1L);
    }

    public long getCumulativeCpuTime() {
        return this.resourceCalculators.stream().map(ResourceCalculatorProcessTree::getCumulativeCpuTime).filter(result -> -1L < result).findAny().orElse(-1L);
    }

    public float getCpuUsagePercent() {
        return this.resourceCalculators.stream().map(ResourceCalculatorProcessTree::getCpuUsagePercent).filter(result -> -1.0f < result.floatValue()).findAny().orElse(Float.valueOf(-1.0f)).floatValue();
    }
}

