/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import org.apache.hadoop.shaded.org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.AbstractCGroupsResourceCalculator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CGroupsV2ResourceCalculator
extends AbstractCGroupsResourceCalculator {
    private static final Logger LOG = LoggerFactory.getLogger(CGroupsV2ResourceCalculator.class);
    private static final String CPU_STAT = "cpu.stat#usage_usec";
    private static final String MEM_STAT = "memory.stat#anon";
    private static final String MEMSW_STAT = "memory.swap.current";

    public CGroupsV2ResourceCalculator(String pid) {
        super(pid, Collections.singletonList(CPU_STAT), MEM_STAT, MEMSW_STAT);
    }

    @Override
    protected List<Path> getCGroupFilesToLoadInStats() {
        ArrayList<Path> result = new ArrayList<Path>();
        try (Stream<Path> cGroupFiles = Files.list(this.getCGroupPath());){
            cGroupFiles.forEach(result::add);
        }
        catch (IOException e) {
            LOG.debug("Failed to list cgroup files for pid: " + this.getPid(), (Throwable)e);
        }
        LOG.debug("Found cgroup files for pid {} is {}", (Object)this.getPid(), result);
        return result;
    }

    private Path getCGroupPath() throws IOException {
        return Paths.get(this.getcGroupsHandler().getCGroupV2MountPath(), StringUtils.substringAfterLast((String)this.readLinesFromCGroupFileFromProcDir().get(0), (String)":"));
    }
}

