/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources;

import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.shaded.org.apache.commons.io.FileUtils;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.privileged.PrivilegedOperationExecutor;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.AbstractCGroupsHandler;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.CGroupsHandler;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.ResourceHandlerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
class CGroupsV2HandlerImpl
extends AbstractCGroupsHandler {
    private static final Logger LOG = LoggerFactory.getLogger(CGroupsV2HandlerImpl.class);
    private static final String CGROUP2_FSTYPE = "cgroup2";

    CGroupsV2HandlerImpl(Configuration conf, PrivilegedOperationExecutor privilegedOperationExecutor, String mtab) throws ResourceHandlerException {
        super(conf, privilegedOperationExecutor, mtab);
    }

    CGroupsV2HandlerImpl(Configuration conf, PrivilegedOperationExecutor privilegedOperationExecutor) throws ResourceHandlerException {
        this(conf, privilegedOperationExecutor, "/proc/mounts");
    }

    @Override
    public Set<String> getValidCGroups() {
        return CGroupsHandler.CGroupController.getValidV2CGroups();
    }

    @Override
    protected List<CGroupsHandler.CGroupController> getCGroupControllers() {
        return Arrays.stream(CGroupsHandler.CGroupController.values()).filter(CGroupsHandler.CGroupController::isInV2).collect(Collectors.toList());
    }

    @Override
    protected Map<String, Set<String>> parsePreConfiguredMountPath() {
        HashMap<String, Set<String>> controllerMappings = new HashMap<String, Set<String>>();
        try {
            controllerMappings.put(this.cGroupsMountConfig.getV2MountPath(), this.readControllersFile(this.cGroupsMountConfig.getV2MountPath()));
        }
        catch (IOException e) {
            LOG.info("Failed to read the cgroup controllers file in the preconfigured directory: {}. The cgroup v2 hierarchy may not be mounted under the specified path, or the node might be using cgroup v1.", (Object)this.cGroupsMountConfig.getV2MountPath());
            LOG.debug("Exception while reading the cgroup.controllers file: ", (Throwable)e);
        }
        return controllerMappings;
    }

    @Override
    protected Set<String> handleMtabEntry(String path, String type, String options) throws IOException {
        if (type.equals(CGROUP2_FSTYPE)) {
            return this.readControllersFile(path);
        }
        return null;
    }

    @Override
    protected void mountCGroupController(CGroupsHandler.CGroupController controller) {
        throw new UnsupportedOperationException("Mounting cgroup controllers is not supported in cgroup v2");
    }

    public Set<String> readControllersFile(String cgroupPath) throws IOException {
        File cgroupControllersFile = new File(cgroupPath + "/cgroup.controllers");
        if (!cgroupControllersFile.exists()) {
            throw new IOException("No cgroup controllers file found in the directory specified: " + cgroupPath);
        }
        String enabledControllers = FileUtils.readFileToString((File)cgroupControllersFile, (Charset)StandardCharsets.UTF_8);
        Set<String> validCGroups = this.getValidCGroups();
        HashSet<String> controllerSet = new HashSet<String>(Arrays.asList(enabledControllers.split(" ")));
        controllerSet.retainAll(validCGroups);
        if (controllerSet.isEmpty()) {
            LOG.warn("The following cgroup directory doesn't contain any supported controllers: " + cgroupPath);
        }
        return controllerSet;
    }

    @Override
    protected void updateEnabledControllersInHierarchy(File yarnHierarchy, CGroupsHandler.CGroupController controller) throws ResourceHandlerException {
        try {
            Set<String> enabledControllers = this.readControllersFile(yarnHierarchy.getAbsolutePath());
            if (!enabledControllers.contains(controller.getName())) {
                String errorMsg = String.format("The controller %s is not enabled in the cgroup hierarchy: %s. Please enable it in in the %s/cgroup.subtree_control file.", controller.getName(), yarnHierarchy.getAbsolutePath(), yarnHierarchy.getParentFile().getAbsolutePath());
                throw new ResourceHandlerException(this.getErrorWithDetails(errorMsg, controller.getName(), yarnHierarchy.getAbsolutePath()));
            }
            File subtreeControlFile = new File(yarnHierarchy.getAbsolutePath() + "/cgroup.subtree_control");
            if (!subtreeControlFile.exists()) {
                String errorMsg = "No subtree control file found in the cgroup hierarchy: " + yarnHierarchy.getAbsolutePath();
                throw new ResourceHandlerException(this.getErrorWithDetails(errorMsg, controller.getName(), yarnHierarchy.getAbsolutePath()));
            }
            if (!subtreeControlFile.canWrite()) {
                String errorMsg = "Cannot write the cgroup.subtree_control file in the cgroup hierarchy: " + yarnHierarchy.getAbsolutePath();
                throw new ResourceHandlerException(this.getErrorWithDetails(errorMsg, controller.getName(), yarnHierarchy.getAbsolutePath()));
            }
            OutputStreamWriter w = new OutputStreamWriter(Files.newOutputStream(subtreeControlFile.toPath(), StandardOpenOption.APPEND), StandardCharsets.UTF_8);
            try (PrintWriter pw = new PrintWriter(w);){
                LOG.info("Appending the following controller to the cgroup.subtree_control file: {}, for the cgroup hierarchy: {}", (Object)controller.getName(), (Object)yarnHierarchy.getAbsolutePath());
                pw.write("+" + controller.getName());
                if (pw.checkError()) {
                    String errorMsg = "Failed to add the controller to the cgroup.subtree_control file in the cgroup hierarchy: " + yarnHierarchy.getAbsolutePath();
                    throw new ResourceHandlerException(this.getErrorWithDetails(errorMsg, controller.getName(), yarnHierarchy.getAbsolutePath()));
                }
            }
        }
        catch (IOException e) {
            String errorMsg = "Failed to update the cgroup.subtree_control file in the cgroup hierarchy: " + yarnHierarchy.getAbsolutePath();
            throw new ResourceHandlerException(this.getErrorWithDetails(errorMsg, controller.getName(), yarnHierarchy.getAbsolutePath()));
        }
    }
}

