/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.AbstractCGroupsResourceCalculator;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.CGroupsHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CGroupsResourceCalculator
extends AbstractCGroupsResourceCalculator {
    private static final Logger LOG = LoggerFactory.getLogger(CGroupsResourceCalculator.class);
    private static final String CPU_STAT = "cpuacct.stat";
    private static final String MEM_STAT = "memory.usage_in_bytes";
    private static final String MEMSW_STAT = "memory.memsw.usage_in_bytes";

    public CGroupsResourceCalculator(String pid) {
        super(pid, Arrays.asList("cpuacct.stat#user", "cpuacct.stat#system"), MEM_STAT, MEMSW_STAT);
    }

    @Override
    protected List<Path> getCGroupFilesToLoadInStats() {
        ArrayList<Path> result = new ArrayList<Path>();
        try {
            String cpuRelative = this.getCGroupRelativePath(CGroupsHandler.CGroupController.CPUACCT);
            if (cpuRelative != null) {
                File cpuDir = new File(this.getcGroupsHandler().getControllerPath(CGroupsHandler.CGroupController.CPUACCT), cpuRelative);
                result.add(Paths.get(cpuDir.getAbsolutePath(), CPU_STAT));
            }
        }
        catch (IOException e) {
            LOG.debug("Exception while looking for CPUACCT controller for pid: " + this.getPid(), (Throwable)e);
        }
        try {
            String memoryRelative = this.getCGroupRelativePath(CGroupsHandler.CGroupController.MEMORY);
            if (memoryRelative != null) {
                File memDir = new File(this.getcGroupsHandler().getControllerPath(CGroupsHandler.CGroupController.MEMORY), memoryRelative);
                result.add(Paths.get(memDir.getAbsolutePath(), MEM_STAT));
                result.add(Paths.get(memDir.getAbsolutePath(), MEMSW_STAT));
            }
        }
        catch (IOException e) {
            LOG.debug("Exception while looking for MEMORY controller for pid: " + this.getPid(), (Throwable)e);
        }
        return result;
    }

    private String getCGroupRelativePath(CGroupsHandler.CGroupController controller) throws IOException {
        for (String line : this.readLinesFromCGroupFileFromProcDir()) {
            String cgroupPath;
            Path fileName;
            String[] parts = line.split(":");
            if (!parts[1].contains(controller.getName()) || (fileName = new File(cgroupPath = parts[2]).toPath().getFileName()) == null) continue;
            return this.getcGroupsHandler().getRelativePathForCGroup(fileName.toString());
        }
        LOG.debug("No {} controller found for pid {}", (Object)controller, (Object)this.getPid());
        return null;
    }
}

