/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources;

import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.shaded.org.apache.commons.io.FileUtils;
import org.apache.hadoop.util.CpuTimeTracker;
import org.apache.hadoop.util.SysInfoLinux;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.CGroupsHandler;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.ResourceHandlerModule;
import org.apache.hadoop.yarn.util.Clock;
import org.apache.hadoop.yarn.util.ResourceCalculatorProcessTree;
import org.apache.hadoop.yarn.util.SystemClock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCGroupsResourceCalculator
extends ResourceCalculatorProcessTree {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractCGroupsResourceCalculator.class);
    private final String pid;
    private final Clock clock = SystemClock.getInstance();
    private final Map<String, String> stats = new ConcurrentHashMap<String, String>();
    private long jiffyLengthMs = SysInfoLinux.JIFFY_LENGTH_IN_MILLIS;
    private CpuTimeTracker cpuTimeTracker;
    private CGroupsHandler cGroupsHandler;
    private String procFs = "/proc";
    private final List<String> totalJiffiesKeys;
    private final String rssMemoryKey;
    private final String virtualMemoryKey;

    protected AbstractCGroupsResourceCalculator(String pid, List<String> totalJiffiesKeys, String rssMemoryKey, String virtualMemoryKey) {
        super(pid);
        this.pid = pid;
        this.totalJiffiesKeys = totalJiffiesKeys;
        this.rssMemoryKey = rssMemoryKey;
        this.virtualMemoryKey = virtualMemoryKey;
    }

    public void initialize() throws YarnException {
        this.cpuTimeTracker = new CpuTimeTracker(this.jiffyLengthMs);
        this.cGroupsHandler = ResourceHandlerModule.getCGroupsHandler();
    }

    public long getCumulativeCpuTime() {
        long totalJiffies = this.getTotalJiffies();
        return this.jiffyLengthMs == -1L || totalJiffies == -1L ? -1L : this.getTotalJiffies() * this.jiffyLengthMs;
    }

    public long getRssMemorySize(int olderThanAge) {
        return 1 < olderThanAge ? -1L : this.getStat(this.rssMemoryKey);
    }

    public long getVirtualMemorySize(int olderThanAge) {
        return 1 < olderThanAge ? -1L : this.getStat(this.virtualMemoryKey);
    }

    public String getProcessTreeDump() {
        return this.pid;
    }

    public boolean checkPidPgrpidForMatch() {
        return true;
    }

    public float getCpuUsagePercent() {
        return this.cpuTimeTracker.getCpuTrackerUsagePercent();
    }

    public void updateProcessTree() {
        this.stats.clear();
        for (Path statFile : this.getCGroupFilesToLoadInStats()) {
            try {
                List<String> lines = this.fileToLines(statFile);
                if (1 == lines.size()) {
                    this.addSingleLineToStat(statFile, lines.get(0));
                    continue;
                }
                if (1 >= lines.size()) continue;
                this.addMultiLineToStat(statFile, lines);
            }
            catch (IOException e) {
                LOG.debug(String.format("Failed to read cgroup file %s for pid %s", statFile, this.pid), (Throwable)e);
            }
        }
        LOG.debug("After updateProcessTree the {} pid has stats {}", (Object)this.pid, this.stats);
        this.cpuTimeTracker.updateElapsedJiffies(BigInteger.valueOf(this.getTotalJiffies()), this.clock.getTime());
    }

    private void addSingleLineToStat(Path file, String line) {
        Path fileName = file.getFileName();
        if (fileName != null) {
            this.stats.put(fileName.toString(), line.trim());
        }
    }

    private void addMultiLineToStat(Path file, List<String> lines) {
        for (String line : lines) {
            String[] parts = line.split(" ");
            if (1 >= parts.length) continue;
            this.stats.put(file.getFileName() + "#" + parts[0], parts[1]);
        }
    }

    private long getTotalJiffies() {
        Long reduce = this.totalJiffiesKeys.stream().map(this::getStat).filter(statValue -> statValue != -1L).reduce(0L, Long::sum);
        return reduce == 0L ? -1L : reduce;
    }

    private long getStat(String key) {
        return Long.parseLong(this.stats.getOrDefault(key, String.valueOf(-1)));
    }

    protected abstract List<Path> getCGroupFilesToLoadInStats();

    protected List<String> readLinesFromCGroupFileFromProcDir() throws IOException {
        Path cgroup = Paths.get(this.procFs, this.pid, "cgroup");
        List<String> result = Arrays.asList(this.fileToString(cgroup).split(System.lineSeparator()));
        LOG.debug("The {} pid has the following lines in the procfs cgroup file {}", (Object)this.pid, result);
        return result;
    }

    protected String fileToString(Path path) throws IOException {
        return FileUtils.readFileToString((File)path.toFile(), (Charset)StandardCharsets.UTF_8).trim();
    }

    protected List<String> fileToLines(Path path) throws IOException {
        return !path.toFile().exists() ? Collections.emptyList() : Arrays.asList(FileUtils.readFileToString((File)path.toFile(), (Charset)StandardCharsets.UTF_8).trim().split(System.lineSeparator()));
    }

    @VisibleForTesting
    void setJiffyLengthMs(long jiffyLengthMs) {
        this.jiffyLengthMs = jiffyLengthMs;
    }

    @VisibleForTesting
    void setCpuTimeTracker(CpuTimeTracker cpuTimeTracker) {
        this.cpuTimeTracker = cpuTimeTracker;
    }

    @VisibleForTesting
    void setcGroupsHandler(CGroupsHandler cGroupsHandler) {
        this.cGroupsHandler = cGroupsHandler;
    }

    @VisibleForTesting
    void setProcFs(String procFs) {
        this.procFs = procFs;
    }

    public CGroupsHandler getcGroupsHandler() {
        return this.cGroupsHandler;
    }

    public String getPid() {
        return this.pid;
    }
}

