/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ExecutionType;
import org.apache.hadoop.yarn.security.ContainerTokenIdentifier;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.Container;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.privileged.PrivilegedOperation;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.CGroupsHandler;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.CGroupsMemoryResourceHandlerImpl;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.MemoryResourceHandler;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.ResourceHandlerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceStability.Unstable
@InterfaceAudience.Private
public abstract class AbstractCGroupsMemoryResourceHandler
implements MemoryResourceHandler {
    static final Logger LOG = LoggerFactory.getLogger(CGroupsMemoryResourceHandlerImpl.class);
    protected static final CGroupsHandler.CGroupController MEMORY = CGroupsHandler.CGroupController.MEMORY;
    private CGroupsHandler cGroupsHandler;
    protected static final int OPPORTUNISTIC_SOFT_LIMIT = 0;
    private float softLimit = 0.0f;
    private boolean enforce = true;

    public AbstractCGroupsMemoryResourceHandler(CGroupsHandler cGroupsHandler) {
        this.cGroupsHandler = cGroupsHandler;
    }

    protected CGroupsHandler getCGroupsHandler() {
        return this.cGroupsHandler;
    }

    @Override
    public List<PrivilegedOperation> bootstrap(Configuration conf) throws ResourceHandlerException {
        this.cGroupsHandler.initializeCGroupController(MEMORY);
        this.enforce = conf.getBoolean("yarn.nodemanager.resource.memory.enforced", true);
        float softLimitPerc = conf.getFloat("yarn.nodemanager.resource.memory.cgroups.soft-limit-percentage", 90.0f);
        this.softLimit = softLimitPerc / 100.0f;
        if (softLimitPerc < 0.0f || softLimitPerc > 100.0f) {
            throw new ResourceHandlerException("Illegal value '" + softLimitPerc + "' yarn.nodemanager.resource.memory.cgroups.soft-limit-percentage. Value must be between 0 and 100.");
        }
        return null;
    }

    @Override
    public List<PrivilegedOperation> updateContainer(Container container) throws ResourceHandlerException {
        String cgroupId = container.getContainerId().toString();
        File cgroup = new File(this.cGroupsHandler.getPathForCGroup(MEMORY, cgroupId));
        if (cgroup.exists()) {
            long containerSoftLimit = (long)((float)container.getResource().getMemorySize() * this.softLimit);
            long containerHardLimit = container.getResource().getMemorySize();
            if (this.enforce) {
                try {
                    this.updateMemoryHardLimit(cgroupId, containerHardLimit);
                    ContainerTokenIdentifier id = container.getContainerTokenIdentifier();
                    if (id != null && id.getExecutionType() == ExecutionType.OPPORTUNISTIC) {
                        this.updateOpportunisticMemoryLimits(cgroupId);
                    } else {
                        this.updateGuaranteedMemoryLimits(cgroupId, containerSoftLimit);
                    }
                }
                catch (ResourceHandlerException re) {
                    this.cGroupsHandler.deleteCGroup(MEMORY, cgroupId);
                    LOG.warn("Could not update cgroup for container", (Throwable)((Object)re));
                    throw re;
                }
            }
        }
        return null;
    }

    protected abstract void updateMemoryHardLimit(String var1, long var2) throws ResourceHandlerException;

    protected abstract void updateOpportunisticMemoryLimits(String var1) throws ResourceHandlerException;

    protected abstract void updateGuaranteedMemoryLimits(String var1, long var2) throws ResourceHandlerException;

    @Override
    public List<PrivilegedOperation> reacquireContainer(ContainerId containerId) throws ResourceHandlerException {
        return null;
    }

    @Override
    public List<PrivilegedOperation> preStart(Container container) throws ResourceHandlerException {
        String cgroupId = container.getContainerId().toString();
        this.cGroupsHandler.createCGroup(MEMORY, cgroupId);
        this.updateContainer(container);
        ArrayList<PrivilegedOperation> ret = new ArrayList<PrivilegedOperation>();
        ret.add(new PrivilegedOperation(PrivilegedOperation.OperationType.ADD_PID_TO_CGROUP, "cgroups=" + this.cGroupsHandler.getPathForCGroupTasks(MEMORY, cgroupId)));
        return ret;
    }

    @Override
    public List<PrivilegedOperation> postComplete(ContainerId containerId) throws ResourceHandlerException {
        this.cGroupsHandler.deleteCGroup(MEMORY, containerId.toString());
        return null;
    }

    @Override
    public List<PrivilegedOperation> teardown() throws ResourceHandlerException {
        return null;
    }

    public String toString() {
        return AbstractCGroupsMemoryResourceHandler.class.getName();
    }
}

