/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.containermanager;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.regex.Pattern;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.service.ServiceStateChangeListener;
import org.apache.hadoop.shaded.com.fasterxml.jackson.databind.DeserializationFeature;
import org.apache.hadoop.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hadoop.util.Preconditions;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.api.records.LocalResourceType;
import org.apache.hadoop.yarn.api.records.LocalResourceVisibility;
import org.apache.hadoop.yarn.api.records.URL;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.server.api.ApplicationInitializationContext;
import org.apache.hadoop.yarn.server.api.ApplicationTerminationContext;
import org.apache.hadoop.yarn.server.api.AuxiliaryLocalPathHandler;
import org.apache.hadoop.yarn.server.api.AuxiliaryService;
import org.apache.hadoop.yarn.server.api.ContainerInitializationContext;
import org.apache.hadoop.yarn.server.api.ContainerTerminationContext;
import org.apache.hadoop.yarn.server.nodemanager.Context;
import org.apache.hadoop.yarn.server.nodemanager.DeletionService;
import org.apache.hadoop.yarn.server.nodemanager.LocalDirsHandlerService;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.AuxServicesEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.AuxServicesEventType;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.AuxiliaryServiceWithCustomClassLoader;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.deletion.task.FileDeletionTask;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.records.AuxServiceConfiguration;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.records.AuxServiceFile;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.records.AuxServiceRecord;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.records.AuxServiceRecords;
import org.apache.hadoop.yarn.util.FSDownload;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuxServices
extends AbstractService
implements ServiceStateChangeListener,
EventHandler<AuxServicesEvent> {
    public static final String NM_AUX_SERVICE_DIR = "nmAuxService";
    public static final FsPermission NM_AUX_SERVICE_DIR_PERM = new FsPermission(448);
    public static final String CLASS_NAME = "class.name";
    public static final String SYSTEM_CLASSES = "system.classes";
    static final String STATE_STORE_ROOT_NAME = "nm-aux-services";
    private static final Logger LOG = LoggerFactory.getLogger(AuxServices.class);
    private static final String DEL_SUFFIX = "_DEL_";
    private final Map<String, AuxiliaryService> serviceMap;
    private final Map<String, AuxServiceRecord> serviceRecordMap;
    private final Map<String, ByteBuffer> serviceMetaData;
    private final AuxiliaryLocalPathHandler auxiliaryLocalPathHandler;
    private final LocalDirsHandlerService dirsHandler;
    private final DeletionService delService;
    private final UserGroupInformation userUGI;
    private final FsPermission storeDirPerms = new FsPermission(448);
    private Path stateStoreRoot = null;
    private FileSystem stateStoreFs = null;
    private volatile boolean manifestEnabled = false;
    private volatile Path manifest;
    private volatile FileSystem manifestFS;
    private Timer manifestReloadTimer;
    private TimerTask manifestReloadTask;
    private long manifestReloadInterval;
    private long manifestModifyTS = -1L;
    private final ObjectMapper mapper;
    private final Pattern p = Pattern.compile("^[A-Za-z_]+[A-Za-z0-9_]*$");

    AuxServices(AuxiliaryLocalPathHandler auxiliaryLocalPathHandler, Context nmContext, DeletionService deletionService) {
        super(AuxServices.class.getName());
        this.serviceMap = Collections.synchronizedMap(new HashMap());
        this.serviceRecordMap = Collections.synchronizedMap(new HashMap());
        this.serviceMetaData = Collections.synchronizedMap(new HashMap());
        this.auxiliaryLocalPathHandler = auxiliaryLocalPathHandler;
        this.dirsHandler = nmContext.getLocalDirsHandler();
        this.delService = deletionService;
        this.userUGI = this.getRemoteUgi();
        this.mapper = new ObjectMapper();
        this.mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    public boolean isManifestEnabled() {
        return this.manifestEnabled;
    }

    protected final synchronized void addService(String name, AuxiliaryService service, AuxServiceRecord serviceRecord) {
        LOG.info("Adding auxiliary service " + serviceRecord.getName() + " version " + serviceRecord.getVersion());
        this.serviceMap.put(name, service);
        this.serviceRecordMap.put(name, serviceRecord);
    }

    Collection<AuxiliaryService> getServices() {
        return Collections.unmodifiableCollection(this.serviceMap.values());
    }

    public Collection<AuxServiceRecord> getServiceRecords() {
        return Collections.unmodifiableCollection(this.serviceRecordMap.values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, ByteBuffer> getMetaData() {
        HashMap<String, ByteBuffer> metaClone = new HashMap<String, ByteBuffer>(this.serviceMetaData.size());
        Map<String, ByteBuffer> map = this.serviceMetaData;
        synchronized (map) {
            for (Map.Entry<String, ByteBuffer> entry : this.serviceMetaData.entrySet()) {
                metaClone.put(entry.getKey(), entry.getValue().duplicate());
            }
        }
        return metaClone;
    }

    private AuxiliaryService createAuxServiceFromConfiguration(AuxServiceRecord service) {
        Configuration c = new Configuration(false);
        c.set(CLASS_NAME, AuxServices.getClassName(service));
        Class sClass = c.getClass(CLASS_NAME, null, AuxiliaryService.class);
        if (sClass == null) {
            throw new YarnRuntimeException("No class defined for auxiliary service" + service.getName());
        }
        return (AuxiliaryService)ReflectionUtils.newInstance((Class)sClass, null);
    }

    private AuxiliaryService createAuxServiceFromLocalClasspath(AuxServiceRecord service, String appLocalClassPath, Configuration conf) throws IOException, ClassNotFoundException {
        Preconditions.checkArgument((appLocalClassPath != null && !appLocalClassPath.isEmpty() ? 1 : 0) != 0, (Object)"local classpath was null in createAuxServiceFromLocalClasspath");
        String sName = service.getName();
        String className = AuxServices.getClassName(service);
        if (service.getConfiguration() != null && service.getConfiguration().getFiles().size() > 0) {
            throw new YarnRuntimeException("The aux service:" + sName + " has configured local classpath:" + appLocalClassPath + " and config files:" + service.getConfiguration().getFiles() + ". Only one of them should be configured.");
        }
        return AuxiliaryServiceWithCustomClassLoader.getInstance(conf, className, appLocalClassPath, AuxServices.getSystemClasses(service));
    }

    private AuxiliaryService createAuxService(AuxServiceRecord service, Configuration conf, boolean fromConfiguration) throws IOException, ClassNotFoundException {
        List<AuxServiceFile> files;
        String appLocalClassPath;
        String sName = service.getName();
        String className = AuxServices.getClassName(service);
        if (className == null || className.isEmpty()) {
            throw new YarnRuntimeException("Class name not provided for auxiliary service " + sName);
        }
        if (fromConfiguration && (appLocalClassPath = conf.get(String.format("yarn.nodemanager.aux-services.%s.classpath", sName))) != null && !appLocalClassPath.isEmpty()) {
            return this.createAuxServiceFromLocalClasspath(service, appLocalClassPath, conf);
        }
        AuxServiceConfiguration serviceConf = service.getConfiguration();
        ArrayList<Path> destFiles = new ArrayList<Path>();
        if (serviceConf != null && (files = serviceConf.getFiles()) != null) {
            for (AuxServiceFile file : files) {
                destFiles.add(this.maybeDownloadJars(sName, className, file.getSrcFile(), file.getType(), conf));
            }
        }
        if (destFiles.size() > 0) {
            LOG.info("The aux service:" + sName + " is using the custom classloader with classpath " + destFiles);
            return AuxiliaryServiceWithCustomClassLoader.getInstance(conf, className, StringUtils.join((char)File.pathSeparatorChar, destFiles), AuxServices.getSystemClasses(service));
        }
        return this.createAuxServiceFromConfiguration(service);
    }

    @VisibleForTesting
    protected Path maybeDownloadJars(String sName, String className, String remoteFile, AuxServiceFile.TypeEnum type, Configuration conf) throws IOException {
        LocalResourceType srcType;
        FileStatus[] allSubDirs;
        Path src;
        FileContext remoteLFS;
        FileStatus scFileStatus;
        FileContext localLFS = this.getLocalFileContext(conf);
        Path nmAuxDir = this.dirsHandler.getLocalPathForWrite("./nmAuxService");
        if (!localLFS.util().exists(nmAuxDir)) {
            try {
                localLFS.mkdir(nmAuxDir, NM_AUX_SERVICE_DIR_PERM, true);
            }
            catch (IOException ex) {
                throw new YarnRuntimeException("Fail to create dir:" + nmAuxDir.toString(), (Throwable)ex);
            }
        }
        if (!(scFileStatus = (remoteLFS = this.getRemoteFileContext((src = new Path(remoteFile)).toUri(), conf)).getFileStatus(src)).getOwner().equals(this.userUGI.getShortUserName())) {
            throw new YarnRuntimeException("The remote jarfile owner:" + scFileStatus.getOwner() + " is not the same as the NM user:" + this.userUGI.getShortUserName() + ".");
        }
        if ((scFileStatus.getPermission().toShort() & 0x12) != 0) {
            throw new YarnRuntimeException("The remote jarfile should not be writable by group or others. The current Permission is " + scFileStatus.getPermission().toShort());
        }
        Path downloadDest = new Path(nmAuxDir, className + "_" + scFileStatus.getModificationTime());
        Path targetDirPath = new Path(downloadDest, scFileStatus.getPath().getName());
        for (FileStatus sub : allSubDirs = localLFS.util().listStatus(nmAuxDir)) {
            if (sub.getPath().getName().equals(downloadDest.getName())) {
                return targetDirPath;
            }
            if (!sub.getPath().getName().contains(className) || sub.getPath().getName().endsWith(DEL_SUFFIX)) continue;
            Path delPath = new Path(sub.getPath().getParent(), sub.getPath().getName() + DEL_SUFFIX);
            localLFS.rename(sub.getPath(), delPath, new Options.Rename[0]);
            LOG.info("delete old aux service jar dir:" + delPath.toString());
            FileDeletionTask deletionTask = new FileDeletionTask(this.delService, null, delPath, null);
            this.delService.delete(deletionTask);
        }
        if (type == AuxServiceFile.TypeEnum.STATIC) {
            srcType = LocalResourceType.FILE;
        } else if (type == AuxServiceFile.TypeEnum.ARCHIVE) {
            srcType = LocalResourceType.ARCHIVE;
        } else {
            throw new YarnRuntimeException("Cannot unpack file of type " + type + " from remote-file-path:" + src + "for aux-service:.\n");
        }
        LocalResource scRsrc = LocalResource.newInstance((URL)URL.fromURI((URI)src.toUri()), (LocalResourceType)srcType, (LocalResourceVisibility)LocalResourceVisibility.PRIVATE, (long)scFileStatus.getLen(), (long)scFileStatus.getModificationTime());
        FSDownload download = new FSDownload(localLFS, null, conf, downloadDest, scRsrc, null);
        try {
            return download.call();
        }
        catch (Exception ex) {
            throw new YarnRuntimeException("Exception happend while downloading files for aux-service:" + sName + " and remote-file-path:" + src + ".\n" + ex.getMessage());
        }
    }

    private void setStateStoreDir(String sName, AuxiliaryService s) throws IOException {
        if (this.stateStoreRoot != null) {
            Path storePath = new Path(this.stateStoreRoot, sName);
            this.stateStoreFs.mkdirs(storePath, this.storeDirPerms);
            s.setRecoveryPath(storePath);
        }
    }

    private synchronized void maybeRemoveAuxService(String sName) {
        AuxiliaryService s = this.serviceMap.remove(sName);
        this.serviceRecordMap.remove(sName);
        this.serviceMetaData.remove(sName);
        if (s != null) {
            LOG.info("Removing aux service " + sName);
            this.stopAuxService((Service)s);
        }
    }

    private AuxiliaryService initAuxService(AuxServiceRecord service, Configuration conf, boolean fromConfiguration) throws IOException {
        AuxiliaryService s;
        String sName = service.getName();
        try {
            Preconditions.checkArgument((boolean)this.validateAuxServiceName(sName), (Object)("The auxiliary service name: " + sName + " is invalid. The valid service name should only contain a-zA-Z0-9_ and cannot start with numbers."));
            s = this.createAuxService(service, conf, fromConfiguration);
            if (s == null) {
                throw new YarnRuntimeException("No auxiliary service class loaded for " + sName);
            }
            if (!sName.equals(s.getName())) {
                LOG.warn("The Auxiliary Service named '" + sName + "' in the configuration is for " + s.getClass() + " which has a name of '" + s.getName() + "'. Because these are not the same tools trying to send ServiceData and read Service Meta Data may have issues unless the refer to the name in the config.");
            }
            s.setAuxiliaryLocalPathHandler(this.auxiliaryLocalPathHandler);
            this.setStateStoreDir(sName, s);
            Configuration customConf = new Configuration(conf);
            if (service.getConfiguration() != null) {
                for (Map.Entry<String, String> entry : service.getConfiguration().getProperties().entrySet()) {
                    customConf.set(entry.getKey(), entry.getValue());
                }
            }
            s.init(customConf);
            LOG.info("Initialized auxiliary service " + sName);
        }
        catch (RuntimeException e) {
            LOG.error("Failed to initialize " + sName, (Throwable)e);
            throw e;
        }
        catch (ClassNotFoundException e) {
            throw new YarnRuntimeException((Throwable)e);
        }
        return s;
    }

    @VisibleForTesting
    protected void reloadManifest() throws IOException {
        this.loadManifest(this.getConfig(), true);
    }

    public synchronized void reload(AuxServiceRecords services) throws IOException {
        if (!this.manifestEnabled) {
            throw new IOException("Dynamic reloading is not enabled via yarn.nodemanager.aux-services.manifest.enabled");
        }
        if (this.getServiceState() != Service.STATE.STARTED) {
            throw new IOException("Auxiliary services have not been started yet, please retry later");
        }
        LOG.info("Received list of auxiliary services: " + this.mapper.writeValueAsString((Object)services));
        this.loadServices(services, this.getConfig(), true);
    }

    @VisibleForTesting
    boolean checkManifestPermissions(FileStatus status) throws IOException {
        if ((status.getPermission().toShort() & 0x12) != 0) {
            LOG.error("Manifest file and parents must not be writable by group or others. The current Permission of " + status.getPath() + " is " + status.getPermission());
            return false;
        }
        Path parent = status.getPath().getParent();
        if (parent == null) {
            return true;
        }
        return this.checkManifestPermissions(this.getManifestFS().getFileStatus(parent));
    }

    private boolean checkManifestOwnerAndPermissions(FileStatus status) throws IOException {
        AccessControlList yarnAdminAcl = new AccessControlList(this.getConfig().get("yarn.admin.acl", "*"));
        if (!yarnAdminAcl.isUserAllowed(UserGroupInformation.createRemoteUser((String)status.getOwner()))) {
            LOG.error("Manifest must be owned by YARN admin: " + this.manifest);
            return false;
        }
        return this.checkManifestPermissions(status);
    }

    private synchronized AuxServiceRecords maybeReadManifestFile() throws IOException {
        FileStatus status;
        if (this.manifest == null) {
            return null;
        }
        if (!this.manifestFS.exists(this.manifest)) {
            LOG.warn("Manifest file " + this.manifest + " doesn't exist");
            return null;
        }
        try {
            status = this.manifestFS.getFileStatus(this.manifest);
        }
        catch (FileNotFoundException e) {
            LOG.warn("Manifest file " + this.manifest + " doesn't exist");
            return null;
        }
        if (!status.isFile()) {
            LOG.warn("Manifest file " + this.manifest + " is not a file");
        }
        if (!this.checkManifestOwnerAndPermissions(status)) {
            return null;
        }
        if (status.getModificationTime() == this.manifestModifyTS) {
            return null;
        }
        this.manifestModifyTS = status.getModificationTime();
        LOG.info("Reading auxiliary services manifest " + this.manifest);
        try (FSDataInputStream in = this.manifestFS.open(this.manifest);){
            AuxServiceRecords auxServiceRecords = (AuxServiceRecords)this.mapper.readValue((InputStream)in, AuxServiceRecords.class);
            return auxServiceRecords;
        }
    }

    @VisibleForTesting
    protected synchronized void loadManifest(Configuration conf, boolean startServices) throws IOException {
        if (!this.manifestEnabled) {
            throw new IOException("Dynamic reloading is not enabled via yarn.nodemanager.aux-services.manifest.enabled");
        }
        if (this.manifest == null) {
            return;
        }
        if (!this.manifestFS.exists(this.manifest)) {
            if (this.serviceMap.isEmpty()) {
                return;
            }
            LOG.info("Manifest file " + this.manifest + " doesn't exist, stopping auxiliary services");
            HashSet<String> servicesToRemove = new HashSet<String>(this.serviceMap.keySet());
            for (String sName : servicesToRemove) {
                this.maybeRemoveAuxService(sName);
            }
            return;
        }
        AuxServiceRecords services = this.maybeReadManifestFile();
        this.loadServices(services, conf, startServices);
    }

    private synchronized void loadServices(AuxServiceRecords services, Configuration conf, boolean startServices) throws IOException {
        if (services == null) {
            return;
        }
        HashSet<String> loadedAuxServices = new HashSet<String>();
        boolean foundChanges = false;
        if (services.getServices() != null) {
            for (AuxServiceRecord service : services.getServices()) {
                AuxServiceRecord existingService = this.serviceRecordMap.get(service.getName());
                loadedAuxServices.add(service.getName());
                if (existingService != null && existingService.equals(service)) {
                    LOG.debug("Auxiliary service already loaded: {}", (Object)service.getName());
                    continue;
                }
                foundChanges = true;
                try {
                    this.maybeRemoveAuxService(service.getName());
                    AuxiliaryService s = this.initAuxService(service, conf, false);
                    if (startServices) {
                        this.startAuxService(service.getName(), s, service);
                    }
                    this.addService(service.getName(), s, service);
                }
                catch (IOException e) {
                    LOG.error("Failed to load auxiliary service " + service.getName());
                }
            }
        }
        HashSet<String> servicesToRemove = new HashSet<String>(this.serviceMap.keySet());
        servicesToRemove.removeAll(loadedAuxServices);
        for (String sName : servicesToRemove) {
            foundChanges = true;
            this.maybeRemoveAuxService(sName);
        }
        if (!foundChanges) {
            LOG.info("No auxiliary services changes detected");
        }
    }

    private static String getClassName(AuxServiceRecord service) {
        AuxServiceConfiguration serviceConf = service.getConfiguration();
        if (serviceConf == null) {
            return null;
        }
        return serviceConf.getProperty(CLASS_NAME);
    }

    private static String[] getSystemClasses(AuxServiceRecord service) {
        AuxServiceConfiguration serviceConf = service.getConfiguration();
        if (serviceConf == null || serviceConf.getProperty(SYSTEM_CLASSES) == null) {
            return new String[0];
        }
        return StringUtils.split((String)serviceConf.getProperty(SYSTEM_CLASSES));
    }

    private static AuxServiceRecord createServiceRecordFromConfiguration(String sName, Configuration conf) {
        String className = conf.get(String.format("yarn.nodemanager.aux-services.%s.class", sName));
        String remoteClassPath = conf.get(String.format("yarn.nodemanager.aux-services.%s.remote-classpath", sName));
        String[] systemClasses = conf.getTrimmedStrings(String.format("yarn.nodemanager.aux-services.%s.system-classes", sName));
        AuxServiceConfiguration serviceConf = new AuxServiceConfiguration();
        if (className != null) {
            serviceConf.setProperty(CLASS_NAME, className);
        }
        if (systemClasses != null) {
            serviceConf.setProperty(SYSTEM_CLASSES, StringUtils.join((CharSequence)",", (String[])systemClasses));
        }
        if (remoteClassPath != null) {
            AuxServiceFile.TypeEnum type;
            String lcClassPath = StringUtils.toLowerCase((String)remoteClassPath);
            if (lcClassPath.endsWith(".jar")) {
                type = AuxServiceFile.TypeEnum.STATIC;
            } else if (lcClassPath.endsWith(".zip") || lcClassPath.endsWith(".tar.gz") || lcClassPath.endsWith(".tgz") || lcClassPath.endsWith(".tar")) {
                type = AuxServiceFile.TypeEnum.ARCHIVE;
            } else {
                throw new YarnRuntimeException("Cannot unpack file from remote-file-path:" + remoteClassPath + "for aux-service:" + sName + ".\n");
            }
            AuxServiceFile file = new AuxServiceFile().srcFile(remoteClassPath).type(type);
            serviceConf.getFiles().add(file);
        }
        return new AuxServiceRecord().name(sName).configuration(serviceConf);
    }

    public synchronized void serviceInit(Configuration conf) throws Exception {
        boolean recoveryEnabled = conf.getBoolean("yarn.nodemanager.recovery.enabled", false);
        if (recoveryEnabled) {
            this.stateStoreRoot = new Path(conf.get("yarn.nodemanager.recovery.dir"), STATE_STORE_ROOT_NAME);
            this.stateStoreFs = FileSystem.getLocal((Configuration)conf);
        }
        this.manifestEnabled = conf.getBoolean("yarn.nodemanager.aux-services.manifest.enabled", false);
        if (!this.manifestEnabled) {
            Collection auxNames = conf.getStringCollection("yarn.nodemanager.aux-services");
            for (String sName : auxNames) {
                AuxServiceRecord service = AuxServices.createServiceRecordFromConfiguration(sName, conf);
                this.maybeRemoveAuxService(sName);
                AuxiliaryService s = this.initAuxService(service, conf, true);
                this.addService(sName, s, service);
            }
        } else {
            String manifestStr = conf.get("yarn.nodemanager.aux-services.manifest");
            if (manifestStr != null) {
                this.manifest = new Path(manifestStr);
                this.manifestFS = FileSystem.get((URI)new URI(manifestStr), (Configuration)conf);
                this.loadManifest(conf, false);
                this.manifestReloadInterval = conf.getLong("yarn.nodemanager.aux-services.manifest.reload-ms", 0L);
                this.manifestReloadTask = new ManifestReloadTask();
            } else {
                LOG.info("Auxiliary services manifest is enabled, but no manifest file is specified in the configuration.");
            }
        }
        super.serviceInit(conf);
    }

    private void startAuxService(String name, AuxiliaryService service, AuxServiceRecord serviceRecord) {
        service.start();
        service.registerServiceListener((ServiceStateChangeListener)this);
        ByteBuffer meta = service.getMetaData();
        if (meta != null) {
            this.serviceMetaData.put(name, meta);
        }
        serviceRecord.setLaunchTime(new Date());
    }

    private void stopAuxService(Service service) {
        if (service.getServiceState() == Service.STATE.STARTED) {
            service.unregisterServiceListener((ServiceStateChangeListener)this);
            service.stop();
        }
    }

    public synchronized void serviceStart() throws Exception {
        for (Map.Entry<String, AuxiliaryService> entry : this.serviceMap.entrySet()) {
            AuxiliaryService service = entry.getValue();
            String name = entry.getKey();
            this.startAuxService(name, service, this.serviceRecordMap.get(name));
        }
        if (this.manifestEnabled && this.manifest != null && this.manifestReloadInterval > 0L) {
            LOG.info("Scheduling reloading auxiliary services manifest file at interval " + this.manifestReloadInterval + " ms");
            this.manifestReloadTimer = new Timer("AuxServicesManifestReload-Timer", true);
            this.manifestReloadTimer.schedule(this.manifestReloadTask, this.manifestReloadInterval, this.manifestReloadInterval);
        }
        super.serviceStart();
    }

    public synchronized void serviceStop() throws Exception {
        try {
            for (Service service : this.serviceMap.values()) {
                this.stopAuxService(service);
            }
            this.serviceMap.clear();
            this.serviceRecordMap.clear();
            this.serviceMetaData.clear();
            if (this.manifestFS != null) {
                this.manifestFS.close();
            }
            if (this.manifestReloadTimer != null) {
                this.manifestReloadTimer.cancel();
            }
        }
        finally {
            super.serviceStop();
        }
    }

    public void stateChanged(Service service) {
        LOG.info("Service " + service.getName() + " changed state: " + service.getServiceState());
    }

    public void handle(AuxServicesEvent event) {
        LOG.info("Got event " + event.getType() + " for appId " + event.getApplicationID());
        switch ((AuxServicesEventType)event.getType()) {
            case APPLICATION_INIT: {
                LOG.info("Got APPLICATION_INIT for service " + event.getServiceID());
                AuxiliaryService service = null;
                try {
                    service = this.serviceMap.get(event.getServiceID());
                    service.initializeApplication(new ApplicationInitializationContext(event.getUser(), event.getApplicationID(), event.getServiceData()));
                }
                catch (Throwable th) {
                    this.logWarningWhenAuxServiceThrowExceptions(service, AuxServicesEventType.APPLICATION_INIT, th);
                }
                break;
            }
            case APPLICATION_STOP: {
                for (AuxiliaryService serv : this.serviceMap.values()) {
                    try {
                        serv.stopApplication(new ApplicationTerminationContext(event.getApplicationID()));
                    }
                    catch (Throwable th) {
                        this.logWarningWhenAuxServiceThrowExceptions(serv, AuxServicesEventType.APPLICATION_STOP, th);
                    }
                }
                break;
            }
            case CONTAINER_INIT: {
                for (AuxiliaryService serv : this.serviceMap.values()) {
                    try {
                        serv.initializeContainer(new ContainerInitializationContext(event.getContainer().getUser(), event.getContainer().getContainerId(), event.getContainer().getResource(), event.getContainer().getContainerTokenIdentifier().getContainerType()));
                    }
                    catch (Throwable th) {
                        this.logWarningWhenAuxServiceThrowExceptions(serv, AuxServicesEventType.CONTAINER_INIT, th);
                    }
                }
                break;
            }
            case CONTAINER_STOP: {
                for (AuxiliaryService serv : this.serviceMap.values()) {
                    try {
                        serv.stopContainer(new ContainerTerminationContext(event.getUser(), event.getContainer().getContainerId(), event.getContainer().getResource(), event.getContainer().getContainerTokenIdentifier().getContainerType()));
                    }
                    catch (Throwable th) {
                        this.logWarningWhenAuxServiceThrowExceptions(serv, AuxServicesEventType.CONTAINER_STOP, th);
                    }
                }
                break;
            }
            default: {
                throw new RuntimeException("Unknown type: " + event.getType());
            }
        }
    }

    private boolean validateAuxServiceName(String name) {
        if (name == null || name.trim().isEmpty()) {
            return false;
        }
        return this.p.matcher(name).matches();
    }

    private void logWarningWhenAuxServiceThrowExceptions(AuxiliaryService service, AuxServicesEventType eventType, Throwable th) {
        LOG.warn((String)(null == service ? "The auxService is null" : "The auxService name is " + service.getName()) + " and it got an error at event: " + eventType, th);
    }

    FileContext getLocalFileContext(Configuration conf) {
        try {
            return FileContext.getLocalFSFileContext((Configuration)conf);
        }
        catch (IOException e) {
            throw new YarnRuntimeException("Failed to access local fs");
        }
    }

    FileContext getRemoteFileContext(URI path, Configuration conf) {
        try {
            return FileContext.getFileContext((URI)path, (Configuration)conf);
        }
        catch (IOException e) {
            throw new YarnRuntimeException("Failed to access remote fs");
        }
    }

    private UserGroupInformation getRemoteUgi() {
        UserGroupInformation remoteUgi;
        try {
            remoteUgi = UserGroupInformation.getCurrentUser();
        }
        catch (IOException e) {
            String msg = "Cannot obtain the user-name. Got exception: " + StringUtils.stringifyException((Throwable)e);
            LOG.warn(msg);
            throw new YarnRuntimeException(msg);
        }
        return remoteUgi;
    }

    protected static AuxServiceRecord newAuxService(String name, String className) {
        AuxServiceConfiguration serviceConf = new AuxServiceConfiguration();
        serviceConf.setProperty(CLASS_NAME, className);
        return new AuxServiceRecord().name(name).configuration(serviceConf);
    }

    protected static void setClasspath(AuxServiceRecord service, String classpath) {
        service.getConfiguration().getFiles().add(new AuxServiceFile().srcFile(classpath).type(AuxServiceFile.TypeEnum.STATIC));
    }

    protected static void setSystemClasses(AuxServiceRecord service, String systemClasses) {
        service.getConfiguration().setProperty(SYSTEM_CLASSES, systemClasses);
    }

    protected FileSystem getManifestFS() {
        return this.manifestFS;
    }

    private final class ManifestReloadTask
    extends TimerTask {
        private ManifestReloadTask() {
        }

        @Override
        public void run() {
            try {
                AuxServices.this.reloadManifest();
            }
            catch (Throwable t) {
                LOG.warn("Error while reloading manifest: ", t);
            }
        }
    }
}

