/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.federation.store.sql;

import java.sql.Connection;
import java.sql.SQLException;
import org.apache.hadoop.classification.InterfaceAudience;

@InterfaceAudience.Private
public final class DatabaseProduct {
    private static final String SQL_SERVER_NAME = "sqlserver";
    private static final String MYSQL_NAME = "mysql";
    private static final String MARIADB_NAME = "mariadb";
    private static final String HSQLDB_NAME = "hsqldatabase";

    private DatabaseProduct() {
    }

    public static DbType getDbType(Connection conn) throws SQLException {
        if (conn == null) {
            return DbType.UNDEFINED;
        }
        String productName = DatabaseProduct.getProductName(conn);
        return DatabaseProduct.getDbType(productName);
    }

    private static DbType getDbType(String productName) {
        DbType dbt = (productName = productName.replaceAll("\\s+", "").toLowerCase()).contains(SQL_SERVER_NAME) ? DbType.SQLSERVER : (productName.contains(MYSQL_NAME) || productName.contains(MARIADB_NAME) ? DbType.MYSQL : (productName.contains(HSQLDB_NAME) ? DbType.HSQLDB : DbType.UNDEFINED));
        return dbt;
    }

    private static String getProductName(Connection conn) throws SQLException {
        return conn.getMetaData().getDatabaseProductName();
    }

    public static String addForUpdateClause(DbType dbType, String selectStatement) throws SQLException {
        switch (dbType) {
            case MYSQL: 
            case HSQLDB: {
                return selectStatement + " for update";
            }
            case SQLSERVER: {
                String modifier = " with (updlock)";
                int wherePos = selectStatement.toUpperCase().indexOf(" WHERE ");
                if (wherePos < 0) {
                    return selectStatement + modifier;
                }
                return selectStatement.substring(0, wherePos) + modifier + selectStatement.substring(wherePos, selectStatement.length());
            }
        }
        String msg = "Unrecognized database product name <" + dbType + ">";
        throw new SQLException(msg);
    }

    public static boolean isDuplicateKeyError(DbType dbType, SQLException ex) {
        switch (dbType) {
            case MYSQL: {
                if (ex.getErrorCode() != 1022 && ex.getErrorCode() != 1062 && ex.getErrorCode() != 1586 || !"23000".equals(ex.getSQLState())) break;
                return true;
            }
            case SQLSERVER: {
                if (ex.getErrorCode() != 2627 && ex.getErrorCode() != 2601 || !"23000".equals(ex.getSQLState())) break;
                return true;
            }
            default: {
                return false;
            }
        }
        return false;
    }

    public static enum DbType {
        MYSQL,
        SQLSERVER,
        POSTGRES,
        UNDEFINED,
        HSQLDB;

    }
}

