/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.federation.store.impl;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.metrics2.MetricsCollector;
import org.apache.hadoop.metrics2.MetricsInfo;
import org.apache.hadoop.metrics2.MetricsSource;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.annotation.Metric;
import org.apache.hadoop.metrics2.annotation.Metrics;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.lib.Interns;
import org.apache.hadoop.metrics2.lib.MetricsRegistry;
import org.apache.hadoop.metrics2.lib.MutableRate;

@InterfaceAudience.Private
@InterfaceStability.Unstable
@Metrics(context="ZKFederationStateStore-op-durations")
public final class ZKFederationStateStoreOpDurations
implements MetricsSource {
    @Metric(value={"Duration for a add application homeSubcluster call"})
    private MutableRate addAppHomeSubCluster;
    @Metric(value={"Duration for a update application homeSubcluster call"})
    private MutableRate updateAppHomeSubCluster;
    @Metric(value={"Duration for a get application homeSubcluster call"})
    private MutableRate getAppHomeSubCluster;
    @Metric(value={"Duration for a get applications homeSubcluster call"})
    private MutableRate getAppsHomeSubCluster;
    @Metric(value={"Duration for a delete applications homeSubcluster call"})
    private MutableRate deleteAppHomeSubCluster;
    @Metric(value={"Duration for a register subCluster call"})
    private MutableRate registerSubCluster;
    @Metric(value={"Duration for a deregister subCluster call"})
    private MutableRate deregisterSubCluster;
    @Metric(value={"Duration for a subCluster Heartbeat call"})
    private MutableRate subClusterHeartbeat;
    @Metric(value={"Duration for a get SubCluster call"})
    private MutableRate getSubCluster;
    @Metric(value={"Duration for a get SubClusters call"})
    private MutableRate getSubClusters;
    @Metric(value={"Duration for a get PolicyConfiguration call"})
    private MutableRate getPolicyConfiguration;
    @Metric(value={"Duration for a set PolicyConfiguration call"})
    private MutableRate setPolicyConfiguration;
    @Metric(value={"Duration for a get PolicyConfigurations call"})
    private MutableRate getPoliciesConfigurations;
    @Metric(value={"Duration for a add reservation homeSubCluster call"})
    private MutableRate addReservationHomeSubCluster;
    @Metric(value={"Duration for a get reservation homeSubCluster call"})
    private MutableRate getReservationHomeSubCluster;
    @Metric(value={"Duration for a get reservations homeSubCluster call"})
    private MutableRate getReservationsHomeSubCluster;
    @Metric(value={"Duration for a delete reservation homeSubCluster call"})
    private MutableRate deleteReservationHomeSubCluster;
    @Metric(value={"Duration for a update reservation homeSubCluster call"})
    private MutableRate updateReservationHomeSubCluster;
    @Metric(value={"Duration for a store new master key call"})
    private MutableRate storeNewMasterKey;
    @Metric(value={"Duration for a remove new master key call"})
    private MutableRate removeStoredMasterKey;
    @Metric(value={"Duration for a get master key by delegation key call"})
    private MutableRate getMasterKeyByDelegationKey;
    @Metric(value={"Duration for a store new token call"})
    private MutableRate storeNewToken;
    @Metric(value={"Duration for a update stored token call"})
    private MutableRate updateStoredToken;
    @Metric(value={"Duration for a remove stored token call"})
    private MutableRate removeStoredToken;
    @Metric(value={"Duration for a get token by router store token call"})
    private MutableRate getTokenByRouterStoreToken;
    protected static final MetricsInfo RECORD_INFO = Interns.info((String)"ZKFederationStateStoreOpDurations", (String)"Durations of ZKFederationStateStore calls");
    private final MetricsRegistry registry = new MetricsRegistry(RECORD_INFO);
    private static final ZKFederationStateStoreOpDurations INSTANCE = new ZKFederationStateStoreOpDurations();

    public static ZKFederationStateStoreOpDurations getInstance() {
        return INSTANCE;
    }

    private ZKFederationStateStoreOpDurations() {
        this.registry.tag(RECORD_INFO, "ZKFederationStateStoreOpDurations");
        MetricsSystem ms = DefaultMetricsSystem.instance();
        if (ms != null) {
            ms.register(RECORD_INFO.name(), RECORD_INFO.description(), (Object)this);
        }
    }

    public synchronized void getMetrics(MetricsCollector collector, boolean all) {
        this.registry.snapshot(collector.addRecord(this.registry.info()), all);
    }

    public void addAppHomeSubClusterDuration(long startTime, long endTime) {
        this.addAppHomeSubCluster.add(endTime - startTime);
    }

    public void addUpdateAppHomeSubClusterDuration(long startTime, long endTime) {
        this.updateAppHomeSubCluster.add(endTime - startTime);
    }

    public void addGetAppHomeSubClusterDuration(long startTime, long endTime) {
        this.getAppHomeSubCluster.add(endTime - startTime);
    }

    public void addGetAppsHomeSubClusterDuration(long startTime, long endTime) {
        this.getAppsHomeSubCluster.add(endTime - startTime);
    }

    public void addDeleteAppHomeSubClusterDuration(long startTime, long endTime) {
        this.deleteAppHomeSubCluster.add(endTime - startTime);
    }

    public void addRegisterSubClusterDuration(long startTime, long endTime) {
        this.registerSubCluster.add(endTime - startTime);
    }

    public void addDeregisterSubClusterDuration(long startTime, long endTime) {
        this.deregisterSubCluster.add(endTime - startTime);
    }

    public void addSubClusterHeartbeatDuration(long startTime, long endTime) {
        this.subClusterHeartbeat.add(endTime - startTime);
    }

    public void addGetSubClusterDuration(long startTime, long endTime) {
        this.getSubCluster.add(endTime - startTime);
    }

    public void addGetSubClustersDuration(long startTime, long endTime) {
        this.getSubClusters.add(endTime - startTime);
    }

    public void addGetPolicyConfigurationDuration(long startTime, long endTime) {
        this.getPolicyConfiguration.add(endTime - startTime);
    }

    public void addSetPolicyConfigurationDuration(long startTime, long endTime) {
        this.setPolicyConfiguration.add(endTime - startTime);
    }

    public void addGetPoliciesConfigurationsDuration(long startTime, long endTime) {
        this.getPoliciesConfigurations.add(endTime - startTime);
    }

    public void addReservationHomeSubClusterDuration(long startTime, long endTime) {
        this.addReservationHomeSubCluster.add(endTime - startTime);
    }

    public void addGetReservationHomeSubClusterDuration(long startTime, long endTime) {
        this.getReservationHomeSubCluster.add(endTime - startTime);
    }

    public void addGetReservationsHomeSubClusterDuration(long startTime, long endTime) {
        this.getReservationsHomeSubCluster.add(endTime - startTime);
    }

    public void addDeleteReservationHomeSubClusterDuration(long startTime, long endTime) {
        this.deleteReservationHomeSubCluster.add(endTime - startTime);
    }

    public void addUpdateReservationHomeSubClusterDuration(long startTime, long endTime) {
        this.updateReservationHomeSubCluster.add(endTime - startTime);
    }

    public void addStoreNewMasterKeyDuration(long startTime, long endTime) {
        this.storeNewMasterKey.add(endTime - startTime);
    }

    public void removeStoredMasterKeyDuration(long startTime, long endTime) {
        this.removeStoredMasterKey.add(endTime - startTime);
    }

    public void getMasterKeyByDelegationKeyDuration(long startTime, long endTime) {
        this.getMasterKeyByDelegationKey.add(endTime - startTime);
    }

    public void getStoreNewTokenDuration(long startTime, long endTime) {
        this.storeNewToken.add(endTime - startTime);
    }

    public void updateStoredTokenDuration(long startTime, long endTime) {
        this.updateStoredToken.add(endTime - startTime);
    }

    public void removeStoredTokenDuration(long startTime, long endTime) {
        this.removeStoredToken.add(endTime - startTime);
    }

    public void getTokenByRouterStoreTokenDuration(long startTime, long endTime) {
        this.getTokenByRouterStoreToken.add(endTime - startTime);
    }

    @VisibleForTesting
    protected ZKFederationStateStoreOpDurations resetOpDurations() {
        return new ZKFederationStateStoreOpDurations();
    }
}

