/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public abstract class GetGroupsTestBase {
    protected Configuration conf;
    private UserGroupInformation testUser1;
    private UserGroupInformation testUser2;

    protected abstract Tool getTool(PrintStream var1);

    @BeforeEach
    public void setUpUsers() throws IOException {
        UserGroupInformation currentUser = UserGroupInformation.getCurrentUser();
        UserGroupInformation.createUserForTesting((String)currentUser.getUserName(), (String[])currentUser.getGroupNames());
        this.testUser1 = UserGroupInformation.createUserForTesting((String)"foo", (String[])new String[]{"bar", "baz"});
        this.testUser2 = UserGroupInformation.createUserForTesting((String)"fiz", (String[])new String[]{"buz", "boz"});
    }

    @Test
    public void testNoUserGiven() throws Exception {
        String actualOutput = this.runTool(this.conf, new String[0], true);
        UserGroupInformation currentUser = UserGroupInformation.getCurrentUser();
        Assertions.assertEquals((Object)GetGroupsTestBase.getExpectedOutput(currentUser), (Object)actualOutput, (String)"No user provided should default to current user");
    }

    @Test
    public void testExistingUser() throws Exception {
        String actualOutput = this.runTool(this.conf, new String[]{this.testUser1.getUserName()}, true);
        Assertions.assertEquals((Object)GetGroupsTestBase.getExpectedOutput(this.testUser1), (Object)actualOutput, (String)"Show only the output of the user given");
    }

    @Test
    public void testMultipleExistingUsers() throws Exception {
        String actualOutput = this.runTool(this.conf, new String[]{this.testUser1.getUserName(), this.testUser2.getUserName()}, true);
        Assertions.assertEquals((Object)(GetGroupsTestBase.getExpectedOutput(this.testUser1) + GetGroupsTestBase.getExpectedOutput(this.testUser2)), (Object)actualOutput, (String)"Show the output for both users given");
    }

    @Test
    public void testNonExistentUser() throws Exception {
        String actualOutput = this.runTool(this.conf, new String[]{"does-not-exist"}, true);
        Assertions.assertEquals((Object)GetGroupsTestBase.getExpectedOutput(UserGroupInformation.createRemoteUser((String)"does-not-exist")), (Object)actualOutput, (String)"Show the output for only the user given, with no groups");
    }

    @Test
    public void testMultipleNonExistingUsers() throws Exception {
        String actualOutput = this.runTool(this.conf, new String[]{"does-not-exist1", "does-not-exist2"}, true);
        Assertions.assertEquals((Object)(GetGroupsTestBase.getExpectedOutput(UserGroupInformation.createRemoteUser((String)"does-not-exist1")) + GetGroupsTestBase.getExpectedOutput(UserGroupInformation.createRemoteUser((String)"does-not-exist2"))), (Object)actualOutput, (String)"Show the output for only the user given, with no groups");
    }

    @Test
    public void testExistingInterleavedWithNonExistentUsers() throws Exception {
        String actualOutput = this.runTool(this.conf, new String[]{"does-not-exist1", this.testUser1.getUserName(), "does-not-exist2", this.testUser2.getUserName()}, true);
        Assertions.assertEquals((Object)(GetGroupsTestBase.getExpectedOutput(UserGroupInformation.createRemoteUser((String)"does-not-exist1")) + GetGroupsTestBase.getExpectedOutput(this.testUser1) + GetGroupsTestBase.getExpectedOutput(UserGroupInformation.createRemoteUser((String)"does-not-exist2")) + GetGroupsTestBase.getExpectedOutput(this.testUser2)), (Object)actualOutput, (String)"Show the output for only the user given, with no groups");
    }

    private static String getExpectedOutput(UserGroupInformation user) {
        String expectedOutput = user.getUserName() + " :";
        for (String group : user.getGroupNames()) {
            expectedOutput = expectedOutput + " " + group;
        }
        return expectedOutput + System.getProperty("line.separator");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String runTool(Configuration conf, String[] args, boolean success) throws Exception {
        ByteArrayOutputStream o = new ByteArrayOutputStream();
        PrintStream out = new PrintStream(o, true);
        try {
            int ret = ToolRunner.run((Tool)this.getTool(out), (String[])args);
            Assertions.assertEquals((Object)success, (Object)(ret == 0 ? 1 : 0));
            String string = o.toString();
            return string;
        }
        finally {
            o.close();
            out.close();
        }
    }
}

