/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.test;

import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import org.apache.hadoop.shaded.org.assertj.core.api.AbstractBooleanAssert;
import org.apache.hadoop.shaded.org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.Assertions;

public class MoreAsserts {
    public static <T> void assertEquals(String s, T[] expected, Iterable<T> actual) {
        int i;
        Iterator<T> it = actual.iterator();
        for (i = 0; i < expected.length && it.hasNext(); ++i) {
            Assertions.assertEquals(expected[i], it.next(), (String)("Element " + i + " for " + s));
        }
        Assertions.assertTrue((i == expected.length ? 1 : 0) != 0, (String)"Expected more elements");
        Assertions.assertTrue((!it.hasNext() ? 1 : 0) != 0, (String)"Expected less elements");
    }

    public static <T> void assertEquals(String s, Iterable<T> expected, Iterable<T> actual) {
        Iterator<T> ite = expected.iterator();
        Iterator<T> ita = actual.iterator();
        int i = 0;
        while (ite.hasNext() && ita.hasNext()) {
            Assertions.assertEquals(ite.next(), ita.next(), (String)("Element " + i + " for " + s));
        }
        Assertions.assertTrue((!ite.hasNext() ? 1 : 0) != 0, (String)"Expected more elements");
        Assertions.assertTrue((!ita.hasNext() ? 1 : 0) != 0, (String)"Expected less elements");
    }

    public static <T> void assertFutureCompletedSuccessfully(CompletableFuture<T> future) {
        ((AbstractBooleanAssert)org.apache.hadoop.shaded.org.assertj.core.api.Assertions.assertThat((boolean)future.isDone()).describedAs("This future is supposed to be completed successfully", new Object[0])).isTrue();
        ((AbstractBooleanAssert)org.apache.hadoop.shaded.org.assertj.core.api.Assertions.assertThat((boolean)future.isCompletedExceptionally()).describedAs("This future is supposed to be completed successfully", new Object[0])).isFalse();
    }

    public static <T> void assertFutureFailedExceptionally(CompletableFuture<T> future) {
        ((AbstractBooleanAssert)org.apache.hadoop.shaded.org.assertj.core.api.Assertions.assertThat((boolean)future.isCompletedExceptionally()).describedAs("This future is supposed to be completed exceptionally", new Object[0])).isTrue();
    }

    public static <T> void assertEqual(T actual, T expected, String message) {
        ((ObjectAssert)org.apache.hadoop.shaded.org.assertj.core.api.Assertions.assertThat(actual).describedAs("Mismatch in %s", new Object[]{message})).isEqualTo(expected);
    }
}

