/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.test;

import java.io.Closeable;
import org.apache.hadoop.shaded.org.mockito.Mockito;
import org.apache.hadoop.shaded.org.mockito.invocation.InvocationOnMock;
import org.apache.hadoop.shaded.org.mockito.stubbing.Answer;
import org.apache.hadoop.shaded.org.mockito.stubbing.Stubber;

public abstract class MockitoUtil {
    public static <T> T mockProtocol(Class<T> clazz) {
        return Mockito.mock(clazz, Mockito.withSettings().extraInterfaces(Closeable.class));
    }

    public static Stubber doThrowWhenCallStackMatches(final Throwable t, final String pattern) {
        return Mockito.doAnswer(new Answer<Object>(){

            @Override
            public Object answer(InvocationOnMock invocation) throws Throwable {
                t.setStackTrace(Thread.currentThread().getStackTrace());
                for (StackTraceElement elem : t.getStackTrace()) {
                    if (!elem.toString().matches(pattern)) continue;
                    throw t;
                }
                return invocation.callRealMethod();
            }
        });
    }

    public static void verifyZeroInteractions(Object ... mocks) {
        Mockito.verifyNoInteractions(mocks);
    }
}

