/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.test;

import java.util.concurrent.TimeUnit;
import org.apache.hadoop.test.TestName;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.api.extension.RegisterExtension;

@Timeout(value=100000L, unit=TimeUnit.MILLISECONDS)
public abstract class HadoopTestBase
extends Assertions {
    public static final String PROPERTY_TEST_DEFAULT_TIMEOUT = "test.default.timeout";
    public static final int TEST_DEFAULT_TIMEOUT_VALUE = 100000;
    private int defaultTimeout = this.retrieveTestTimeout();
    @RegisterExtension
    private TestName methodName = new TestName();

    protected int retrieveTestTimeout() {
        int millis;
        String propval = System.getProperty(PROPERTY_TEST_DEFAULT_TIMEOUT, Integer.toString(100000));
        try {
            millis = Integer.parseInt(propval);
        }
        catch (NumberFormatException e) {
            millis = 100000;
        }
        return millis;
    }

    protected String getMethodName() {
        return this.methodName.getMethodName();
    }

    @BeforeAll
    public static void nameTestThread() {
        Thread.currentThread().setName("JUnit");
    }

    @BeforeEach
    public void nameThreadToMethod() {
        Thread.currentThread().setName("JUnit-" + this.getMethodName());
    }
}

