/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.mockito.internal.verification;

import java.util.Set;
import org.apache.hadoop.shaded.org.mockito.internal.verification.VerificationEventImpl;
import org.apache.hadoop.shaded.org.mockito.internal.verification.api.VerificationData;
import org.apache.hadoop.shaded.org.mockito.listeners.VerificationListener;
import org.apache.hadoop.shaded.org.mockito.verification.VerificationEvent;
import org.apache.hadoop.shaded.org.mockito.verification.VerificationMode;

public class MockAwareVerificationMode
implements VerificationMode {
    private final Object mock;
    private final VerificationMode mode;
    private final Set<VerificationListener> listeners;

    public MockAwareVerificationMode(Object mock, VerificationMode mode, Set<VerificationListener> listeners) {
        this.mock = mock;
        this.mode = mode;
        this.listeners = listeners;
    }

    @Override
    public void verify(VerificationData data) {
        try {
            this.mode.verify(data);
            this.notifyListeners(new VerificationEventImpl(this.mock, this.mode, data, null));
        }
        catch (Error | RuntimeException e) {
            this.notifyListeners(new VerificationEventImpl(this.mock, this.mode, data, e));
            throw e;
        }
    }

    private void notifyListeners(VerificationEvent event) {
        for (VerificationListener listener : this.listeners) {
            listener.onVerification(event);
        }
    }

    public Object getMock() {
        return this.mock;
    }
}

