/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.mockito.internal.verification;

import java.util.List;
import org.apache.hadoop.shaded.org.mockito.exceptions.base.MockitoException;
import org.apache.hadoop.shaded.org.mockito.internal.verification.api.VerificationData;
import org.apache.hadoop.shaded.org.mockito.internal.verification.api.VerificationDataInOrder;
import org.apache.hadoop.shaded.org.mockito.internal.verification.api.VerificationInOrderMode;
import org.apache.hadoop.shaded.org.mockito.internal.verification.checkers.MissingInvocationChecker;
import org.apache.hadoop.shaded.org.mockito.internal.verification.checkers.NumberOfInvocationsChecker;
import org.apache.hadoop.shaded.org.mockito.invocation.Invocation;
import org.apache.hadoop.shaded.org.mockito.invocation.MatchableInvocation;
import org.apache.hadoop.shaded.org.mockito.verification.VerificationMode;

public class Calls
implements VerificationMode,
VerificationInOrderMode {
    final int wantedCount;

    public Calls(int wantedNumberOfInvocations) {
        if (wantedNumberOfInvocations <= 0) {
            throw new MockitoException("Negative and zero values are not allowed here");
        }
        this.wantedCount = wantedNumberOfInvocations;
    }

    @Override
    public void verify(VerificationData data) {
        throw new MockitoException("calls is only intended to work with InOrder");
    }

    @Override
    public void verifyInOrder(VerificationDataInOrder data) {
        List<Invocation> allInvocations = data.getAllInvocations();
        MatchableInvocation wanted = data.getWanted();
        MissingInvocationChecker.checkMissingInvocation(allInvocations, wanted, data.getOrderingContext());
        NumberOfInvocationsChecker.checkNumberOfInvocationsNonGreedy(allInvocations, wanted, this.wantedCount, data.getOrderingContext());
    }

    public String toString() {
        return "Wanted invocations count (non-greedy): " + this.wantedCount;
    }
}

